/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ClassFileWriter;

final class ClassFileField {
    private short itsNameIndex;
    private short itsTypeIndex;
    private short itsFlags;
    private boolean itsHasAttributes;
    private short itsAttr1;
    private short itsAttr2;
    private short itsAttr3;
    private int itsIndex;

    ClassFileField(short s, short s2, short s3) {
        this.itsNameIndex = s;
        this.itsTypeIndex = s2;
        this.itsFlags = s3;
        this.itsHasAttributes = false;
    }

    void setAttributes(short s, short s2, short s3, int n) {
        this.itsHasAttributes = true;
        this.itsAttr1 = s;
        this.itsAttr2 = s2;
        this.itsAttr3 = s3;
        this.itsIndex = n;
    }

    int write(byte[] byArray, int n) {
        n = ClassFileWriter.putInt16(this.itsFlags, byArray, n);
        n = ClassFileWriter.putInt16(this.itsNameIndex, byArray, n);
        n = ClassFileWriter.putInt16(this.itsTypeIndex, byArray, n);
        if (!this.itsHasAttributes) {
            n = ClassFileWriter.putInt16(0, byArray, n);
        } else {
            n = ClassFileWriter.putInt16(1, byArray, n);
            n = ClassFileWriter.putInt16(this.itsAttr1, byArray, n);
            n = ClassFileWriter.putInt16(this.itsAttr2, byArray, n);
            n = ClassFileWriter.putInt16(this.itsAttr3, byArray, n);
            n = ClassFileWriter.putInt16(this.itsIndex, byArray, n);
        }
        return n;
    }

    int getWriteSize() {
        int n = 6;
        n = !this.itsHasAttributes ? (n += 2) : (n += 10);
        return n;
    }
}

