/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;

public class ComputedColumn
implements IComputedColumn {
    protected String name;
    protected IBaseExpression expr;
    protected int dataType;
    private String aggrFuntion;
    private List argument;
    private IScriptExpression filter;

    public ComputedColumn(String name, String expr) {
        this.name = name;
        this.expr = new ScriptExpression(expr);
        this.dataType = 0;
        this.aggrFuntion = null;
    }

    public ComputedColumn(String name, String expr, int dataType) {
        this.name = name;
        this.expr = new ScriptExpression(expr);
        this.dataType = dataType;
        this.aggrFuntion = null;
    }

    public ComputedColumn(String name, String expr, int dataType, String aggrFunction, IScriptExpression filter, List argument) {
        this.name = name;
        this.expr = expr != null ? new ScriptExpression(expr) : null;
        this.dataType = dataType;
        this.aggrFuntion = aggrFunction;
        this.argument = argument;
        this.filter = filter;
    }

    public ComputedColumn(String name, IScriptExpression expr, int dataType, String aggrFunction, IScriptExpression filter, List argument) {
        this.name = name;
        this.expr = expr;
        this.dataType = dataType;
        this.aggrFuntion = aggrFunction;
        this.argument = argument;
        this.filter = filter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IBaseExpression getExpression() {
        return this.expr;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public String getAggregateFunction() {
        return this.aggrFuntion;
    }

    @Override
    public List getAggregateArgument() {
        return this.argument;
    }

    @Override
    public IScriptExpression getAggregateFilter() {
        return this.filter;
    }
}

