/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.updater;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DeleteHelper {
    public static void deleteDirectories(Path path, String glob) throws IOException {
        PathMatcher matcher = path.getFileSystem().getPathMatcher("glob:" + glob);
        if (Files.isDirectory(path, new LinkOption[0])) {
            DeleteDirectories deleteDirectories = new DeleteDirectories(matcher);
            Files.walkFileTree(path, deleteDirectories);
        }
    }

    public static void deleteFiles(Path path, String glob) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            PathMatcher matcher = path.getFileSystem().getPathMatcher("glob:" + glob);
            DeleteFiles deleteFiles = new DeleteFiles(matcher);
            Files.walkFileTree(path, deleteFiles);
        }
    }

    public static void deleteDirectory(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            DeleteDirectory deleteDirectory = new DeleteDirectory();
            Files.walkFileTree(path, deleteDirectory);
        }
    }

    public static void deleteDirectoryOnExit(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            DeleteDirectoryOnExit deleteDirectory = new DeleteDirectoryOnExit();
            Files.walkFileTree(path, deleteDirectory);
        }
    }

    public static class DeleteDirectories
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;
        private Path deleteDir;

        protected DeleteDirectories(PathMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.deleteDir == null && this.matcher.matches(dir.getFileName())) {
                System.out.println("Delete directory: " + dir);
                this.deleteDir = dir;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.deleteDir != null) {
                Files.deleteIfExists(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (this.deleteDir != null) {
                Files.deleteIfExists(dir);
                if (dir.equals(this.deleteDir)) {
                    this.deleteDir = null;
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static class DeleteFiles
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;

        protected DeleteFiles(PathMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.matcher.matches(file.getFileName())) {
                System.out.println("Delete file: " + file);
                Files.deleteIfExists(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static class DeleteDirectoryOnExit
    extends SimpleFileVisitor<Path> {
        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            System.out.println("Delete directory on exit: " + dir);
            dir.toFile().deleteOnExit();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            file.toFile().deleteOnExit();
            return FileVisitResult.CONTINUE;
        }
    }

    public static class DeleteDirectory
    extends SimpleFileVisitor<Path> {
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            System.out.println("Delete directory: " + dir);
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

