/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSampleCategory;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImpotSampleCategoryAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImpotSampleCategoryAction.class);
    private final PersistenceService persistenceService;

    public ImpotSampleCategoryAction(GenericFormatContextSupport importContext, PersistenceService persistenceService) {
        super(importContext);
        this.persistenceService = persistenceService;
    }

    @Override
    protected boolean canExecute() {
        return true;
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validate sample category model.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel", (Object[])new Object[0]));
        ArrayList<SampleCategoryModelEntry> categories = new ArrayList<SampleCategoryModelEntry>();
        GenericFormatCsvFileResult importFileResult = this.importContext.getSampleCategoryFileResult();
        try (CsvConsumerForSampleCategory consumer = this.importContext.loadSampleCategories(false);){
            HashSet<String> existingCodes = new HashSet<String>();
            HashSet<Integer> existingCaracteristicIds = new HashSet<Integer>();
            for (ImportRow row : consumer) {
                consumer.validateRow(row, existingCodes, existingCaracteristicIds);
                if (!row.isValid()) continue;
                SampleCategoryRow bean = (SampleCategoryRow)row.getBean();
                categories.add(bean.getSampleCategoryModelEntry());
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close sampleCategory.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        if (importFileResult.isValid()) {
            SampleCategoryModel sampleCategoryModel = new SampleCategoryModel(categories);
            if (log.isInfoEnabled()) {
                log.info((Object)("Will use sample category model: " + sampleCategoryModel));
            }
            this.persistenceService.setSampleCategoryModel(sampleCategoryModel);
            this.importContext.setImportedSampleCategoryModel(sampleCategoryModel);
        }
    }
}

