/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Function;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class GenericFormatImportOperationResult
implements Serializable {
    public static final Function<GenericFormatImportOperationResult, FishingOperation> TO_FISHING_OPERATION_FUNCTION = new Function<GenericFormatImportOperationResult, FishingOperation>(){

        public FishingOperation apply(GenericFormatImportOperationResult input) {
            return input.getFishingOperation();
        }
    };
    private static final long serialVersionUID = 1L;
    private final Set<String> checkErrors;
    private final FishingOperation fishingOperation;
    private final CatchBatch catchBatch;
    private int nbGearFeautres;
    private int nbVesselFeautres;
    private int nbAccidentalCatches;
    private int nbMarineLitters;
    private int nbIndividualObservations;
    private int nbSpeciesBatchesVrac;
    private int nbSpeciesBatchesHorsVrac;
    private int nbBenthosBatchesVrac;
    private int nbBenthosBatchesHorsVrac;

    public GenericFormatImportOperationResult(GenericFormatImportOperationContext operationContext) {
        this.fishingOperation = operationContext.getFishingOperation();
        this.catchBatch = operationContext.getCatchBatch();
        this.checkErrors = new LinkedHashSet<String>();
        this.flushContext(operationContext);
    }

    public void addCheckError(String error) {
        this.checkErrors.add(error);
    }

    public Set<String> getCheckErrors() {
        return this.checkErrors;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public int getNbGearFeautres() {
        return this.nbGearFeautres;
    }

    public int getNbVesselFeautres() {
        return this.nbVesselFeautres;
    }

    public int getNbAccidentalCatches() {
        return this.nbAccidentalCatches;
    }

    public int getNbMarineLitters() {
        return this.nbMarineLitters;
    }

    public int getNbIndividualObservations() {
        return this.nbIndividualObservations;
    }

    public int getNbSpeciesBatchesVrac() {
        return this.nbSpeciesBatchesVrac;
    }

    public int getNbSpeciesBatchesHorsVrac() {
        return this.nbSpeciesBatchesHorsVrac;
    }

    public int getNbBenthosBatchesVrac() {
        return this.nbBenthosBatchesVrac;
    }

    public int getNbBenthosBatchesHorsVrac() {
        return this.nbBenthosBatchesHorsVrac;
    }

    protected void flushContext(GenericFormatImportOperationContext operationContext) {
        if (operationContext.withGearFeatures()) {
            this.nbGearFeautres = operationContext.getGearUseFeatures().size();
        }
        if (operationContext.withVesselFeatures()) {
            this.nbVesselFeautres = operationContext.getVesselUseFeatures().size();
        }
        if (operationContext.withAccidentalBatches()) {
            this.nbAccidentalCatches = operationContext.getAccidentalBatches().size();
        }
        if (operationContext.withMarineLitterBatches()) {
            this.nbMarineLitters = operationContext.getMarineLitterBatches().size();
        }
        if (operationContext.withIndividualObservationBatches()) {
            this.nbIndividualObservations = operationContext.getIndividualObservationBatches().size();
        }
        if (operationContext.withSpeciesBatches(true)) {
            this.nbSpeciesBatchesVrac = operationContext.getSpeciesBatches(true).size();
        }
        if (operationContext.withSpeciesBatches(false)) {
            this.nbSpeciesBatchesHorsVrac = operationContext.getSpeciesBatches(false).size();
        }
        if (operationContext.withBenthosBatches(true)) {
            this.nbBenthosBatchesVrac = operationContext.getBenthosBatches(true).size();
        }
        if (operationContext.withBenthosBatches(false)) {
            this.nbBenthosBatchesHorsVrac = operationContext.getBenthosBatches(false).size();
        }
        this.checkErrors.addAll(operationContext.getCheckErrors());
    }
}

