/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GenericFormatImportCruiseResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Function<GenericFormatImportCruiseResult, Cruise> TO_CRUISE_FUNCTION = new Function<GenericFormatImportCruiseResult, Cruise>(){

        public Cruise apply(GenericFormatImportCruiseResult input) {
            return input.getCruise();
        }
    };
    private final Cruise cruise;
    private final boolean override;
    private final Map<String, GenericFormatImportOperationResult> fishingOperationResults;

    public GenericFormatImportCruiseResult(GenericFormatImportCruiseContext cruiseContext) {
        this.cruise = cruiseContext.getCruise();
        this.override = cruiseContext.isOverride();
        this.fishingOperationResults = new HashMap<String, GenericFormatImportOperationResult>();
        for (GenericFormatImportOperationContext operationContext : cruiseContext.getFishingOperationContexts()) {
            GenericFormatImportOperationResult operationResult = new GenericFormatImportOperationResult(operationContext);
            this.fishingOperationResults.put(operationContext.getFishingOperation().getId(), operationResult);
        }
    }

    public Cruise getCruise() {
        return this.cruise;
    }

    public boolean isOverride() {
        return this.override;
    }

    public GenericFormatImportOperationResult getFishingOperationResult(String fishingOperationId) {
        return this.fishingOperationResults.get(fishingOperationId);
    }

    public Collection<String> getFishingOperationIds() {
        return this.fishingOperationResults.keySet();
    }

    public Set<FishingOperation> getFishingOperations() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.fishingOperationResults.values(), GenericFormatImportOperationResult.TO_FISHING_OPERATION_FUNCTION));
    }
}

