/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryGearService;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryGear;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportReferentialGearAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportReferentialGearAction.class);
    private final ReferentialTemporaryGearService referentialTemporaryGearService;

    public ImportReferentialGearAction(GenericFormatImportContext importContext, ReferentialTemporaryGearService referentialTemporaryGearService) {
        super(importContext);
        this.referentialTemporaryGearService = referentialTemporaryGearService;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getReferentialTemporaryGearFileResult().isFound();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import temporary gears.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.temporaryGears", (Object[])new Object[0]));
        ReferentialImportRequest<Gear, Integer> referentialImportRequest = this.referentialTemporaryGearService.createReferentialImportRequest();
        GenericFormatReferentialImportResult<Gear, Integer> importFileResult = this.importContext.getReferentialTemporaryGearFileResult();
        try (CsvConsumerForTemporaryGear consumer = this.importContext.loadTemporaryGears(false);){
            for (ImportRow row : consumer) {
                consumer.checkRowForGenericFormatImport(row, referentialImportRequest);
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close gears.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        if (importFileResult.isValid()) {
            ReferentialImportResult<Gear> referentialImportResult = this.referentialTemporaryGearService.executeImportRequest(referentialImportRequest);
            importFileResult.flushResult(referentialImportRequest, referentialImportResult);
            if (log.isInfoEnabled()) {
                log.info((Object)("Temporary gears import result: " + importFileResult.getReport()));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Do not import temporary gears (the incoming file is not valid)");
        }
    }

    @Override
    protected void skipExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Skip import temporary gears (no file found).");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.temporaryGears", (Object[])new Object[0]));
    }
}

