/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.CaracteristicParserFormatter;
import fr.ifremer.tutti.service.csv.CaracteristicValueParserFormatter;
import fr.ifremer.tutti.service.csv.FishingOperationLocationParserFormatter;
import fr.ifremer.tutti.service.csv.FishingOperationStrataParserFormatter;
import fr.ifremer.tutti.service.csv.FishingOperationSubStrataParserFormatter;
import fr.ifremer.tutti.service.csv.GearListParserFormatter;
import fr.ifremer.tutti.service.csv.GearParserFormatter;
import fr.ifremer.tutti.service.csv.HarbourParserFormatter;
import fr.ifremer.tutti.service.csv.PersonListParserFormatter;
import fr.ifremer.tutti.service.csv.PersonParserFormatter;
import fr.ifremer.tutti.service.csv.ProgramParserFormatter;
import fr.ifremer.tutti.service.csv.SpeciesParserFormatter;
import fr.ifremer.tutti.service.csv.VesselListParserFormatter;
import fr.ifremer.tutti.service.csv.VesselParserFormatter;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import java.util.List;

public class GenericFormatImportEntityParserFactory {
    private final PersistenceService persistenceService;
    private final GenericFormatImportContext importContext;
    private ProgramParserFormatter programParser;
    private VesselParserFormatter vesselParser;
    private HarbourParserFormatter harbourParser;
    private GearParserFormatter gearParser;
    private GearListParserFormatter gearListParser;
    private PersonListParserFormatter personListParser;
    private CaracteristicParserFormatter caracteristicParser;
    private CaracteristicParserFormatter caracteristicWithProtectedParser;
    private CaracteristicParserFormatter caracteristicForSampleCategoryParser;
    private FishingOperationStrataParserFormatter fishingOperationStrataParser;
    private FishingOperationSubStrataParserFormatter fishingOperationSubStrataParser;
    private FishingOperationLocationParserFormatter fishingOperationLocationParser;
    private VesselListParserFormatter vesselListParser;
    private SpeciesParserFormatter speciesParser;
    private CaracteristicValueParserFormatter marineLitterCategoryValueParser;
    private CaracteristicValueParserFormatter marineLitterSizeCategoryValueParser;

    public GenericFormatImportEntityParserFactory(PersistenceService persistenceService, GenericFormatImportContext importContext) {
        this.persistenceService = persistenceService;
        this.importContext = importContext;
    }

    public VesselParserFormatter getVesselParser() {
        if (this.vesselParser == null) {
            this.vesselParser = VesselParserFormatter.newParser(this.persistenceService, this.importContext.getReferentialTemporaryVesselFileResult().getIdTranslationMap());
        }
        return this.vesselParser;
    }

    public HarbourParserFormatter getHarbourParser() {
        if (this.harbourParser == null) {
            this.harbourParser = HarbourParserFormatter.newParser(this.persistenceService);
        }
        return this.harbourParser;
    }

    public GearParserFormatter getGearParser() {
        if (this.gearParser == null) {
            this.gearParser = GearParserFormatter.newParser(this.persistenceService, this.importContext.getReferentialTemporaryGearFileResult().getIdTranslationMap());
        }
        return this.gearParser;
    }

    public GearListParserFormatter getGearListParser() {
        if (this.gearListParser == null) {
            GearParserFormatter delegateParserFormatter = this.getGearParser();
            this.gearListParser = GearListParserFormatter.newParser(delegateParserFormatter);
        }
        return this.gearListParser;
    }

    public PersonListParserFormatter getPersonListParser() {
        if (this.personListParser == null) {
            PersonParserFormatter delegateParserFormatter = PersonParserFormatter.newParser(this.persistenceService, this.importContext.getReferentialTemporaryPersonFileResult().getIdTranslationMap());
            this.personListParser = PersonListParserFormatter.newParser(delegateParserFormatter);
        }
        return this.personListParser;
    }

    public ProgramParserFormatter getProgramParser() {
        if (this.programParser == null) {
            this.programParser = ProgramParserFormatter.newParser(this.persistenceService);
        }
        return this.programParser;
    }

    public CaracteristicParserFormatter getCaracteristicParser() {
        if (this.caracteristicParser == null) {
            List<Caracteristic> caracteristics = this.persistenceService.getAllCaracteristic();
            this.caracteristicParser = CaracteristicParserFormatter.newParser(caracteristics);
        }
        return this.caracteristicParser;
    }

    public CaracteristicParserFormatter getCaracteristicWithProtectedParser() {
        if (this.caracteristicWithProtectedParser == null) {
            List<Caracteristic> caracteristics = this.persistenceService.getAllCaracteristicWithProtected();
            this.caracteristicWithProtectedParser = CaracteristicParserFormatter.newParser(caracteristics);
        }
        return this.caracteristicWithProtectedParser;
    }

    public CaracteristicParserFormatter getCaracteristicForSampleCategoryParser() {
        if (this.caracteristicForSampleCategoryParser == null) {
            List<Caracteristic> caracteristics = this.persistenceService.getAllCaracteristicForSampleCategory();
            this.caracteristicForSampleCategoryParser = CaracteristicParserFormatter.newParser(caracteristics);
        }
        return this.caracteristicForSampleCategoryParser;
    }

    public FishingOperationStrataParserFormatter getFishingOperationStrataParser() {
        if (this.fishingOperationStrataParser == null) {
            Program program = this.importContext.getImportRequest().getProgram();
            this.fishingOperationStrataParser = FishingOperationStrataParserFormatter.newParser(this.persistenceService, program.getZone().getId());
        }
        return this.fishingOperationStrataParser;
    }

    public FishingOperationSubStrataParserFormatter getFishingOperationSubStrataParser() {
        if (this.fishingOperationSubStrataParser == null) {
            Program program = this.importContext.getImportRequest().getProgram();
            this.fishingOperationSubStrataParser = FishingOperationSubStrataParserFormatter.newParser(this.persistenceService, program.getZone().getId());
        }
        return this.fishingOperationSubStrataParser;
    }

    public FishingOperationLocationParserFormatter getFishingOperationLocationParser() {
        if (this.fishingOperationLocationParser == null) {
            Program program = this.importContext.getImportRequest().getProgram();
            this.fishingOperationLocationParser = FishingOperationLocationParserFormatter.newParser(this.persistenceService, program.getZone().getId());
        }
        return this.fishingOperationLocationParser;
    }

    public VesselListParserFormatter getVesselListParser() {
        if (this.vesselListParser == null) {
            this.vesselListParser = VesselListParserFormatter.newParser(this.getVesselParser());
        }
        return this.vesselListParser;
    }

    public SpeciesParserFormatter getSpeciesParser() {
        if (this.speciesParser == null) {
            this.speciesParser = SpeciesParserFormatter.newParser(this.persistenceService, this.importContext.getReferentialTemporarySpeciesFileResult().getIdTranslationMap());
        }
        return this.speciesParser;
    }

    public CaracteristicValueParserFormatter getMarineLitterCategoryValueParser() {
        if (this.marineLitterCategoryValueParser == null) {
            this.marineLitterCategoryValueParser = CaracteristicValueParserFormatter.newParser(this.persistenceService.getMarineLitterCategoryCaracteristic());
        }
        return this.marineLitterCategoryValueParser;
    }

    public CaracteristicValueParserFormatter getMarineLitterSizeCategoryValueParser() {
        if (this.marineLitterSizeCategoryValueParser == null) {
            this.marineLitterSizeCategoryValueParser = CaracteristicValueParserFormatter.newParser(this.persistenceService.getMarineLitterSizeCategoryCaracteristic());
        }
        return this.marineLitterSizeCategoryValueParser;
    }
}

