package fr.ifremer.tutti.ui.swing.util.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class EnterWeightUI extends JDialog implements TuttiUI<TuttiUIContext, EnterWeightUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ORIGINAL_WEIGHT = "originalWeight";
    public static final String PROPERTY_WEIGHT_LABEL = "weightLabel";
    public static final String PROPERTY_WEIGHT_UNIT = "weightUnit";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DIALOG_TITLE = "dialog.title";
    public static final String BINDING_EDITOR_NUMBER_PATTERN = "editor.numberPattern";
    public static final String BINDING_EDITOR_NUMBER_VALUE = "editor.numberValue";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Vz28bRRSemNiJ7bQpjVoFtYBLkbAJrMuPSkgpUAiNSOW0Ue00Fb4w3p3YE83ODrNva6dWEH8CfwLcuSBx44Q4cObABfEvIMSBa8WbWXvXjp3aag4b75v3vvfeN+99+8PfJBtqcu2I9nqOjiRwnzl3P3n06H7riLnwGQtdzRUEmsR/CxmSaZKil9hDINebNRNeHYRXtwJfBZLJkejNGimEcCxY2GEMgLw8HuGGYbWeHG/2VKSHqElR01C/+/efzLfeN99nCOkprK6ArZRmRaWdLNZIhntALmKmx7QqqGxjGZrLNtZ7zti2BA3De9RnX5GvyVKN5BTVCAbktflbthg2vqeA5DxORdAG8v6hdvihZj7TDkQA3Im4E3YxuRMBF45Lwe2w0LkjgekDxtsd2N9RyiLlgGT9wGMCSPlsmIZ53d/ZChChB2losWvRarRlAC6YPh3TuxP3njqeDzRvc0lFnB7Iauq7LQI6glmIMfclR7fSRE1wrJhzkLiMtAG0JRiQ9bFbG9RvjoxfPnHPMY8jt0A2At12ZIQv0rGhXe61GYRo81uY9p79d8d6m9j1BGL59bt7VDJxA+/dtNMbZIut4+lWXCpdJj7FHpBEsjbmH1uN5yspY4+p4B4Flh5eH3hocmWsR5x5J535dCgXmiSrIzQjKc3JNXmAR/GCrJ9aEANoT59eXvvj579+2h5uxTLmvjTVdWSpcVqVDhTTwE3q1XglzCRWd6nabJJ8yAQqgt34q1MKqw+OsTjM96KdFDvIn9OwgxDZpT9/+fXyl7+/QDLbpIDT421T479D8tDRyEIgvJ76+LataKW7jM8LpjYzIxzMjNzsd6j0BN4u3nTD2Mr44yAd5nLlrVJiMXNWrlROekjV1SlUJfW28r/9t1b/8faQrgUs/6Uz3VPKsl+QHJeCS2ZlZKAQU2WjqEIWeUGqBNO0gSTioAb7sWGf1QlOloAsRSGr8zYOZfaQihDZydMIgr1ARSq1FeNteEhFhG+X+kjO/bGVLldOgJyLvfYooNIg4pv9UyQavkcXauBpg/N4cd0HLDSqvgja5Fk1JlvJcHGG9RTiTA1UA0zbtxriuIYDvCbT63uWf/PrJkm2fRYdiyYzKhyQN2K1GUonS6XTwVnjqBXxQmMl8fuOa8rLDa0r/J0P5K5kfiC5C+TGnHCOn4QUIQhEg6uGrWdjXgDgahoBY/ozi4YsTgWTRjPxk3alH3Nnrm7XfCnKldK1D0syEuIkoasys7yhnJ0mjLouUzBB2LtzA55J2dvzQ5xB2ikNnkUbCkxO0OMAncn5WxhHSy0uPZT4jybQF8yzMAdi0eeS+5Ff50+sBhw9P1QetZE/ib+SF2/FglPCBdS8FQF77hqNmT+jtFcR4X8WFnkoHQoAAA==";
    private static final Log log = LogFactory.getLog(EnterWeightUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected EnterWeightUI dialog = this;
    protected NumberEditor editor;
    protected final EnterWeightUIHandler handler = createHandler();
    protected TuttiUIContext model;
    protected Float originalWeight;
    protected Table table;
    protected JButton validateButton;
    protected String weightLabel;
    protected WeightUnit weightUnit;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public Float openAndGetWeightValue(String weightLabel, Float originalWeight, WeightUnit weightUnit) {
        return handler.openAndGetWeightValue(weightLabel, originalWeight, weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EnterWeightUI(TuttiUIContext context) {
        super(context.getMainUI(), true);
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public EnterWeightUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI() {
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0) {
        super(param0);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EnterWeightUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EnterWeightUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public EnterWeightUIHandler getHandler() {
        return handler;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public Float getOriginalWeight() {
        return originalWeight;
    }

    public Table getTable() {
        return table;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public String getWeightLabel() {
        return weightLabel;
    }

    public WeightUnit getWeightUnit() {
        return weightUnit;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOriginalWeight(Float originalWeight) {
        Float oldValue = this.originalWeight;
        this.originalWeight = originalWeight;
        firePropertyChange(PROPERTY_ORIGINAL_WEIGHT, oldValue, originalWeight);
    }

    public void setWeightLabel(String weightLabel) {
        String oldValue = this.weightLabel;
        this.weightLabel = weightLabel;
        firePropertyChange(PROPERTY_WEIGHT_LABEL, oldValue, weightLabel);
    }

    public void setWeightUnit(WeightUnit weightUnit) {
        WeightUnit oldValue = this.weightUnit;
        this.weightUnit = weightUnit;
        firePropertyChange(PROPERTY_WEIGHT_UNIT, oldValue, weightUnit);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.catches.enterWeight.action.cancel"));
        cancelButton.setToolTipText(t("tutti.catches.enterWeight.action.cancel.tip"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setUseSign(false);
        editor.setAutoPopup(false);
        editor.setShowReset(true);
        editor.setShowPopupButton(false);
    }

    protected EnterWeightUIHandler createHandler() {
        return new EnterWeightUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createOriginalWeight() {
        $objectMap.put("originalWeight", originalWeight = null);
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.catches.enterWeight.action.validate"));
        validateButton.setToolTipText(t("tutti.catches.enterWeight.action.validate.tip"));
    }

    protected void createWeightLabel() {
        $objectMap.put("weightLabel", weightLabel = null);
    }

    protected void createWeightUnit() {
        $objectMap.put("weightUnit", weightUnit = WeightUnit.KG);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDialog();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        setMinimumSize(new Dimension(350,100));
        editor.setNumberType(Float.class);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.catches.enterWeight.action.cancel.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("accept"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.catches.enterWeight.action.validate.mnemonic"),'Z'));
        // late initializer
        dialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("dialog", dialog);
        createModel();
        createWeightLabel();
        createOriginalWeight();
        createWeightUnit();
        createTable();
        createEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of dialog
        setName("dialog");
        dialog.getContentPane().setLayout(new BorderLayout());
        setResizable(false);
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DIALOG_TITLE, true ,"weightLabel" ,"weightUnit") {
        
            @Override
            public void processDataBinding() {
                setTitle(t(handler.getTitle(getWeightLabel(), getWeightUnit())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_NUMBER_PATTERN, true ,"weightUnit") {
        
            @Override
            public void processDataBinding() {
                if (getWeightUnit() != null) {
                    editor.setNumberPattern(getWeightUnit().getNumberEditorPattern());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_NUMBER_VALUE, true ,"originalWeight") {
        
            @Override
            public void processDataBinding() {
                editor.setNumberValue(getOriginalWeight());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null) {
                    validateButton.setEnabled(editor.getModel() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("model", this);
                }
            }
        });
    }

}