/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Map;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.treebuild.ContentNode;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContentNodeState
extends AbstractParseState {
    protected boolean isCDataSection = false;
    protected ModuleParserHandler handler = null;
    protected ContentNode parentNode = null;
    protected ContentNode node = null;
    protected String nodeName = null;

    public ContentNodeState(String tagName, ModuleParserHandler theHandler, ContentNode parent) {
        this.nodeName = tagName;
        this.handler = theHandler;
        this.parentNode = parent;
    }

    public ContentNodeState(String tagName, ModuleParserHandler theHandler, ContentNode parent, Map<String, Object> attributes) {
        this.nodeName = tagName;
        this.handler = theHandler;
        this.parentNode = parent;
        this.node = new ContentNode(this.nodeName);
        this.node.setAttributes(attributes);
    }

    @Override
    public XMLParserHandler getHandler() {
        return this.handler;
    }

    @Override
    public void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        this.node = new ContentNode(this.nodeName);
        this.initAttrs(attrs);
    }

    private void initAttrs(Attributes attrs) {
        String name;
        int i = 0;
        while (i < attrs.getLength()) {
            name = attrs.getQName(i);
            String value = attrs.getValue(i);
            this.node.setAttribute(name, value);
            ++i;
        }
        ElementDefn elementDefn = (ElementDefn)MetaDataDictionary.getInstance().getElementByXmlName(this.node.getName());
        if (elementDefn != null) {
            name = (String)this.node.getAttribute("name");
            String idString = (String)this.node.getAttribute("id");
            if (!StringUtil.isBlank(name)) {
                this.handler.module.getNameHelper().addContentName(elementDefn.getNameSpaceID(), name);
            }
            if (!StringUtil.isBlank(idString)) {
                try {
                    long id = Long.parseLong(idString);
                    if (id > 0L) {
                        this.handler.module.addElementID(id);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        return new ContentNodeState(tagName, this.handler, this.node);
    }

    @Override
    public void end() throws SAXException {
        this.node.setValue(this.text.toString());
        this.node.setCDATASection(this.isCDataSection);
        this.parentNode.addChild(this.node);
        super.end();
    }

    @Override
    public void setIsCDataSection(boolean isCDataSection) {
        this.isCDataSection = isCDataSection;
    }
}

