package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class AttachmentItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ATTACHMENT = "attachment";
    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_NAME_LABEL_TEXT = "attachmentNameLabel.text";
    public static final String BINDING_ATTACHMENT_NAME_LABEL_TOOL_TIP_TEXT = "attachmentNameLabel.toolTipText";
    public static final String BINDING_ATTACHMENT_PANEL_TOOL_TIP_TEXT = "attachmentPanel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVPW8TQRCdGOzEDp8JRHxK5kMoCFiLAgkRIJBARJCBiAQJ4Ya1bx0vOu8tu2M4hED8BH4C9DRIdFSIgpqCBvEXEKKgRcze2b44PpMEiSvO5915s+/Nzbx78x2y1sChBzwMmWkplE3Brl++e/dW9YGo4RVha0ZqDAzE11AGMhUY9brrFuFIpezgpTa8NBs0daCEWoGeKkPB4hNf2IYQiHCwF1GztrTY3Z4Kdct0snZJpWV99fNH5qX34nUGINTEboSkFNdCJUo2lyEjPYQxOukRL/lcLRMNI9Uy8d3q1mZ9bu1N3hQP4TkMlyGnuaFkCIfXLznKEeFDjbCdI/Jao0mxC1wJH+Fs3TBZN6IpDMMWomQtyexjYsFaKH2WANjl7uM8iqbWUdocQiGJQTjTl08LY6VFoWqCUYhEKSzzOPIVCZNkww2uPF8YhNl/YXbVk6T+zvy1OEuSdzwJdxUt86pTP+bKHLazXo8WXXw+oYNB4Fc50dnVE7pEyzPc9AbvCrRQCZcZIh0oOroHGa86xO4EaPkjsRro9vb1xk1QNYK/RxrY39OC1Nwsae6k+4YqkDUtWkbYU+mfh9u0FU/CnlWT4BJGu78nxr+8//ZurtP+w3T27tTQFdNLbakNlcm4LqB+jHvfvc/SDa6nKpC3wqfRj0b7QAqxxfY2kaPzdjp43A7XuG1Qiuzw1w8fJ+5/3gSZOSj4AffmuIufhzw2DFUh8L1QT1+KGG15PEL3HY4bwqh71UtSL4mQ+njmaaFIV9I1xUMXiqrl+8Xp4rLA5BVMHi8yt0JD2P57LoorPAupegdSqteVUM1/+jW++PZSp4JDpGjvwPCkitl7kJPKl0pEFtJ2h1TLGNVWtLwgcYE0X4B+Y9DtyTka3Sf76pVB2IxRoaY3WijHbkWV/kvhHemTUUXdE4P0+V+HyHydWgh51afZyda5b+l3azUwnjALXCoUXmc97dCOe6x10CZnojWUgZqvOcfIOyM5VZfu1C3y9Fl1Q9HgK1lDOBFbIV/leCyGMwdkzW50b2mPrQOLUqcpSbW2jcrKSfpOGdyoJmeO/6opwg7SlOa6G9bk0Xhi/3s69XdesZEPVDW5LvQAXQO+EmspIwvM+fxJQMGw7bz7QBerUnn00brYd8qQuxco4x+x85CKwgkAAA==";
    private static final Log log = LogFactory.getLog(AttachmentItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Attachment attachment;
    protected JLabel attachmentNameLabel;
    protected AttachmentItem attachmentPanel = this;
    protected AttachmentEditorUIHandler handler;
    protected JButton openAttachmentButton;
    protected JButton removeAttachmentButton;
    protected JButton saveAttachmentButton;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentItem(Attachment attachment, AttachmentEditorUIHandler handler) {
        this.attachment = attachment;
            this.handler = handler;
            $initialize();
    }

    public AttachmentItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem() {
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openAttachment(attachment);
    }

    public void doActionPerformed__on__removeAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeAttachment(this);
    }

    public void doActionPerformed__on__saveAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAttachment(attachment);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Attachment getAttachment() {
        return attachment;
    }

    public JLabel getAttachmentNameLabel() {
        return attachmentNameLabel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenAttachmentButton() {
        return openAttachmentButton;
    }

    public JButton getRemoveAttachmentButton() {
        return removeAttachmentButton;
    }

    public JButton getSaveAttachmentButton() {
        return saveAttachmentButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAttachment(Attachment attachment) {
        Attachment oldValue = this.attachment;
        this.attachment = attachment;
        firePropertyChange(PROPERTY_ATTACHMENT, oldValue, attachment);
    }

    public void setHandler(AttachmentEditorUIHandler handler) {
        AttachmentEditorUIHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentNameLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openAttachmentButton);
        toolbar.add(saveAttachmentButton);
        toolbar.add(removeAttachmentButton);
    }

    protected void createAttachment() {
        $objectMap.put("attachment", attachment = null);
    }

    protected void createAttachmentNameLabel() {
        $objectMap.put("attachmentNameLabel", attachmentNameLabel = new JLabel());
        
        attachmentNameLabel.setName("attachmentNameLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createOpenAttachmentButton() {
        $objectMap.put("openAttachmentButton", openAttachmentButton = new JButton());
        
        openAttachmentButton.setName("openAttachmentButton");
        openAttachmentButton.setToolTipText(t("tutti.attachmentEditor.action.open.tip"));
        openAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openAttachmentButton"));
    }

    protected void createRemoveAttachmentButton() {
        $objectMap.put("removeAttachmentButton", removeAttachmentButton = new JButton());
        
        removeAttachmentButton.setName("removeAttachmentButton");
        removeAttachmentButton.setToolTipText(t("tutti.attachmentEditor.action.remove.tip"));
        removeAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeAttachmentButton"));
    }

    protected void createSaveAttachmentButton() {
        $objectMap.put("saveAttachmentButton", saveAttachmentButton = new JButton());
        
        saveAttachmentButton.setName("saveAttachmentButton");
        saveAttachmentButton.setToolTipText(t("tutti.attachmentEditor.action.save.tip"));
        saveAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAttachmentButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentPanel();
        addChildrenToToolbar();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        openAttachmentButton.setIcon(SwingUtil.createActionIcon("open-file"));
        openAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.attachmentEditor.action.open.mnemonic"),'Z'));
        saveAttachmentButton.setIcon(SwingUtil.createActionIcon("import"));
        saveAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.attachmentEditor.action.save.mnemonic"),'Z'));
        removeAttachmentButton.setIcon(SwingUtil.createActionIcon("delete"));
        removeAttachmentButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.attachmentEditor.action.remove.mnemonic"),'Z'));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("attachmentPanel", attachmentPanel);
        createAttachment();
        createHandler();
        createAttachmentNameLabel();
        createToolbar();
        createOpenAttachmentButton();
        createSaveAttachmentButton();
        createRemoveAttachmentButton();
        // inline creation of attachmentPanel
        setName("attachmentPanel");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_PANEL_TOOL_TIP_TEXT, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                if (getAttachment() != null) {
                    setToolTipText(t(
                        attachment != null ? getAttachment() . getComment() : null
                    ));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TEXT, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                if (getAttachment() != null) {
                    attachmentNameLabel.setText(t(
                        attachment != null ? getAttachment() . getName() : null
                    ));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TOOL_TIP_TEXT, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                if (getAttachment() != null) {
                    attachmentNameLabel.setToolTipText(t(
                        attachment != null ? getAttachment() . getComment() : null
                    ));
                }
            }
        });
    }

}