/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.query.internal;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryName;
import fr.ifremer.adagio.synchro.query.internal.SynchroAbstractQuery;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SynchroSelectQuery
extends SynchroAbstractQuery {
    protected String selectClause;
    protected String fromClause;
    protected List<String> joins = null;
    protected boolean columnDistinct;

    public SynchroSelectQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, String fromClause, String whereClause) {
        super(queryName, tableName, columnNames, true);
        this.setWhereClause(whereClause);
        this.fromClause = fromClause;
        this.columnDistinct = false;
    }

    public SynchroSelectQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, String whereClause) {
        super(queryName, tableName, columnNames, true);
        this.setWhereClause(whereClause);
        this.fromClause = null;
        this.columnDistinct = false;
    }

    @Override
    public String toSql() {
        StringBuilder selectParams = new StringBuilder();
        if (this.selectClause != null) {
            selectParams.append("  ").append(this.selectClause);
        } else {
            String tableAliasSubstitute = "";
            if (StringUtils.isNotBlank((CharSequence)this.tableAlias)) {
                tableAliasSubstitute = this.tableAlias + ".";
            }
            for (String columnName : this.columnNames) {
                if (StringUtils.isNotBlank((CharSequence)this.tableAlias)) {
                    columnName = columnName.replace("~~alias~~", tableAliasSubstitute);
                }
                selectParams.append(", ").append(columnName);
            }
        }
        StringBuilder fromParams = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.fromClause)) {
            fromParams.append(this.fromClause);
        } else {
            fromParams.append(this.tableName);
            if (StringUtils.isNotBlank((CharSequence)this.tableAlias)) {
                fromParams.append(' ').append(this.tableAlias);
            }
        }
        StringBuilder joinBuffer = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.joins)) {
            for (String join : this.joins) {
                joinBuffer.append(" ").append(join.trim());
            }
        }
        String sql = String.format("SELECT %s%s FROM %s%s%s", this.columnDistinct ? "DISTINCT " : "", selectParams.substring(2), fromParams.toString(), joinBuffer.toString(), this.getSqlWhereClause());
        return sql;
    }

    @Override
    public SynchroQueryBuilder setColumnDistinct(boolean columnDistinct) {
        this.columnDistinct = columnDistinct;
        return this;
    }

    @Override
    public SynchroQueryBuilder addJoin(String joinClause) {
        if (this.joins == null) {
            this.joins = Lists.newArrayList((Object[])new String[]{joinClause});
        } else {
            this.joins.add(joinClause);
        }
        return this;
    }
}

