/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import org.eclipse.birt.core.framework.jar.Bundle;
import org.eclipse.birt.core.framework.jar.ConfigurationElement;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class Extension
implements IExtension {
    protected Bundle bundle;
    protected String namespace;
    protected String uniqueId;
    protected String name;
    protected String extensionPointId;
    protected String label;
    protected ConfigurationElement[] configuration;

    Extension(Bundle bundle, String id) {
        this.bundle = bundle;
        int dotAt = id.lastIndexOf(46);
        if (dotAt == -1) {
            this.namespace = bundle.getSymbolicName();
            this.name = id;
            if (id.length() != 0) {
                this.uniqueId = String.valueOf(this.namespace) + "." + id;
            }
        } else {
            this.uniqueId = id;
            this.name = id.substring(dotAt + 1);
        }
    }

    public IConfigurationElement[] getConfigurationElements() {
        return this.configuration;
    }

    public String getExtensionPointUniqueIdentifier() {
        return this.extensionPointId;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUniqueIdentifier() {
        return this.uniqueId != null ? this.uniqueId : this.getNamespaceIdentifier();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.uniqueId);
        sb.append(" extends ");
        sb.append(this.extensionPointId);
        sb.append(" from ");
        sb.append(this.bundle.getSymbolicName());
        return sb.toString();
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return this.bundle.getContributor();
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() throws InvalidRegistryObjectException {
        return null;
    }

    public String getLabel(String arg0) throws InvalidRegistryObjectException {
        return null;
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.bundle.getSymbolicName();
    }

    public String getSimpleIdentifier() throws InvalidRegistryObjectException {
        return this.name;
    }

    public boolean isValid() {
        return true;
    }
}

