/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.DriverExtensionManifest;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.ExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;
import org.osgi.framework.Bundle;

public class DriverExtensionHelper {
    public static String getEffectiveDataSourceId(String odaDataSourceId) throws OdaException {
        ExtensionManifest odaDataSourceManifest;
        if (odaDataSourceId == null) {
            return null;
        }
        try {
            odaDataSourceManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
        }
        catch (IllegalArgumentException ex) {
            throw new OdaException((Throwable)ex);
        }
        Class driverClass = DriverExtensionHelper.loadDriverClass(odaDataSourceManifest);
        String bridgeDataSourceId = DriverExtensionHelper.getDriverBridgeId(driverClass);
        if (bridgeDataSourceId == null || bridgeDataSourceId.equalsIgnoreCase(odaDataSourceId)) {
            return odaDataSourceId;
        }
        return DriverExtensionHelper.getEffectiveDataSourceId(bridgeDataSourceId);
    }

    static String getDriverBridgeId(Class odaDriverClass) {
        if (odaDriverClass == null) {
            throw new IllegalArgumentException();
        }
        String bridgeDataSourceId = DriverExtensionHelper.getDriverBridgeId(odaDriverClass.getName());
        if (bridgeDataSourceId != null) {
            return bridgeDataSourceId;
        }
        Class<?>[] driverTypes = odaDriverClass.getInterfaces();
        int i = 0;
        while (i < driverTypes.length) {
            bridgeDataSourceId = DriverExtensionHelper.getDriverBridgeId(driverTypes[i].getName());
            if (bridgeDataSourceId != null) {
                return bridgeDataSourceId;
            }
            ++i;
        }
        return null;
    }

    private static String getDriverBridgeId(String driverType) {
        DriverExtensionManifest manifest = null;
        try {
            manifest = ExtensionExplorer.getInstance().getDriverExtensionManifest(driverType);
        }
        catch (OdaException odaException) {}
        return manifest != null ? manifest.getBridgeDataSourceId() : null;
    }

    static Class loadDriverClass(ExtensionManifest driverConfig) throws OdaException {
        String driverClassName = DriverExtensionHelper.getRuntimeInterface(driverConfig).getDriverClass();
        Bundle bundle = Platform.getBundle((String)driverConfig.getNamespace());
        try {
            return bundle != null ? bundle.loadClass(driverClassName) : Class.forName(driverClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    static JavaRuntimeInterface getRuntimeInterface(ExtensionManifest driverConfig) {
        if (driverConfig == null) {
            throw new IllegalArgumentException();
        }
        RuntimeInterface runtime = driverConfig.getRuntimeInterface();
        assert (runtime instanceof JavaRuntimeInterface);
        return (JavaRuntimeInterface)runtime;
    }
}

