/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AngleType implements Enumerator
{
    NONE_LITERAL(0, "None", "None"),
    X_LITERAL(1, "X", "X"),
    Y_LITERAL(2, "Y", "Y"),
    Z_LITERAL(3, "Z", "Z");

    public static final int NONE = 0;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int Z = 3;
    private static final AngleType[] VALUES_ARRAY;
    public static final List<AngleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AngleType[]{NONE_LITERAL, X_LITERAL, Y_LITERAL, Z_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AngleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AngleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AngleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AngleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AngleType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return X_LITERAL;
            }
            case 2: {
                return Y_LITERAL;
            }
            case 3: {
                return Z_LITERAL;
            }
        }
        return null;
    }

    private AngleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

