/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class SynchroTableOperation
implements SynchroOperationRepository {
    private Map<String, Map<String, Object>> missingUpdates = Maps.newHashMap();
    private List<List<Object>> missingDeletes = Lists.newArrayList();
    private List<List<Object>> missingDetachs = Lists.newArrayList();
    private Map<String, Map<Set<String>, List<List<Object>>>> childrenToUpdate = Maps.newHashMap();
    private Map<String, Map<Set<String>, List<List<Object>>>> childrenToDelete = Maps.newHashMap();
    private Map<String, Map<Set<String>, List<List<Object>>>> childrenToDetach = Maps.newHashMap();
    private final String tableName;
    private final SynchroContext context;
    private boolean enableProgress = false;
    private boolean allowMissingDeletes = true;

    public SynchroTableOperation(String tableName, SynchroContext context) {
        this.tableName = tableName;
        this.context = context;
    }

    public SynchroTableOperation(String parentTableName, String tableName, String filterColumName, List<List<Object>> filterColumValues, SynchroContext context) {
        this.tableName = parentTableName;
        this.context = context;
        this.addChildrenToUpdateFromManyColumns(tableName, Sets.newHashSet((Object[])new String[]{filterColumName}), filterColumValues);
    }

    public SynchroTableOperation(String parentTableName, String tableName, Set<String> filterColumNames, List<List<Object>> filterColumValues, SynchroContext context) {
        this.tableName = parentTableName;
        this.context = context;
        this.addChildrenToUpdateFromManyColumns(tableName, filterColumNames, filterColumValues);
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isAllowMissingDeletes() {
        return this.allowMissingDeletes;
    }

    public void setAllowMissingDeletes(boolean allowMissingDeletes) {
        this.allowMissingDeletes = allowMissingDeletes;
    }

    @Override
    public SynchroContext getSynchroContext() {
        return this.context;
    }

    public boolean isEnableProgress() {
        return this.enableProgress;
    }

    public void setEnableProgress(boolean enableProgress) {
        this.enableProgress = enableProgress;
    }

    @Override
    public void addMissingColumnUpdate(String columnName, List<Object> pk, Object columnValue) {
        Preconditions.checkNotNull(pk);
        this.addMissingColumnUpdate(columnName, SynchroTableMetadata.toPkStr(pk), columnValue);
    }

    @Override
    public void addMissingColumnUpdate(String columnName, String pkStr, Object columnValue) {
        Preconditions.checkNotNull((Object)pkStr);
        IdentityHashMap destRows = this.missingUpdates.get(columnName);
        if (destRows == null) {
            destRows = Maps.newIdentityHashMap();
            this.missingUpdates.put(columnName, destRows);
        }
        destRows.put(pkStr, columnValue);
    }

    @Override
    public void addAllMissingDelete(List<List<Object>> pks) {
        Preconditions.checkNotNull(pks);
        this.missingDeletes.addAll(pks);
    }

    @Override
    public void addMissingDelete(List<Object> pk) {
        Preconditions.checkNotNull(pk);
        this.missingDeletes.add(pk);
    }

    @Override
    public void addMissingDelete(String pkStr) {
        Preconditions.checkNotNull((Object)pkStr);
        List<Object> pk = SynchroTableMetadata.fromPkStr(pkStr);
        this.missingDeletes.add(pk);
    }

    @Override
    public void addAllMissingDetach(List<List<Object>> pks) {
        Preconditions.checkNotNull(pks);
        this.missingDetachs.addAll(pks);
    }

    @Override
    public void addMissingDetach(List<Object> pk) {
        Preconditions.checkNotNull(pk);
        this.missingDetachs.add(pk);
    }

    @Override
    public void addMissingDetach(String pkStr) {
        Preconditions.checkNotNull((Object)pkStr);
        List<Object> pk = SynchroTableMetadata.fromPkStr(pkStr);
        this.missingDetachs.add(pk);
    }

    @Override
    public void addAllMissingColumnUpdates(Map<String, Map<String, Object>> missingUpdates) {
        this.missingUpdates.putAll(missingUpdates);
    }

    @Override
    public void addChildToUpdateFromOneColumn(String childTablename, String columnName, Object columnValue) {
        this.addChildToUpdateFromManyColumns(childTablename, (Set<String>)ImmutableSet.of((Object)columnName), (List<Object>)ImmutableList.of((Object)columnValue));
    }

    @Override
    public void addChildrenToUpdateFromOneColumn(String childTablename, String columnName, List<Object> columnValues) {
        ArrayList values = Lists.newArrayListWithCapacity((int)columnValues.size());
        for (Object singleValue : columnValues) {
            values.add(ImmutableList.of((Object)singleValue));
        }
        this.addChildrenToUpdateFromManyColumns(childTablename, (Set<String>)ImmutableSet.of((Object)columnName), values);
    }

    @Override
    public void addChildToUpdateFromManyColumns(String childTablename, Set<String> columnNames, List<Object> columnValues) {
        List childColumnValues;
        HashMap childTable = this.childrenToUpdate.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childrenToUpdate.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnNames)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnNames, childColumnValues);
        }
        childColumnValues.add(columnValues);
    }

    @Override
    public void addChildrenToUpdateFromManyColumns(String childTablename, Set<String> columnNames, List<List<Object>> columnValues) {
        List childColumnValues;
        HashMap childTable = this.childrenToUpdate.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childrenToUpdate.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnNames)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnNames, childColumnValues);
        }
        childColumnValues.addAll(columnValues);
    }

    @Override
    public void addChildToDeleteFromOneColumn(String childTablename, String columnName, Object columnValue) {
        this.addChildToDeleteFromManyColumns(childTablename, (Set<String>)ImmutableSet.of((Object)columnName), (List<Object>)ImmutableList.of((Object)columnValue));
    }

    @Override
    public void addChildrenToDeleteFromOneColumn(String childTablename, String columnName, List<Object> columnValues) {
        ArrayList values = Lists.newArrayListWithCapacity((int)columnValues.size());
        for (Object singleValue : columnValues) {
            values.add(ImmutableList.of((Object)singleValue));
        }
        this.addChildrenToDeleteFromManyColumns(childTablename, (Set<String>)ImmutableSet.of((Object)columnName), values);
    }

    @Override
    public void addChildToDeleteFromManyColumns(String childTablename, Set<String> columnNames, List<Object> columnValue) {
        List childColumnValues;
        HashMap childTable = this.childrenToDelete.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childrenToDelete.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnNames)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnNames, childColumnValues);
        }
        childColumnValues.add(columnValue);
    }

    @Override
    public void addChildrenToDeleteFromManyColumns(String childTablename, Set<String> columnNames, List<List<Object>> columnValues) {
        List childColumnValues;
        HashMap childTable = this.childrenToDelete.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childrenToDelete.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnNames)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnNames, childColumnValues);
        }
        childColumnValues.addAll(columnValues);
    }

    @Override
    public void addChildToDetachFromOneColumn(String childTablename, String columnName, Object columnValue) {
        this.addChildToDetachFromManyColumn(childTablename, (Set<String>)ImmutableSet.of((Object)columnName), (List<Object>)ImmutableList.of((Object)columnValue));
    }

    @Override
    public void addChildToDetachFromManyColumn(String childTablename, Set<String> columnNames, List<Object> columnValue) {
        List childColumnValues;
        HashMap childTable = this.childrenToDetach.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childrenToDetach.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnNames)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnNames, childColumnValues);
        }
        childColumnValues.add(columnValue);
    }

    @Override
    public void addChildrenToDetachFromManyColumns(String childTablename, Set<String> columnNames, List<List<Object>> columnValues) {
        List childColumnValues;
        HashMap childTable = this.childrenToDetach.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childrenToDetach.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnNames)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnNames, childColumnValues);
        }
        childColumnValues.addAll(columnValues);
    }

    public Map<String, Map<Set<String>, List<List<Object>>>> getChildrenToUpdate() {
        return ImmutableMap.copyOf(this.childrenToUpdate);
    }

    public boolean hasChildrenToUpdate() {
        return MapUtils.isNotEmpty(this.childrenToUpdate);
    }

    public Map<String, Map<Set<String>, List<List<Object>>>> getChildrenToDelete() {
        return ImmutableMap.copyOf(this.childrenToDelete);
    }

    public Map<String, Map<Set<String>, List<List<Object>>>> getChildrenToDetach() {
        return ImmutableMap.copyOf(this.childrenToDetach);
    }

    public boolean hasChildrenToDelete() {
        return MapUtils.isNotEmpty(this.childrenToDelete);
    }

    public boolean hasChildrenToDetach() {
        return MapUtils.isNotEmpty(this.childrenToDetach);
    }

    public Map<String, Map<String, Object>> getMissingUpdates() {
        return ImmutableMap.copyOf(this.missingUpdates);
    }

    public List<List<Object>> getMissingDeletes() {
        return ImmutableList.copyOf(this.missingDeletes);
    }

    public List<List<Object>> getMissingDetachs() {
        return ImmutableList.copyOf(this.missingDetachs);
    }

    public boolean isEmpty() {
        return MapUtils.isEmpty(this.missingUpdates) && CollectionUtils.isEmpty(this.missingDeletes) && CollectionUtils.isEmpty(this.missingDetachs) && MapUtils.isEmpty(this.childrenToUpdate) && MapUtils.isEmpty(this.childrenToDelete) && MapUtils.isEmpty(this.childrenToDetach);
    }

    public void clearMissingUpdates() {
        this.missingUpdates.clear();
    }

    public void clearMissingDeletes() {
        this.missingDeletes.clear();
    }

    public void clearMissingDetachs() {
        this.missingDetachs.clear();
    }

    public void clearChildrenToUpdate() {
        this.childrenToUpdate.clear();
    }

    public void clearChildrenToDelete() {
        this.childrenToDelete.clear();
    }

    public void clearChildrenToDetach() {
        this.childrenToDetach.clear();
    }
}

