/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class ExtensionValidator
extends AbstractElementValidator {
    public static final String NAME = "ExtensionValidator";
    private static final ExtensionValidator instance = new ExtensionValidator();

    public static ExtensionValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (element instanceof IOdaExtendableElementModel) {
            return this.doValidate(module, element);
        }
        if (element instanceof ExtendedItem) {
            return this.doValidate(module, (ExtendedItem)element);
        }
        return Collections.emptyList();
    }

    private List<SemanticException> doValidate(Module module, DesignElement toValidate) {
        ODAProvider provider = null;
        boolean hasValidManifest = true;
        if (toValidate instanceof OdaDataSet) {
            provider = ((OdaDataSet)toValidate).getProvider();
            if (provider != null && !provider.isValidExtensionID()) {
                hasValidManifest = false;
            }
        } else if (toValidate instanceof OdaDataSource && (provider = ((OdaDataSource)toValidate).getProvider()) != null && !provider.isValidExtensionID()) {
            hasValidManifest = false;
        }
        if (!hasValidManifest) {
            ArrayList<SemanticException> error = new ArrayList<SemanticException>();
            error.add(new SemanticError(toValidate, "Error.SemanticError.INVALID_MANIFEST"));
            return error;
        }
        return Collections.emptyList();
    }

    private List<SemanticException> doValidate(Module module, ExtendedItem toValidate) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        if (!(toValidate.getExtendedElement() != null || module instanceof Library && ((Library)module).getHost() != null)) {
            try {
                toValidate.initializeReportItem(module);
            }
            catch (ExtendedElementException extendedElementException) {
                return list;
            }
        }
        if (toValidate.getExtendedElement() != null) {
            try {
                List<SemanticException> exceptions = toValidate.getExtendedElement().validate();
                if (exceptions != null) {
                    list.addAll(exceptions);
                }
            }
            catch (Exception e) {
                list.add(new SemanticException(toValidate, e.getLocalizedMessage()));
            }
        }
        return list;
    }
}

