package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class MainUI extends JFrame implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCK = "busyBlockLayerUI.block";
    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR = "busyBlockLayerUI.blockingColor";
    public static final String BINDING_ICHTYOMETER_STATUS_ENABLED = "ichtyometerStatus.enabled";
    public static final String BINDING_ICHTYOMETER_STATUS_TOOL_TIP_TEXT = "ichtyometerStatus.toolTipText";
    public static final String BINDING_MENU_ACTIONS_ENABLED = "menuActions.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED = "menuActionEditCatches.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED = "menuActionEditCruise.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED = "menuActionEditProgram.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED = "menuActionEditProtocol.enabled";
    public static final String BINDING_MENU_ACTION_GENERATE_CRUISE_REPORT_ENABLED = "menuActionGenerateCruiseReport.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED = "menuActionSelectCruise.enabled";
    public static final String BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED = "menuActionValidateCatches.enabled";
    public static final String BINDING_MENU_ADMINISTRATION_ENABLED = "menuAdministration.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_FR_ENABLED = "menuChangeLocaleFR.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_UK_ENABLED = "menuChangeLocaleUK.enabled";
    public static final String BINDING_MENU_EDIT_SAMPLE_CATEGORY_MODEL_ENABLED = "menuEditSampleCategoryModel.enabled";
    public static final String BINDING_MENU_FILE_CONFIGURATION_ENABLED = "menuFileConfiguration.enabled";
    public static final String BINDING_MENU_FILE_CONNECT_ICHTYOMETER_VISIBLE = "menuFileConnectIchtyometer.visible";
    public static final String BINDING_MENU_FILE_DISCONNECT_ICHTYOMETER_VISIBLE = "menuFileDisconnectIchtyometer.visible";
    public static final String BINDING_MENU_FILE_MANAGE_DB_ENABLED = "menuFileManageDb.enabled";
    public static final String BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED = "menuImportTemporaryReferential.enabled";
    public static final String BINDING_STATUS_SHOW_MEMORY_STATUS = "status.showMemoryStatus";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected TuttiHelpBroker broker;
    protected BlockingLayerUI busyBlockLayerUI;
    protected final MainUIHandler handler = createHandler();
    protected JLabel ichtyometerStatus;
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionEditCatches;
    protected JMenuItem menuActionEditCruise;
    protected JMenuItem menuActionEditProgram;
    protected JMenuItem menuActionEditProtocol;
    protected JMenuItem menuActionGenerateCruiseReport;
    protected JMenuItem menuActionSelectCruise;
    protected JMenuItem menuActionValidateCatches;
    protected JMenu menuActions;
    protected JMenu menuAdministration;
    protected JMenu menuChangeLocale;
    protected JMenuItem menuChangeLocaleFR;
    protected JMenuItem menuChangeLocaleUK;
    protected JMenuItem menuEditSampleCategoryModel;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileConnectIchtyometer;
    protected JMenuItem menuFileDisconnectIchtyometer;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileManageDb;
    protected JMenuItem menuFileUpdateApplication;
    protected JMenuItem menuFileUpdateReport;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuImportTemporaryReferential;
    protected JMenuItem menuShowHelp;
    protected TuttiUIContext model;
    protected JButton showHelp;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gotoSite();
    }

    public void doActionPerformed__on__menuShowHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showHelp();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        menuFileExit.getAction().actionPerformed(null);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JLabel getIchtyometerStatus() {
        return ichtyometerStatus;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionEditCatches() {
        return menuActionEditCatches;
    }

    public JMenuItem getMenuActionEditCruise() {
        return menuActionEditCruise;
    }

    public JMenuItem getMenuActionEditProgram() {
        return menuActionEditProgram;
    }

    public JMenuItem getMenuActionEditProtocol() {
        return menuActionEditProtocol;
    }

    public JMenuItem getMenuActionGenerateCruiseReport() {
        return menuActionGenerateCruiseReport;
    }

    public JMenuItem getMenuActionSelectCruise() {
        return menuActionSelectCruise;
    }

    public JMenuItem getMenuActionValidateCatches() {
        return menuActionValidateCatches;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuAdministration() {
        return menuAdministration;
    }

    public JMenu getMenuChangeLocale() {
        return menuChangeLocale;
    }

    public JMenuItem getMenuChangeLocaleFR() {
        return menuChangeLocaleFR;
    }

    public JMenuItem getMenuChangeLocaleUK() {
        return menuChangeLocaleUK;
    }

    public JMenuItem getMenuEditSampleCategoryModel() {
        return menuEditSampleCategoryModel;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileConnectIchtyometer() {
        return menuFileConnectIchtyometer;
    }

    public JMenuItem getMenuFileDisconnectIchtyometer() {
        return menuFileDisconnectIchtyometer;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileManageDb() {
        return menuFileManageDb;
    }

    public JMenuItem getMenuFileUpdateApplication() {
        return menuFileUpdateApplication;
    }

    public JMenuItem getMenuFileUpdateReport() {
        return menuFileUpdateReport;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuImportTemporaryReferential() {
        return menuImportTemporaryReferential;
    }

    public JMenuItem getMenuShowHelp() {
        return menuShowHelp;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(ichtyometerStatus);
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(showHelp);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuAdministration);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionSelectCruise);
        menuActions.add(menuActionEditProgram);
        menuActions.add(menuActionEditCruise);
        menuActions.add(menuActionEditProtocol);
        menuActions.add(menuActionEditCatches);
        menuActions.add(menuActionValidateCatches);
        menuActions.add(menuActionGenerateCruiseReport);
    }

    protected void addChildrenToMenuAdministration() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdministration.add(menuImportTemporaryReferential);
        menuAdministration.add(menuEditSampleCategoryModel);
    }

    protected void addChildrenToMenuChangeLocale() {
        if (!allComponentsCreated) {
            return;
        }
        menuChangeLocale.add(menuChangeLocaleUK);
        menuChangeLocale.add(menuChangeLocaleFR);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileUpdateApplication);
        menuFile.add(menuFileUpdateReport);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileConnectIchtyometer);
        menuFile.add(menuFileDisconnectIchtyometer);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileManageDb);
        menuFile.add($JSeparator2);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuShowHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
        menuHelp.add(menuChangeLocale);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
        body.putClientProperty("help", "tutti.main.help");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.main.help"));
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected MainUIHandler createHandler() {
        return new MainUIHandler();
    }

    protected void createIchtyometerStatus() {
        $objectMap.put("ichtyometerStatus", ichtyometerStatus = new JLabel());
        
        ichtyometerStatus.setName("ichtyometerStatus");
        ichtyometerStatus.putClientProperty("help", "tutti.main.status.ichtyometer.help");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionEditCatches() {
        $objectMap.put("menuActionEditCatches", menuActionEditCatches = new JMenuItem());
        
        menuActionEditCatches.setName("menuActionEditCatches");
        menuActionEditCatches.setText(t("tutti.main.action.editCatches"));
        menuActionEditCatches.setToolTipText(t("tutti.main.action.editCatches.tip"));
        menuActionEditCatches.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedCruiseCatchesAction.class);
        menuActionEditCatches.putClientProperty("help", "tutti.main.menu.action.editCatches.help");
    }

    protected void createMenuActionEditCruise() {
        $objectMap.put("menuActionEditCruise", menuActionEditCruise = new JMenuItem());
        
        menuActionEditCruise.setName("menuActionEditCruise");
        menuActionEditCruise.setText(t("tutti.main.action.editSelectedCruise"));
        menuActionEditCruise.setToolTipText(t("tutti.main.action.editSelectedCruise.tip"));
        menuActionEditCruise.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedCruiseAction.class);
        menuActionEditCruise.putClientProperty("help", "tutti.main.menu.action.editCruise.help");
    }

    protected void createMenuActionEditProgram() {
        $objectMap.put("menuActionEditProgram", menuActionEditProgram = new JMenuItem());
        
        menuActionEditProgram.setName("menuActionEditProgram");
        menuActionEditProgram.setText(t("tutti.main.action.editSelectedProgram"));
        menuActionEditProgram.setToolTipText(t("tutti.main.action.editProgram.tip"));
        menuActionEditProgram.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedProgramAction.class);
        menuActionEditProgram.putClientProperty("help", "tutti.main.menu.action.editProgram.help");
    }

    protected void createMenuActionEditProtocol() {
        $objectMap.put("menuActionEditProtocol", menuActionEditProtocol = new JMenuItem());
        
        menuActionEditProtocol.setName("menuActionEditProtocol");
        menuActionEditProtocol.setText(t("tutti.main.action.editSelectedProtocol"));
        menuActionEditProtocol.setToolTipText(t("tutti.main.action.editSelectedProtocol.tip"));
        menuActionEditProtocol.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedProtocolAction.class);
        menuActionEditProtocol.putClientProperty("help", "tutti.main.menu.action.editProtocol.help");
    }

    protected void createMenuActionGenerateCruiseReport() {
        $objectMap.put("menuActionGenerateCruiseReport", menuActionGenerateCruiseReport = new JMenuItem());
        
        menuActionGenerateCruiseReport.setName("menuActionGenerateCruiseReport");
        menuActionGenerateCruiseReport.setText(t("tutti.main.action.generateSelectedCruiseReport"));
        menuActionGenerateCruiseReport.setToolTipText(t("tutti.main.action.generateSelectedCruiseReport.tip"));
        menuActionGenerateCruiseReport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ShowReportAction.class);
        menuActionGenerateCruiseReport.putClientProperty("help", "tutti.main.menu.action.generateSelectedCruiseReport.help");
    }

    protected void createMenuActionSelectCruise() {
        $objectMap.put("menuActionSelectCruise", menuActionSelectCruise = new JMenuItem());
        
        menuActionSelectCruise.setName("menuActionSelectCruise");
        menuActionSelectCruise.setText(t("tutti.main.action.selectCruise"));
        menuActionSelectCruise.setToolTipText(t("tutti.main.action.selectCruise.tip"));
        menuActionSelectCruise.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SelectCruiseAction.class);
        menuActionSelectCruise.putClientProperty("help", "tutti.main.menu.action.selectCruise.help");
    }

    protected void createMenuActionValidateCatches() {
        $objectMap.put("menuActionValidateCatches", menuActionValidateCatches = new JMenuItem());
        
        menuActionValidateCatches.setName("menuActionValidateCatches");
        menuActionValidateCatches.setText(t("tutti.main.action.validateCatches"));
        menuActionValidateCatches.setToolTipText(t("tutti.main.action.validateCatches.tip"));
        menuActionValidateCatches.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ValidateSelectedCruiseCatchesAction.class);
        menuActionValidateCatches.putClientProperty("help", "tutti.main.menu.action.validateCatches.help");
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(t("tutti.main.menu.actions"));
        menuActions.setToolTipText(t("tutti.main.menu.actions.tip"));
    }

    protected void createMenuAdministration() {
        $objectMap.put("menuAdministration", menuAdministration = new JMenu());
        
        menuAdministration.setName("menuAdministration");
        menuAdministration.setText(t("tutti.main.menu.administration"));
        menuAdministration.setToolTipText(t("tutti.main.menu.administration.tip"));
    }

    protected void createMenuChangeLocale() {
        $objectMap.put("menuChangeLocale", menuChangeLocale = new JMenu());
        
        menuChangeLocale.setName("menuChangeLocale");
        menuChangeLocale.setText(t("tutti.main.menu.changeLocale"));
        menuChangeLocale.setToolTipText(t("tutti.main.action.changeLocale.tip"));
        menuChangeLocale.putClientProperty("help", "tutti.main.menu.action.changeLocale.help");
    }

    protected void createMenuChangeLocaleFR() {
        $objectMap.put("menuChangeLocaleFR", menuChangeLocaleFR = new JMenuItem());
        
        menuChangeLocaleFR.setName("menuChangeLocaleFR");
        menuChangeLocaleFR.setText(t("tutti.main.action.changeLocaleFR"));
        menuChangeLocaleFR.setToolTipText(t("tutti.main.action.changeLocaleFR.tip"));
        menuChangeLocaleFR.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ChangeToLocaleFRAction.class);
        menuChangeLocaleFR.putClientProperty("help", "tutti.main.menu.action.changeLocaleFR.help");
    }

    protected void createMenuChangeLocaleUK() {
        $objectMap.put("menuChangeLocaleUK", menuChangeLocaleUK = new JMenuItem());
        
        menuChangeLocaleUK.setName("menuChangeLocaleUK");
        menuChangeLocaleUK.setText(t("tutti.main.action.changeLocaleUK"));
        menuChangeLocaleUK.setToolTipText(t("tutti.main.action.changeLocaleUK.tip"));
        menuChangeLocaleUK.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ChangeToLocaleUKAction.class);
        menuChangeLocaleUK.putClientProperty("help", "tutti.main.menu.action.changeLocaleUK.help");
    }

    protected void createMenuEditSampleCategoryModel() {
        $objectMap.put("menuEditSampleCategoryModel", menuEditSampleCategoryModel = new JMenuItem());
        
        menuEditSampleCategoryModel.setName("menuEditSampleCategoryModel");
        menuEditSampleCategoryModel.setText(t("tutti.main.action.editSampleCategoryModel"));
        menuEditSampleCategoryModel.setToolTipText(t("tutti.main.action.editSampleCategoryModel.tip"));
        menuEditSampleCategoryModel.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSampleCategoryModelAction.class);
        menuEditSampleCategoryModel.putClientProperty("help", "tutti.main.menu.action.editSampleCategoryModel.help");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(t("tutti.main.menu.file"));
        menuFile.setToolTipText(t("tutti.main.menu.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(t("tutti.main.action.configuration"));
        menuFileConfiguration.setToolTipText(t("tutti.main.action.configuration.tip"));
        menuFileConfiguration.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ShowConfigAction.class);
        menuFileConfiguration.putClientProperty("help", "tutti.main.menu.action.configuration.help");
    }

    protected void createMenuFileConnectIchtyometer() {
        $objectMap.put("menuFileConnectIchtyometer", menuFileConnectIchtyometer = new JMenuItem());
        
        menuFileConnectIchtyometer.setName("menuFileConnectIchtyometer");
        menuFileConnectIchtyometer.setText(t("tutti.main.action.connectIchtyometer"));
        menuFileConnectIchtyometer.setToolTipText(t("tutti.main.action.connectIchtyometer.tip"));
        menuFileConnectIchtyometer.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ConnectIchtyometerAction.class);
        menuFileConnectIchtyometer.putClientProperty("help", "tutti.main.menu.action.connectIchtyometer.help");
    }

    protected void createMenuFileDisconnectIchtyometer() {
        $objectMap.put("menuFileDisconnectIchtyometer", menuFileDisconnectIchtyometer = new JMenuItem());
        
        menuFileDisconnectIchtyometer.setName("menuFileDisconnectIchtyometer");
        menuFileDisconnectIchtyometer.setText(t("tutti.main.action.disconnectIchtyometer"));
        menuFileDisconnectIchtyometer.setToolTipText(t("tutti.main.action.disconnectIchtyometer.tip"));
        menuFileDisconnectIchtyometer.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.DisconnectIchtyometerAction.class);
        menuFileDisconnectIchtyometer.putClientProperty("help", "tutti.main.menu.action.disconnectIchtyometer.help");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(t("tutti.main.action.exit"));
        menuFileExit.setToolTipText(t("tutti.main.action.exit.tip"));
        menuFileExit.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CloseApplicationAction.class);
        menuFileExit.putClientProperty("help", "tutti.main.menu.action.exit.help");
    }

    protected void createMenuFileManageDb() {
        $objectMap.put("menuFileManageDb", menuFileManageDb = new JMenuItem());
        
        menuFileManageDb.setName("menuFileManageDb");
        menuFileManageDb.setText(t("tutti.main.action.manageDb"));
        menuFileManageDb.setToolTipText(t("tutti.main.action.manageDb.tip"));
        menuFileManageDb.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ManageDbAction.class);
        menuFileManageDb.putClientProperty("help", "tutti.main.menu.action.manageDb.help");
    }

    protected void createMenuFileUpdateApplication() {
        $objectMap.put("menuFileUpdateApplication", menuFileUpdateApplication = new JMenuItem());
        
        menuFileUpdateApplication.setName("menuFileUpdateApplication");
        menuFileUpdateApplication.setText(t("tutti.main.action.updateApplication"));
        menuFileUpdateApplication.setToolTipText(t("tutti.main.action.updateApplication.tip"));
        menuFileUpdateApplication.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.UpdateApplicationAction.class);
        menuFileUpdateApplication.putClientProperty("help", "tutti.main.menu.action.updateApplication.help");
    }

    protected void createMenuFileUpdateReport() {
        $objectMap.put("menuFileUpdateReport", menuFileUpdateReport = new JMenuItem());
        
        menuFileUpdateReport.setName("menuFileUpdateReport");
        menuFileUpdateReport.setText(t("tutti.main.action.updateReport"));
        menuFileUpdateReport.setToolTipText(t("tutti.main.action.updateReport.tip"));
        menuFileUpdateReport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.UpdateReportAction.class);
        menuFileUpdateReport.putClientProperty("help", "tutti.main.menu.action.updateReport.help");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(t("tutti.main.menu.help"));
        menuHelp.setToolTipText(t("tutti.main.menu.help.tip"));
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(t("tutti.main.action.about"));
        menuHelpAbout.setToolTipText(t("tutti.main.action.about.tip"));
        menuHelpAbout.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ShowAboutAction.class);
        menuHelpAbout.putClientProperty("help", "tutti.main.menu.action.about.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(t("tutti.main.action.site"));
        menuHelpSite.setToolTipText(t("tutti.main.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "tutti.main.menu.action.site.help");
    }

    protected void createMenuImportTemporaryReferential() {
        $objectMap.put("menuImportTemporaryReferential", menuImportTemporaryReferential = new JMenuItem());
        
        menuImportTemporaryReferential.setName("menuImportTemporaryReferential");
        menuImportTemporaryReferential.setText(t("tutti.main.action.importTemporaryReferential"));
        menuImportTemporaryReferential.setToolTipText(t("tutti.main.action.importTemporaryReferential.tip"));
        menuImportTemporaryReferential.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportTemporaryReferentialAction.class);
        menuImportTemporaryReferential.putClientProperty("help", "tutti.main.menu.action.importTemporaryReferential.help");
    }

    protected void createMenuShowHelp() {
        $objectMap.put("menuShowHelp", menuShowHelp = new JMenuItem());
        
        menuShowHelp.setName("menuShowHelp");
        menuShowHelp.setText(t("tutti.main.action.showHelp"));
        menuShowHelp.setToolTipText(t("tutti.main.action.showHelp.tip"));
        menuShowHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuShowHelp"));
        menuShowHelp.putClientProperty("help", "tutti.index.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setToolTipText(t("tutti.main.action.showHelp.tip"));
        showHelp.putClientProperty("help", "tutti.main.menu.action.showHelp.help");
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
        validatorMessageWidget.putClientProperty("help", "tutti.main.status.validation.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuAdministration();
        addChildrenToMenuHelp();
        addChildrenToMenuChangeLocale();
        addChildrenToBottomBar();
        
        // apply 22 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 54 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        setIconImage(SwingUtil.createImageIcon("allegro_32.png").getImage());
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.configuration.mnemonic"),'Z'));
        menuFileUpdateApplication.setIcon(SwingUtil.createActionIcon("update-application"));
        menuFileUpdateApplication.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.updateApplication.mnemonic"),'Z'));
        menuFileUpdateReport.setIcon(SwingUtil.createActionIcon("update-report"));
        menuFileUpdateReport.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.updateReport.mnemonic"),'Z'));
        menuFileConnectIchtyometer.setIcon(SwingUtil.createActionIcon("bluetooth-down"));
        menuFileConnectIchtyometer.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.connectIchtyometer.mnemonic"),'Z'));
        menuFileDisconnectIchtyometer.setIcon(SwingUtil.createActionIcon("bluetooth-up"));
        menuFileDisconnectIchtyometer.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.disconnectIchtyometer.mnemonic"),'Z'));
        menuFileManageDb.setIcon(SwingUtil.createActionIcon("manage-db"));
        menuFileManageDb.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.manageDb.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.exit.mnemonic"),'Z'));
        menuActions.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.actions.mnemonic"),'Z'));
        menuActionSelectCruise.setIcon(SwingUtil.createActionIcon("home"));
        menuActionSelectCruise.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.selectCruise.mnemonic"),'Z'));
        menuActionEditProgram.setIcon(SwingUtil.createActionIcon("program"));
        menuActionEditProgram.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSelectedProgram.mnemonic"),'Z'));
        menuActionEditCruise.setIcon(SwingUtil.createActionIcon("cruise"));
        menuActionEditCruise.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSelectedCruise.mnemonic"),'Z'));
        menuActionEditProtocol.setIcon(SwingUtil.createActionIcon("protocol"));
        menuActionEditProtocol.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSelectedProtocol.mnemonic"),'Z'));
        menuActionEditCatches.setIcon(SwingUtil.createActionIcon("edit"));
        menuActionEditCatches.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editCatches.mnemonic"),'Z'));
        menuActionValidateCatches.setIcon(SwingUtil.createActionIcon("validate"));
        menuActionValidateCatches.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.validateCatches.mnemonic"),'Z'));
        menuActionGenerateCruiseReport.setIcon(SwingUtil.createActionIcon("report"));
        menuActionGenerateCruiseReport.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.generateSelectedCruiseReport.mnemonic"),'Z'));
        menuAdministration.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.administration.mnemonic"),'Z'));
        menuImportTemporaryReferential.setIcon(SwingUtil.createActionIcon("temporary-referential-import"));
        menuImportTemporaryReferential.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.importTemporaryReferential.mnemonic"),'Z'));
        menuEditSampleCategoryModel.setIcon(SwingUtil.createActionIcon("sampleOrder"));
        menuEditSampleCategoryModel.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSampleCategoryModel.mnemonic"),'Z'));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.help.mnemonic"),'Z'));
        menuShowHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuShowHelp.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.showHelp.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.site.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.about.mnemonic"),'Z'));
        menuChangeLocale.setIcon(SwingUtil.createActionIcon("translate"));
        menuChangeLocale.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.changeLocale.mnemonic"),'Z'));
        menuChangeLocaleUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuChangeLocaleUK.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.changeLocaleUK.mnemonic"),'Z'));
        menuChangeLocaleFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        menuChangeLocaleFR.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.changeLocaleFR.mnemonic"),'Z'));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        ichtyometerStatus.setDisabledIcon(jaxx.runtime.SwingUtil.createActionIcon("bluetooth-down"));
        ichtyometerStatus.setIcon(SwingUtil.createActionIcon("bluetooth-up"));
        showHelp.setIcon(SwingUtil.createActionIcon("show-help"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, menuFileConfiguration, "tutti.main.menu.action.configuration.help");
        registerHelpId(_broker, menuFileUpdateApplication, "tutti.main.menu.action.updateApplication.help");
        registerHelpId(_broker, menuFileUpdateReport, "tutti.main.menu.action.updateReport.help");
        registerHelpId(_broker, menuFileConnectIchtyometer, "tutti.main.menu.action.connectIchtyometer.help");
        registerHelpId(_broker, menuFileDisconnectIchtyometer, "tutti.main.menu.action.disconnectIchtyometer.help");
        registerHelpId(_broker, menuFileManageDb, "tutti.main.menu.action.manageDb.help");
        registerHelpId(_broker, menuFileExit, "tutti.main.menu.action.exit.help");
        registerHelpId(_broker, menuActionSelectCruise, "tutti.main.menu.action.selectCruise.help");
        registerHelpId(_broker, menuActionEditProgram, "tutti.main.menu.action.editProgram.help");
        registerHelpId(_broker, menuActionEditCruise, "tutti.main.menu.action.editCruise.help");
        registerHelpId(_broker, menuActionEditProtocol, "tutti.main.menu.action.editProtocol.help");
        registerHelpId(_broker, menuActionEditCatches, "tutti.main.menu.action.editCatches.help");
        registerHelpId(_broker, menuActionValidateCatches, "tutti.main.menu.action.validateCatches.help");
        registerHelpId(_broker, menuActionGenerateCruiseReport, "tutti.main.menu.action.generateSelectedCruiseReport.help");
        registerHelpId(_broker, menuImportTemporaryReferential, "tutti.main.menu.action.importTemporaryReferential.help");
        registerHelpId(_broker, menuEditSampleCategoryModel, "tutti.main.menu.action.editSampleCategoryModel.help");
        registerHelpId(_broker, menuShowHelp, "tutti.index.help");
        registerHelpId(_broker, menuHelpSite, "tutti.main.menu.action.site.help");
        registerHelpId(_broker, menuHelpAbout, "tutti.main.menu.action.about.help");
        registerHelpId(_broker, menuChangeLocale, "tutti.main.menu.action.changeLocale.help");
        registerHelpId(_broker, menuChangeLocaleUK, "tutti.main.menu.action.changeLocaleUK.help");
        registerHelpId(_broker, menuChangeLocaleFR, "tutti.main.menu.action.changeLocaleFR.help");
        registerHelpId(_broker, ichtyometerStatus, "tutti.main.status.ichtyometer.help");
        registerHelpId(_broker, validatorMessageWidget, "tutti.main.status.validation.help");
        registerHelpId(_broker, showHelp, "tutti.main.menu.action.showHelp.help");
        registerHelpId(_broker, body, "tutti.main.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createBroker();
        createBusyBlockLayerUI();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileUpdateApplication();
        createMenuFileUpdateReport();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileConnectIchtyometer();
        createMenuFileDisconnectIchtyometer();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileManageDb();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createMenuFileExit();
        createMenuActions();
        createMenuActionSelectCruise();
        createMenuActionEditProgram();
        createMenuActionEditCruise();
        createMenuActionEditProtocol();
        createMenuActionEditCatches();
        createMenuActionValidateCatches();
        createMenuActionGenerateCruiseReport();
        createMenuAdministration();
        createMenuImportTemporaryReferential();
        createMenuEditSampleCategoryModel();
        createMenuHelp();
        createMenuShowHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMenuChangeLocale();
        createMenuChangeLocaleUK();
        createMenuChangeLocaleFR();
        createBottomBar();
        createIchtyometerStatus();
        createValidatorMessageWidget();
        createShowHelp();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(t("tutti.main.title.applicationName"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 22 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 22 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getConfig() != null) {
                    busyBlockLayerUI.setBlockingColor(model.getConfig().getColorBlockingLayer());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCK, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("busy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    busyBlockLayerUI.setBlock(model.isBusy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("busy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_CONFIGURATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileConfiguration.setEnabled(model.getScreen() != TuttiScreen.CONFIG);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_CONNECT_ICHTYOMETER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileConnectIchtyometer.setVisible(!model.isIchtyometerConnected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_DISCONNECT_ICHTYOMETER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileDisconnectIchtyometer.setVisible(model.isIchtyometerConnected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_MANAGE_DB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileManageDb.setEnabled(model.getScreen() != TuttiScreen.MANAGE_DB);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTIONS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActions.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCruise.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("programFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProgram.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROGRAM && model.isProgramFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("programFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCruise.setEnabled(model.getScreen() != TuttiScreen.EDIT_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCatches.setEnabled(model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionValidateCatches.setEnabled(model.getScreen() != TuttiScreen.VALIDATE_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_GENERATE_CRUISE_REPORT_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionGenerateCruiseReport.setEnabled(model.getScreen() != TuttiScreen.REPORT && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ADMINISTRATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuAdministration.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuImportTemporaryReferential.setEnabled(model.getScreen() != TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_EDIT_SAMPLE_CATEGORY_MODEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuEditSampleCategoryModel.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleUK.setEnabled(!handler.acceptLocale(model.getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleFR.setEnabled(!handler.acceptLocale(model.getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ICHTYOMETER_STATUS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ichtyometerStatus.setEnabled(model.isIchtyometerConnected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ICHTYOMETER_STATUS_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ichtyometerStatus.setToolTipText(t(handler.getIchtyometerStatusTip(model.isIchtyometerConnected())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_SHOW_MEMORY_STATUS, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getConfig() != null) {
                    status.setShowMemoryStatus(model.getConfig().isShowMemoryUsage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("config", this);
                }
            }
        });
    }

}