/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.CompositeRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeCompositeElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feComposite";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        CompositeRule compositeRule = SVGFeCompositeElementBridge.convertOperator(element);
        Filter filter2 = AbstractSVGFilterPrimitiveElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Filter filter3 = AbstractSVGFilterPrimitiveElementBridge.getIn2(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter3 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)filter2.getBounds2D().clone();
        rectangle2D2.add(filter3.getBounds2D());
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        ArrayList<Filter> arrayList = new ArrayList<Filter>(2);
        arrayList.add(filter3);
        arrayList.add(filter2);
        CompositeRable8Bit compositeRable8Bit = new CompositeRable8Bit(arrayList, compositeRule, true);
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters((Filter)compositeRable8Bit, element);
        compositeRable8Bit = new PadRable8Bit((Filter)compositeRable8Bit, rectangle2D3, PadMode.ZERO_PAD);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(element, (Filter)compositeRable8Bit, map);
        return compositeRable8Bit;
    }

    protected static CompositeRule convertOperator(Element element) {
        String string = element.getAttributeNS(null, "operator");
        if (string.length() == 0) {
            return CompositeRule.OVER;
        }
        if ("atop".equals(string)) {
            return CompositeRule.ATOP;
        }
        if ("in".equals(string)) {
            return CompositeRule.IN;
        }
        if ("over".equals(string)) {
            return CompositeRule.OVER;
        }
        if ("out".equals(string)) {
            return CompositeRule.OUT;
        }
        if ("xor".equals(string)) {
            return CompositeRule.XOR;
        }
        if ("arithmetic".equals(string)) {
            float f = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element, "k1", 0.0f);
            float f2 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element, "k2", 0.0f);
            float f3 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element, "k3", 0.0f);
            float f4 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element, "k4", 0.0f);
            return CompositeRule.ARITHMETIC((float)f, (float)f2, (float)f3, (float)f4);
        }
        throw new BridgeException(element, "attribute.malformed", new Object[]{"operator", string});
    }
}

