/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.launcher;

import fr.ifremer.tutti.ui.swing.launcher.ExitCode;
import java.util.HashSet;
import java.util.Set;

public class ExitCodes {
    protected static final ExitCode NORMAL_EXIT_CODE = new ExitCode(0, false);
    protected static final ExitCode APPLICATION_UPDATE_EXIT_CODE = new ExitCode(88, true);
    protected static final ExitCode RUNTIME_UPDATE_EXIT_CODE = new ExitCode(90, true);
    protected static Set<ExitCode> KNOWN_EXIT_CODES;

    public static ExitCode getExitCode(int code) {
        if (KNOWN_EXIT_CODES == null) {
            KNOWN_EXIT_CODES = new HashSet<ExitCode>();
            KNOWN_EXIT_CODES.add(RUNTIME_UPDATE_EXIT_CODE);
            KNOWN_EXIT_CODES.add(APPLICATION_UPDATE_EXIT_CODE);
            KNOWN_EXIT_CODES.add(NORMAL_EXIT_CODE);
        }
        ExitCode result = null;
        for (ExitCode exitCode : KNOWN_EXIT_CODES) {
            if (code != exitCode.getExitCode()) continue;
            result = exitCode;
            break;
        }
        if (result == null) {
            result = new ExitCode(code, false);
        }
        return result;
    }

    public static boolean isNormalExitCode(ExitCode exitCode) {
        return NORMAL_EXIT_CODE.equals(exitCode);
    }

    public static boolean isRuntimeUpdateExitCode(ExitCode exitCode) {
        return RUNTIME_UPDATE_EXIT_CODE.equals(exitCode);
    }

    public static boolean isApplicationUpdateExitCode(ExitCode exitCode) {
        return APPLICATION_UPDATE_EXIT_CODE.equals(exitCode);
    }
}

