/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIModelCache;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jfree.data.xy.XYSeries;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class BenthosFrequencyTableModel
extends AbstractApplicationTableModel<BenthosFrequencyRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<BenthosFrequencyRowModel> LENGTH_STEP = ColumnIdentifier.newId((String)"lengthStep", (String)I18n.n((String)"tutti.editBenthosFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editBenthosFrequencies.table.header.lengthStep", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosFrequencyRowModel> NUMBER = ColumnIdentifier.newId((String)"number", (String)I18n.n((String)"tutti.editBenthosFrequencies.table.header.number", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editBenthosFrequencies.table.header.number", (Object[])new Object[0]));
    public static final ColumnIdentifier<BenthosFrequencyRowModel> WEIGHT = ColumnIdentifier.newId((String)"weight", (String)I18n.n((String)"tutti.editBenthosFrequencies.table.header.weight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editBenthosFrequencies.table.header.weight", (Object[])new Object[0]));
    private final BenthosFrequencyUIModel uiModel;
    private final BenthosFrequencyUIModelCache modelCache;
    protected final XYSeries series;
    protected final WeightUnit weightUnit;
    protected transient PropertyChangeListener onLengthStepChangedListener;
    protected transient PropertyChangeListener onWeightChangedListener;
    protected transient PropertyChangeListener onNumberChangedListener;

    public BenthosFrequencyTableModel(WeightUnit weightUnit, TableColumnModelExt columnModel, BenthosFrequencyUIModel uiModel) {
        super(columnModel, true, true);
        this.weightUnit = weightUnit;
        this.uiModel = uiModel;
        this.modelCache = uiModel.cache;
        this.series = uiModel.dataset.getSeries(0);
        this.setNoneEditableCols(new ColumnIdentifier[0]);
    }

    public BenthosFrequencyRowModel createNewRow() {
        return this.createNewRow(true);
    }

    public BenthosFrequencyRowModel createNewRow(boolean attachListeners) {
        BenthosFrequencyRowModel rowModel;
        Float lengthStep;
        Float defaultStep = null;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && (lengthStep = (rowModel = (BenthosFrequencyRowModel)((Object)this.getEntry(rowCount - 1))).getLengthStep()) != null) {
            defaultStep = Float.valueOf(this.uiModel.getLengthStep(lengthStep.floatValue() + this.uiModel.getStep().floatValue()));
        }
        BenthosFrequencyRowModel result = new BenthosFrequencyRowModel(this.weightUnit);
        if (attachListeners) {
            this.attachListeners(result);
        }
        result.setLengthStepCaracteristic(this.uiModel.getLengthStepCaracteristic());
        result.setLengthStep(defaultStep);
        result.setValid(defaultStep != null);
        return result;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<BenthosFrequencyRowModel> propertyName, BenthosFrequencyRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, (Serializable)((Object)entry));
    }

    protected void onRowAdded(int rowIndex, BenthosFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onRowUpdated(int rowIndex, BenthosFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onRowRemoved(int rowIndex, BenthosFrequencyRowModel row) {
        this.dettachListeners(row);
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onBeforeRowsChanged(List<BenthosFrequencyRowModel> oldRows) {
        if (oldRows != null) {
            for (BenthosFrequencyRowModel row : oldRows) {
                this.dettachListeners(row);
            }
        }
    }

    protected void onRowsChanged(List<BenthosFrequencyRowModel> newRows) {
        if (newRows != null) {
            for (BenthosFrequencyRowModel row : newRows) {
                this.dettachListeners(row);
                this.attachListeners(row);
            }
        }
        this.uiModel.recomputeCanEditLengthStep();
    }

    public void decrementNumberForLengthStep(Float lengthStep) {
        BenthosFrequencyRowModel row = this.modelCache.getRowCache().get(lengthStep);
        if (row != null) {
            Integer number = row.getNumber();
            if (number != null) {
                if (number > 1) {
                    row.setNumber(number - 1);
                } else {
                    row.setNumber(null);
                }
                int rowIndex = this.getRowIndex((Serializable)((Object)row));
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
            this.uiModel.recomputeCanEditLengthStep();
        }
    }

    private PropertyChangeListener getOnLengthStepChangedListener() {
        if (this.onLengthStepChangedListener == null) {
            this.onLengthStepChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Float oldValue = (Float)evt.getOldValue();
                    if (oldValue != null) {
                        BenthosFrequencyTableModel.this.modelCache.removeLengthStep(oldValue);
                        if (BenthosFrequencyTableModel.this.series.indexOf((Number)oldValue) >= 0) {
                            BenthosFrequencyTableModel.this.series.remove((Number)oldValue);
                        }
                    }
                    BenthosFrequencyRowModel row = (BenthosFrequencyRowModel)evt.getSource();
                    Float newValue = (Float)evt.getNewValue();
                    if (newValue != null) {
                        BenthosFrequencyTableModel.this.modelCache.addLengthStep(row);
                        if (row.getNumber() != null) {
                            BenthosFrequencyTableModel.this.series.addOrUpdate((Number)newValue, (Number)row.getNumber());
                        }
                    }
                    BenthosFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                    BenthosFrequencyTableModel.this.uiModel.recomputeRowsValidateState();
                    BenthosFrequencyTableModel.this.uiModel.recomputeCanEditLengthStep();
                    BenthosFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    BenthosFrequencyTableModel.this.fireTableDataChanged();
                }
            };
        }
        return this.onLengthStepChangedListener;
    }

    private PropertyChangeListener getOnNumberChangedListener() {
        if (this.onNumberChangedListener == null) {
            this.onNumberChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BenthosFrequencyRowModel row = (BenthosFrequencyRowModel)evt.getSource();
                    Integer newValue = (Integer)evt.getNewValue();
                    Float lengthStep = row.getLengthStep();
                    if (lengthStep != null) {
                        if (newValue == null) {
                            if (BenthosFrequencyTableModel.this.series.indexOf((Number)lengthStep) >= 0) {
                                BenthosFrequencyTableModel.this.series.remove((Number)lengthStep);
                            }
                        } else {
                            BenthosFrequencyTableModel.this.series.addOrUpdate((Number)lengthStep, (Number)row.getNumber());
                        }
                    }
                    BenthosFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                    BenthosFrequencyTableModel.this.uiModel.recomputeCanEditLengthStep();
                    BenthosFrequencyTableModel.this.uiModel.recomputeRowValidState(row);
                    BenthosFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                }
            };
        }
        return this.onNumberChangedListener;
    }

    private PropertyChangeListener getOnWeightChangedListener() {
        if (this.onWeightChangedListener == null) {
            this.onWeightChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BenthosFrequencyRowModel row = (BenthosFrequencyRowModel)evt.getSource();
                    BenthosFrequencyTableModel.this.modelCache.updateRowWithWeight(row);
                    BenthosFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                    BenthosFrequencyTableModel.this.uiModel.recomputeRowsValidateState();
                    BenthosFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    BenthosFrequencyTableModel.this.fireTableDataChanged();
                }
            };
        }
        return this.onWeightChangedListener;
    }

    private void dettachListeners(BenthosFrequencyRowModel result) {
        result.removePropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.removePropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.removePropertyChangeListener("number", this.getOnNumberChangedListener());
    }

    private void attachListeners(BenthosFrequencyRowModel result) {
        result.addPropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.addPropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.addPropertyChangeListener("number", this.getOnNumberChangedListener());
    }
}

