/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;

class BlobReader
extends OdaObject {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String COMMA_SEPARATOR = ", ";
    private static String sm_className = null;
    private IBlob m_odaBlob;
    private int m_defaultBufferSize;

    protected BlobReader(IBlob odaBlob) {
        this.init(odaBlob, 2048);
    }

    protected BlobReader(IBlob odaBlob, int defaultBufferSize) {
        this.init(odaBlob, defaultBufferSize);
    }

    private void init(IBlob odaBlob, int defaultBufferSize) {
        assert (odaBlob != null);
        this.m_odaBlob = odaBlob;
        int n = this.m_defaultBufferSize = defaultBufferSize >= 0 ? defaultBufferSize : 2048;
        if (sm_className == null) {
            sm_className = this.getClassName();
        }
    }

    private int getDefaultBufferSize() {
        return this.m_defaultBufferSize;
    }

    byte[] getBytes(long startPos, int length) throws IOException, OdaException {
        long numSkipped;
        String context = String.valueOf(sm_className) + ".getBytes( " + startPos + COMMA_SEPARATOR + length + " )\t";
        this.logMethodCalled(context);
        InputStream driverStream = null;
        try {
            driverStream = this.m_odaBlob.getBinaryStream();
        }
        catch (OdaException e1) {
            this.log(context, e1.toString());
        }
        if (driverStream == null) {
            this.logMethodExitWithReturn(context, null);
            return null;
        }
        BufferedInputStream bufferedStream = new BufferedInputStream(driverStream);
        long numToSkip = 0L;
        if (startPos > 1L && (numSkipped = bufferedStream.skip(numToSkip = startPos - 1L)) != numToSkip) {
            bufferedStream.close();
            this.logMethodExitWithReturn(context, null);
            return null;
        }
        int numToRead = length;
        long streamLen = this.getStreamLength();
        if (streamLen >= 0L) {
            int numAvailable;
            int n = numAvailable = streamLen > numToSkip ? new Long(streamLen - numToSkip).intValue() : 0;
            if (length < 0 || length > numAvailable) {
                numToRead = numAvailable;
            }
        }
        if (numToRead >= 0) {
            byte[] bytesData = this.readBytesFromStream(bufferedStream, numToRead);
            bufferedStream.close();
            int arraySize = bytesData != null ? bytesData.length : -1;
            this.logMethodExitWithReturn(context, arraySize);
            return bytesData;
        }
        byte[] remainingBytes = null;
        try {
            remainingBytes = this.readRemainingBytes(bufferedStream);
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
        }
        bufferedStream.close();
        int arraySize = remainingBytes != null ? remainingBytes.length : -1;
        this.logMethodExitWithReturn(context, arraySize);
        return remainingBytes;
    }

    private byte[] readBytesFromStream(InputStream stream, int maxBufSize) throws IOException {
        String context = String.valueOf(sm_className) + ".readBytesFromStream( " + stream + COMMA_SEPARATOR + maxBufSize + " )\t";
        assert (maxBufSize >= 0);
        byte[] outBuffer = new byte[maxBufSize];
        if (maxBufSize == 0) {
            this.log(context, "Returns an empty byte array.");
            return outBuffer;
        }
        int bytesRead = stream.read(outBuffer, 0, outBuffer.length);
        if (bytesRead == maxBufSize) {
            this.log(context, "Returns a byte array of requested size: " + outBuffer.length);
            return outBuffer;
        }
        if (bytesRead < 0) {
            this.log(context, "Returns a null byte array for end of stream.");
            return null;
        }
        byte[] resizedBuf = new byte[bytesRead];
        System.arraycopy(outBuffer, 0, resizedBuf, 0, bytesRead);
        this.log(context, "Returns a byte array of size: " + resizedBuf.length);
        return resizedBuf;
    }

    private byte[] readRemainingBytes(InputStream stream) throws IOException {
        String context = String.valueOf(sm_className) + ".readRemainingBytes( " + stream + " )\t";
        ArrayList<byte[]> bufferList = new ArrayList<byte[]>();
        int bufferSize = this.getDefaultBufferSize();
        this.log(context, "Default buffer size: " + bufferSize);
        boolean endOfStream = false;
        byte[] aChunk2 = null;
        while (!endOfStream) {
            aChunk2 = this.readBytesFromStream(stream, bufferSize);
            if (aChunk2 != null) {
                bufferList.add(aChunk2);
            }
            boolean bl = endOfStream = aChunk2 == null || aChunk2.length < bufferSize || bufferSize == 0;
        }
        if (bufferList.isEmpty()) {
            this.log(context, "Returns an empty byte array.");
            return new byte[0];
        }
        int totalBytes = 0;
        for (byte[] aChunk2 : bufferList) {
            assert (aChunk2 != null);
            totalBytes += aChunk2.length;
        }
        if (totalBytes <= 0) {
            this.log(context, "Returns an empty byte array.");
            return new byte[0];
        }
        byte[] remainingBytes = new byte[totalBytes];
        Iterator bufferIter = bufferList.iterator();
        int bytesCopied = 0;
        while (bufferIter.hasNext()) {
            aChunk2 = (byte[])bufferIter.next();
            System.arraycopy(aChunk2, 0, remainingBytes, bytesCopied, aChunk2.length);
            assert ((bytesCopied += aChunk2.length) <= totalBytes);
        }
        this.log(context, "Returns a byte array of size: " + remainingBytes.length);
        return remainingBytes;
    }

    private long getStreamLength() {
        long len = -1L;
        try {
            len = this.m_odaBlob.length();
        }
        catch (OdaException odaException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (RuntimeException runtimeException) {}
        return len;
    }
}

