/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.socket;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

public class SynchroHttpHandler
implements HttpRequestHandler {
    private static final Log log = LogFactory.getLog(SynchroHttpHandler.class);
    private final File dataDirectory;
    private SimpleDateFormat dateFormatter;
    private Pattern datePattern;

    public SynchroHttpHandler(File dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.dateFormatter = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        this.datePattern = Pattern.compile("20[0-9]{6}_[0-9]{6}_[0-9]{3}");
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String path;
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
            throw new MethodNotSupportedException(method + " method not supported");
        }
        String target = request.getRequestLine().getUri();
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            byte[] entityContent = EntityUtils.toByteArray((HttpEntity)entity);
            log.debug((Object)("Incoming entity content (bytes): " + entityContent.length));
        }
        if ("/new".equals(path = URLDecoder.decode(target, "UTF-8"))) {
            this.doNew(request, response, context);
            return;
        }
        if (this.datePattern.matcher(path.substring(1)).matches()) {
            Date sysdate = null;
            try {
                sysdate = this.dateFormatter.parse(path.substring(1));
            }
            catch (ParseException e) {
                response.setStatusCode(404);
                StringEntity entity = new StringEntity("<html><body><h1>File " + path + " not found</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
                response.setEntity((HttpEntity)entity);
                log.warn((Object)("Path " + path + " not found"));
                return;
            }
            int percent = 50;
            String message = "Table XXX";
            StringEntity entity = new StringEntity(String.format("{percent: %s, message: %s}", percent, message), ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            return;
        }
        File file = new File(this.dataDirectory, URLDecoder.decode(target, "UTF-8"));
        if (!file.exists()) {
            response.setStatusCode(404);
            StringEntity entity = new StringEntity("<html><body><h1>File" + file.getPath() + " not found</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            log.warn((Object)("File " + file.getPath() + " not found"));
        } else if (!file.canRead() || file.isDirectory()) {
            response.setStatusCode(403);
            StringEntity entity = new StringEntity("<html><body><h1>Access denied</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            log.warn((Object)("Cannot read file " + file.getPath()));
        } else {
            response.setStatusCode(200);
            FileEntity body = new FileEntity(file, ContentType.create((String)"text/html", (Charset)null));
            response.setEntity((HttpEntity)body);
            log.debug((Object)("Serving file " + file.getPath()));
        }
    }

    protected void doNew(HttpRequest request, HttpResponse response, HttpContext context) {
        Date sysdate = new Date();
        String dateStr = this.dateFormatter.format(sysdate);
        StringEntity entity = new StringEntity(dateStr, ContentType.create((String)"text/html", (String)"UTF-8"));
        response.setEntity((HttpEntity)entity);
    }
}

