package fr.ifremer.tutti.ui.swing.content.operation.fishing;

/*
 * #%L
 * Tutti :: UI
 * $Id: GearUseFeatureTabUIHandler.java 1410 2013-11-28 17:55:19Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/tutti/tags/tutti-3.1.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/GearUseFeatureTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicValueRenderer;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

import java.util.List;

/**
 * @author kmorin
 * @since 0.3
 */
public class GearUseFeatureTabUIHandler extends AbstractCaracteristicTabUIHandler<GearUseFeatureRowModel, GearUseFeatureTabUIModel, GearUseFeatureTableModel, GearUseFeatureTabUI> {

    public GearUseFeatureTabUIHandler() {
        super(GearUseFeatureRowModel.PROPERTY_VALUE);
    }

    //------------------------------------------------------------------------//
    //-- AbstractCaracteristicTabUIHandler methods                          --//
    //------------------------------------------------------------------------//

    @Override
    protected BeanFilterableComboBox<Caracteristic> getKeyCombo() {
        return ui.getNewRowKey();
    }

    @Override
    protected GearUseFeatureTabUIModel createModel() {
        return new GearUseFeatureTabUIModel();
    }

    @Override
    protected CaracteristicMap getCaracteristics(FishingOperation operation) {
        return operation.getGearUseFeatures();
    }

    @Override
    protected List<String> getProtocolPmfmIds() {
        return getDataContext().getProtocol().getGearUseFeaturePmfmId();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiTableUIHandler methods                                --//
    //------------------------------------------------------------------------//

    @Override
    public JXTable getTable() {
        return ui.getGearUseFeatureTable();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void afterInit(GearUseFeatureTabUI ui) {
        super.afterInit(ui);

        JXTable table = getTable();

        // create table column model
        DefaultTableColumnModelExt columnModel =
                new DefaultTableColumnModelExt();

        {

            addColumnToModel(columnModel,
                             null,
                             newTableCellRender(Caracteristic.class, DecoratorService.CARACTERISTIC_WITH_UNIT),
                             GearUseFeatureTableModel.KEY);
        }

        {

            addColumnToModel(columnModel,
                             new CaracteristicValueEditor(getContext()),
                             new CaracteristicValueRenderer(getContext()),
                             GearUseFeatureTableModel.VALUE);
        }

        // create table model
        GearUseFeatureTableModel tableModel =
                new GearUseFeatureTableModel(columnModel);

        table.setModel(tableModel);
        table.setColumnModel(columnModel);

        initTable(table);
    }

}
