/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.shared.application.swing.ApplicationUI;
import fr.ifremer.shared.application.swing.util.Cancelable;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.GearCaracteristicsEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.cruise.GearCaracteristicsEditorTableModel;
import fr.ifremer.tutti.ui.swing.content.cruise.GearCaracteristicsEditorUI;
import fr.ifremer.tutti.ui.swing.content.cruise.GearCaracteristicsEditorUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicValueRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class GearCaracteristicsEditorUIHandler
extends AbstractTuttiTableUIHandler<GearCaracteristicsEditorRowModel, GearCaracteristicsEditorUIModel, GearCaracteristicsEditorUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(GearCaracteristicsEditorUIHandler.class);

    public GearCaracteristicsEditorUIHandler() {
        super("value");
    }

    public GearCaracteristicsEditorTableModel getTableModel() {
        return (GearCaracteristicsEditorTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((GearCaracteristicsEditorUI)this.ui).getGearCaracteristicsEditorTable();
    }

    @Override
    protected boolean isRowValid(GearCaracteristicsEditorRowModel row) {
        return row.getKey() != null && row.getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, GearCaracteristicsEditorRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, GearCaracteristicsEditorRowModel oldRow, int newRowIndex, GearCaracteristicsEditorRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        if (newRow != null) {
            this.recomputeRowValidState(newRow);
        }
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).setRemoveCaracteristicEnabled(rowIndex != -1);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<GearCaracteristicsEditorRowModel> rowMonitor, GearCaracteristicsEditorRowModel row) {
        if (row.isValid() && rowMonitor.wasModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
            }
            this.saveRow(row);
        }
    }

    public void beforeInit(GearCaracteristicsEditorUI ui) {
        super.beforeInit((ApplicationUI)ui);
        GearCaracteristicsEditorUIModel model = new GearCaracteristicsEditorUIModel();
        ui.setContextValue(model);
        model.addPropertyChangeListener("gear", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GearCaracteristicsEditorUIHandler.this.editGear((Gear)evt.getNewValue());
            }
        });
    }

    public void afterInit(GearCaracteristicsEditorUI ui) {
        this.initUI(ui);
        this.initBeanFilterableComboBox(this.getKeyCombo(), Lists.newArrayList(), null);
        ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).setAvailableCaracteristics(this.getDataContext().getCaracteristics());
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), GearCaracteristicsEditorTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.getContext()), new CaracteristicValueRenderer(this.getContext()), GearCaracteristicsEditorTableModel.VALUE);
        GearCaracteristicsEditorTableModel tableModel = new GearCaracteristicsEditorTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    protected JComponent getComponentToFocus() {
        return ((GearCaracteristicsEditorUI)this.getUI()).getNewRowKey();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        EditCruiseUI ui = ((GearCaracteristicsEditorUI)this.getUI()).getParentContainer(EditCruiseUI.class);
        ui.getMainPanelLayout().setSelected("cruise");
        ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).setValid(false);
        ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).setGear(null);
    }

    public SwingValidator<GearCaracteristicsEditorUIModel> getValidator() {
        return null;
    }

    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI((TuttiUI)this.ui);
    }

    protected BeanFilterableComboBox<Caracteristic> getKeyCombo() {
        return ((GearCaracteristicsEditorUI)this.ui).getNewRowKey();
    }

    protected void saveRow(GearCaracteristicsEditorRowModel row) {
        if (row.isValid()) {
            CaracteristicMap caracteristics = ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).getCaracteristicMap();
            Preconditions.checkNotNull((Object)caracteristics);
            caracteristics.put((Object)row.getKey(), (Object)row.getValue());
        }
    }

    public void addRow() {
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        GearCaracteristicsEditorTableModel tableModel = this.getTableModel();
        GearCaracteristicsEditorRowModel row = tableModel.createNewRow();
        row.setKey(selectedItem);
        ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).getRows().add(row);
        int rowIndex = tableModel.getRowCount() - 1;
        tableModel.fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.getHandler().removeItem((Object)selectedItem);
        GearCaracteristicsEditorUIModel model = (GearCaracteristicsEditorUIModel)((Object)this.getModel());
        model.setModify(true);
        this.recomputeRowValidState(row);
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        GearCaracteristicsEditorRowModel row = (GearCaracteristicsEditorRowModel)((Object)this.getTableModel().getEntry(rowIndex));
        CaracteristicMap caracteristicMap = ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove((Object)row.getKey());
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.addItem((Object)row.getKey());
        keyCombo.getHandler().reset();
        ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
        ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).removeRowInError(row);
    }

    public void save() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save UI " + this.ui));
        }
        Gear gear = ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).getGear();
        gear.setCaracteristics((CaracteristicMap)((GearCaracteristicsEditorUIModel)((Object)this.getModel())).getCaracteristicMap().clone());
        this.getPersistenceService().saveGearCaracteristics(gear, this.getDataContext().getCruise());
        this.closeUI((TuttiUI)this.ui);
    }

    protected void editGear(Gear gear) {
        if (gear != null) {
            GearCaracteristicsEditorTableModel tableModel = this.getTableModel();
            GearCaracteristicsEditorUIModel model = (GearCaracteristicsEditorUIModel)((Object)this.getModel());
            CaracteristicMap caracteristicMap = gear.getCaracteristics();
            if (caracteristicMap == null) {
                caracteristicMap = new CaracteristicMap();
            }
            model.getCaracteristicMap().clear();
            model.getCaracteristicMap().putAll((Map)caracteristicMap);
            ArrayList rows = Lists.newArrayList();
            ArrayList caracteristics = Lists.newArrayList((Iterable)caracteristicMap.keySet());
            List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
            for (Caracteristic key : caracteristics) {
                GearCaracteristicsEditorRowModel newRow = tableModel.createNewRow();
                newRow.setKey(key);
                newRow.setValue((Serializable)caracteristicMap.get((Object)key));
                rows.add(newRow);
            }
            model.setRows(rows);
            ArrayList caracteristicList = Lists.newArrayList();
            for (Caracteristic caracteristic : availableCaracteristics) {
                if (caracteristics.contains(caracteristic)) continue;
                caracteristicList.add(caracteristic);
            }
            BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
            keyCombo.setData((List)caracteristicList);
            keyCombo.getHandler().reset();
            model.setModify(false);
        } else {
            this.cleanrRowMonitor();
            ((GearCaracteristicsEditorUIModel)((Object)this.getModel())).setRows(Lists.newArrayList());
            this.getTable().clearSelection();
        }
    }
}

