/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesSubBatchAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected int rowIndex;
    protected Set<SpeciesBatchRowModel> rowToRemove;
    protected SpeciesBatchRowModel parentBatch;

    public RemoveSpeciesSubBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        this.rowIndex = -1;
        if (result) {
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), I18n._((String)"tutti.editSpeciesBatch.action.removeSubBatch.confirm.message", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesBatch.action.removeSubBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        this.rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove sub batch if no batch selected");
        this.parentBatch = (SpeciesBatchRowModel)((SpeciesBatchUIHandler)this.handler).getTableModel().getEntry(this.rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew((TuttiEntity)this.parentBatch) ? 1 : 0) != 0, (Object)"Can't remove sub batch if batch is not persisted");
        persistenceService.deleteSpeciesSubBatch(this.parentBatch.getId());
        this.rowToRemove = Sets.newHashSet();
        ((SpeciesBatchUIHandler)this.handler).collectChildren(this.parentBatch, this.rowToRemove);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        ((SpeciesBatchUIModel)this.getModel()).getRows().removeAll(this.rowToRemove);
        this.parentBatch.setChildBatch(null);
        ((SpeciesBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        TuttiUIUtil.selectFirstCellOnRow((JXTable)table, (int)this.rowIndex, (boolean)true);
    }
}

