/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.collect.Maps;
import fr.ifremer.shared.application.swing.action.AbstractApplicationAction;
import fr.ifremer.shared.application.swing.action.ApplicationActionException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdaterCallback;

public class TuttiReportUpdaterCallBack
implements ApplicationUpdaterCallback {
    private static final Log log = LogFactory.getLog(TuttiReportUpdaterCallBack.class);
    public static final String REPORT_UPDATE_NAME = "report";
    protected final TuttiUIContext context;
    protected ProgressionModel progressionModel;
    protected boolean reportUpdated;
    protected final AbstractTuttiAction action;

    public TuttiReportUpdaterCallBack(AbstractTuttiAction action, ProgressionModel progressionModel) {
        this.action = action;
        this.context = action.getContext();
        this.progressionModel = progressionModel;
    }

    public boolean isReportUpdated() {
        return this.reportUpdated;
    }

    public Map<String, ApplicationInfo> updateToDo(Map<String, ApplicationInfo> appToUpdate) {
        HashMap result = Maps.newHashMap();
        ApplicationInfo info = appToUpdate.get(REPORT_UPDATE_NAME);
        if (info != null) {
            result.put(info.name, info);
            info.setAuthentication("tuttidb", new char[]{'3', 'R', 'A', 'C', 'e', 'v', '2', 'N', 'w', '8', 'u', 'E', 'D', 'E', 'v', 's', 'y', '0', 'v', 'J'});
        }
        return result;
    }

    public void startUpdate(ApplicationInfo info) {
        this.progressionModel.setMessage(I18n._((String)"tutti.applicationUpdater.startUpdate.report", (Object[])new Object[]{info.newVersion}));
    }

    public void updateDone(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = this.updateDoneReport(appToUpdate, appUpdateError);
        if (doRestart) {
            this.reportUpdated = true;
        }
    }

    public void aborted(String propertiesURL, Exception eee) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Could not update from " + propertiesURL), (Throwable)eee);
        }
        throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)eee);
    }

    protected boolean updateDoneReport(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(REPORT_UPDATE_NAME, appUpdateError);
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not update report", (Throwable)error);
            }
        } else {
            ApplicationInfo info = this.getInfo(REPORT_UPDATE_NAME, appToUpdate);
            if (info != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("A report update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
                }
                doRestart = true;
            }
        }
        return doRestart;
    }

    protected Exception getError(String type, Map<String, Exception> appUpdateError) {
        return appUpdateError.get(type.toLowerCase());
    }

    protected ApplicationInfo getInfo(String type, Map<String, ApplicationInfo> appToUpdate) {
        return appToUpdate.get(type.toLowerCase());
    }

    static {
        I18n.n_((String)"tutti.update.report", (Object[])new Object[0]);
    }
}

