/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.category;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.shared.application.swing.ApplicationUI;
import fr.ifremer.shared.application.swing.util.Cancelable;
import fr.ifremer.shared.application.swing.util.CloseableUI;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelRowModel;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelTableModel;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelUI;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class EditSampleCategoryModelUIHandler
extends AbstractTuttiTableUIHandler<EditSampleCategoryModelRowModel, EditSampleCategoryModelUIModel, EditSampleCategoryModelUI>
implements Cancelable,
CloseableUI {
    private static final Log log = LogFactory.getLog(EditSampleCategoryModelUIHandler.class);

    public EditSampleCategoryModelUIHandler() {
        super("caracteristic", "label");
    }

    public void addCaracteristic() {
        BeanFilterableComboBox<Caracteristic> keyCombo = ((EditSampleCategoryModelUI)this.ui).getAvailableCaracteristicsComboBox();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        ((EditSampleCategoryModelUIModel)this.getModel()).removeCaracteristic(selectedItem);
        EditSampleCategoryModelTableModel tableModel = this.getTableModel();
        EditSampleCategoryModelRowModel row = tableModel.createNewRow();
        row.setCaracteristic(selectedItem);
        tableModel.addNewRow(row);
        this.recomputeRowValidState(row);
        ((EditSampleCategoryModelUIModel)this.getModel()).setModify(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditSampleCategoryModelUIHandler.this.getTable().requestFocus();
                int rowIndex = EditSampleCategoryModelUIHandler.this.getTable().getRowCount() - 1;
                SwingUtil.editCell((JTable)EditSampleCategoryModelUIHandler.this.getTable(), (int)rowIndex, (int)1);
            }
        });
    }

    public void removeEntry() {
        int selectedRow = this.getTable().getSelectedRow();
        Preconditions.checkState((selectedRow > -1 ? 1 : 0) != 0);
        EditSampleCategoryModelRowModel entry = (EditSampleCategoryModelRowModel)this.getTableModel().getEntry(selectedRow);
        Caracteristic caracteristic = entry.getCaracteristic();
        ((EditSampleCategoryModelUIModel)this.getModel()).addCaracteristic(caracteristic);
        this.getTableModel().removeRow(selectedRow);
        ((EditSampleCategoryModelUIModel)this.getModel()).setModify(true);
    }

    public void moveUpEntry() {
        int selectedRow = this.getTable().getSelectedRow();
        Preconditions.checkState((selectedRow > -1 ? 1 : 0) != 0);
        int newRow = selectedRow - 1;
        this.getTableModel().permuteEntry(newRow, selectedRow);
        this.getTable().getSelectionModel().setSelectionInterval(newRow, newRow);
        ((EditSampleCategoryModelUIModel)this.getModel()).setModify(true);
    }

    public void moveDownEntry() {
        int selectedRow = this.getTable().getSelectedRow();
        Preconditions.checkState((selectedRow > -1 ? 1 : 0) != 0);
        int newRow = selectedRow + 1;
        this.getTableModel().permuteEntry(selectedRow, newRow);
        this.getTable().getSelectionModel().setSelectionInterval(newRow, newRow);
        ((EditSampleCategoryModelUIModel)this.getModel()).setModify(true);
    }

    public EditSampleCategoryModelTableModel getTableModel() {
        return (EditSampleCategoryModelTableModel)((Object)this.getTable().getModel());
    }

    protected JComponent getComponentToFocus() {
        return ((EditSampleCategoryModelUI)this.ui).getAvailableCaracteristicsComboBox();
    }

    @Override
    public JXTable getTable() {
        return ((EditSampleCategoryModelUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(EditSampleCategoryModelRowModel row) {
        boolean result = StringUtils.isNotBlank((CharSequence)row.getLabel());
        return result;
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, EditSampleCategoryModelRowModel oldRow, int newRowIndex, EditSampleCategoryModelRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.recomputePopupActions();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<EditSampleCategoryModelRowModel> rowMonitor, EditSampleCategoryModelRowModel row) {
    }

    @Override
    protected void onRowModified(int rowIndex, EditSampleCategoryModelRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.saveSelectedRowIfNeeded();
        this.recomputePopupActions();
        ((EditSampleCategoryModelUIModel)this.getModel()).setModify(true);
    }

    public boolean quitUI() {
        boolean result = this.quitScreen(((EditSampleCategoryModelUIModel)this.getModel()).isValid(), ((EditSampleCategoryModelUIModel)this.getModel()).isModify(), I18n._((String)"tutti.editProtocol.askCancelEditBeforeLeaving.cancelSaveSampleCategoryModel", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.askSaveBeforeLeaving.saveSampleCategoryModel", (Object[])new Object[0]), ((EditSampleCategoryModelUI)this.ui).getSaveButton().getAction());
        return result;
    }

    public void beforeInit(EditSampleCategoryModelUI ui) {
        super.beforeInit((ApplicationUI)ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("for " + ui));
        }
        ArrayList caracteristics = Lists.newArrayList((Iterable)this.getPersistenceService().getAllCaracteristicForSampleCategory());
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        EditSampleCategoryModelUIModel model = new EditSampleCategoryModelUIModel(this.getPersistenceService().getEnumerationFile(), sampleCategoryModel.getCategory(), caracteristics);
        ui.setContextValue(model);
    }

    public void afterInit(EditSampleCategoryModelUI ui) {
        this.initUI(ui);
        EditSampleCategoryModelUIModel model = (EditSampleCategoryModelUIModel)this.getModel();
        this.initBeanFilterableComboBox(ui.getAvailableCaracteristicsComboBox(), model.getCaracteristicList(), null);
        model.addPropertyChangeListener("caracteristicList", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"propertyChange caracteristicList");
                }
                ((EditSampleCategoryModelUI)EditSampleCategoryModelUIHandler.this.ui).getAvailableCaracteristicsComboBox().setData(null);
                ((EditSampleCategoryModelUI)EditSampleCategoryModelUIHandler.this.ui).getAvailableCaracteristicsComboBox().setData((List)evt.getNewValue());
                ((EditSampleCategoryModelUI)EditSampleCategoryModelUIHandler.this.ui).getAvailableCaracteristicsComboBox().setSelectedItem(null);
            }
        });
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class), EditSampleCategoryModelTableModel.CARACTERISTIC);
        this.addColumnToModel((TableColumnModel)columnModel, null, null, EditSampleCategoryModelTableModel.LABEL);
        EditSampleCategoryModelTableModel tableModel = new EditSampleCategoryModelTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        List rows = model.getRows();
        tableModel.setRows(rows);
        this.recomputePopupActions();
        model.setModify(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((EditSampleCategoryModelUIModel)EditSampleCategoryModelUIHandler.this.getModel()).setModify(false);
            }
        });
    }

    @Override
    protected void initTable(JXTable table) {
        super.initTable(table);
        this.installTableKeyListener(table.getColumnModel(), (JTable)table);
    }

    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI((TuttiUI)this.ui);
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing UI " + this.ui));
        }
    }

    public SwingValidator<EditSampleCategoryModelUIModel> getValidator() {
        return null;
    }

    protected void recomputePopupActions() {
        int rowIndex = this.getTable().getSelectedRow();
        boolean enableRemoveEntry = false;
        boolean enableMoveUpEntry = false;
        boolean enableMoveDownEntry = false;
        if (rowIndex != -1) {
            enableRemoveEntry = true;
            enableMoveUpEntry = rowIndex > 0;
            enableMoveDownEntry = rowIndex < this.getTable().getModel().getRowCount() - 1;
        }
        EditSampleCategoryModelUIModel model = (EditSampleCategoryModelUIModel)this.getModel();
        model.setRemoveEntryEnabled(enableRemoveEntry);
        model.setMoveUpEntryEnabled(enableMoveUpEntry);
        model.setMoveDownEntryEnabled(enableMoveDownEntry);
    }
}

