package fr.ifremer.tutti.ui.swing.content.report;

/*
 * #%L
 * Tutti :: UI
 * $Id: ReportUIModel.java 1344 2013-11-12 09:10:29Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.9/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/report/ReportUIModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.service.report.ReportModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.File;
import java.util.List;

/**
 * Model of {@link ReportUI} screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.9
 */
public class ReportUIModel extends AbstractTuttiBeanUIModel<ReportModel, ReportUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_REPORTS = "reports";

    public static final String PROPERTY_REPORT = "report";

    public static final String PROPERTY_INPUT_FILE = "inputFile";

    public static final String PROPERTY_OUTPUT_FILE = "outputFile";
    public static final String PROPERTY_OUTPUT_FILE_EXISTS = "outputFileExists";

    protected static Binder<ReportUIModel, ReportModel> toBeanBinder =
            BinderFactory.newBinder(ReportUIModel.class,
                                    ReportModel.class);

    protected List<File> reports;

    protected final ReportModel editObject = new ReportModel();

    public ReportUIModel() {
        super(ReportModel.class, null, toBeanBinder);
    }

    public List<File> getReports() {
        return reports;
    }

    public void setReports(List<File> reports) {
        Object oldValue = getReports();
        this.reports = reports;
        firePropertyChange(PROPERTY_REPORTS, oldValue, reports);
    }

    public File getReport() {
        return editObject.getReport();
    }

    public void setReport(File report) {
        Object oldValue = getReport();
        editObject.setReport(report);
        firePropertyChange(PROPERTY_REPORT, oldValue, report);
    }

    public File getInputFile() {
        return editObject.getInputFile();
    }

    public void setInputFile(File inputFile) {
        Object oldValue = getInputFile();
        editObject.setInputFile(inputFile);
        firePropertyChange(PROPERTY_INPUT_FILE, oldValue, inputFile);
    }

    public File getOutputFile() {
        return editObject.getOutputFile();
    }

    public void setOutputFile(File outputFile) {
        Object oldValue = getOutputFile();
        editObject.setOutputFile(outputFile);
        firePropertyChange(PROPERTY_OUTPUT_FILE, oldValue, outputFile);
        reloadOuputFile();
    }

    public void reloadOuputFile() {

        firePropertyChange(PROPERTY_OUTPUT_FILE_EXISTS, null, isOutputFileExists());
    }
    public boolean isOutputFileExists() {
        return getOutputFile() != null && getOutputFile().exists();
    }

    @Override
    protected ReportModel newEntity() {
        return new ReportModel();
    }
}
