package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: UpdateReportAction.java 1342 2013-11-10 14:11:26Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.9/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/UpdateReportAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiReportUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.updater.ApplicationUpdater;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * To update reports using the {@link ApplicationUpdater} mecanism.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class UpdateReportAction extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(UpdateReportAction.class);

    public UpdateReportAction(MainUIHandler handler) {
        super(handler, true);
        setActionDescription(_("tutti.main.action.updateReport.tip"));
    }

    protected boolean reload;

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();

        if (doAction) {
            // check data url is reachable
            TuttiUIContext context = getContext();
            doAction = context.checkUpdateDataReachable();
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {

        reload = false;

        TuttiUIContext context = getContext();
        TuttiApplicationConfig config = context.getConfig();

        File current = config.getTuttiBasedir();
        if (current == null || !current.exists()) {

            // can not update application
            if (log.isWarnEnabled()) {
                log.warn("No application base directory defined, skip updates.");
            }
        } else {

            String url = config.getUpdateDataUrl();
            File dest = new File(config.getTuttiBasedir(), "NEW");

            if (log.isInfoEnabled()) {
                log.info(String.format("Try to update repport (current application location: %s), using update url: %s", current, url));
            }

            ProgressionModel progressionModel = new ProgressionModel();
            context.getActionUI().getModel().setProgressionModel(progressionModel);
            progressionModel.setMessage(_("tutti.updateApplication.checkUpdates"));

            TuttiReportUpdaterCallBack callback =
                    new TuttiReportUpdaterCallBack(this, progressionModel);

            ApplicationUpdater up = new ApplicationUpdater();
            up.update(url,
                      current,
                      dest,
                      false,
                      callback,
                      progressionModel);

            if (callback.isReportUpdated()) {

                reload = true;

            } else {

                sendMessage(_("tutti.updateReport.noUpdate"));
            }
        }
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        if (reload) {
            // wait 1 second to be sure action ui is up
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                if (log.isWarnEnabled()) {
                    log.warn("Could not wait 1 second...", e);
                }
            }

            // tell user restart will be done

            getHandler().showSuccessMessage(_("tutti.updateReport.title.success"),
                                            _("tutti.updateReport.message.success"));

            CloseApplicationAction action = TuttiActionHelper.createLogicAction(
                    getHandler(), CloseApplicationAction.class);
            action.setExitCode(RunTutti.UPATE_EXIT_CODE);
            TuttiActionHelper.runAction(action);
        }
    }

    public boolean isReload() {
        return reload;
    }
}