/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.MergerException;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.mapping.Mapping;
import org.andromda.core.mapping.Mappings;
import org.apache.commons.lang.StringUtils;

public class Merger {
    private static final Merger instance = new Merger();
    private final Map mergeMappingsCache = new LinkedHashMap();

    public static Merger instance() {
        return instance;
    }

    public String getMergedString(String string, String namespace) {
        Collection mappings;
        Mappings mergeMappings;
        if (namespace != null && string != null && (mergeMappings = this.getMergeMappings(namespace)) != null && (mappings = mergeMappings.getMappings()) != null && !mappings.isEmpty()) {
            Iterator mappingsIterator = mappings.iterator();
            while (mappingsIterator.hasNext()) {
                Mapping mapping = (Mapping)mappingsIterator.next();
                Collection froms = mapping.getFroms();
                if (froms == null || froms.isEmpty()) continue;
                Iterator fromsIterator = froms.iterator();
                while (fromsIterator.hasNext()) {
                    String from = StringUtils.trimToEmpty((String)((String)fromsIterator.next()));
                    if (!StringUtils.isNotEmpty((String)from)) continue;
                    String to = mapping.getTo() != null ? mapping.getTo().trim() : "";
                    string = StringUtils.replace((String)string, (String)from, (String)to);
                }
            }
        }
        return string;
    }

    public String getMergedString(InputStream inputStream, String namespace) {
        try {
            StringWriter writer = new StringWriter();
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
            int ctr = inputReader.read();
            while (ctr != -1) {
                writer.write(ctr);
                ctr = inputReader.read();
            }
            inputReader.close();
            inputReader = null;
            String string = writer.toString();
            writer.close();
            writer = null;
            return this.getMergedString(string, namespace);
        }
        catch (Exception exception) {
            throw new MergerException(exception);
        }
    }

    public boolean requiresMerge(String namespace) {
        Mappings mergeMappings = this.getMergeMappings(namespace);
        return mergeMappings != null && !mergeMappings.getMappings().isEmpty();
    }

    private Mappings getMergeMappings(String namespace) {
        Mappings mergeMappings = null;
        if (StringUtils.isNotBlank((String)namespace)) {
            String mergeMappingsUriValue;
            Property mergeMappingsUri = Namespaces.instance().getProperty(namespace, "mergeMappingsUri", false);
            String string = mergeMappingsUriValue = mergeMappingsUri != null ? mergeMappingsUri.getValue() : null;
            if (StringUtils.isNotBlank((String)mergeMappingsUriValue) && (mergeMappings = (Mappings)this.mergeMappingsCache.get(mergeMappingsUriValue)) == null) {
                mergeMappings = Mappings.getInstance(mergeMappingsUriValue);
                this.mergeMappingsCache.put(mergeMappingsUriValue, mergeMappings);
            }
        }
        return mergeMappings;
    }
}

