
package fr.ifremer.tutti.ui.swing.util.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SelectSpeciesUIHandler.java 773 2013-04-13 20:09:01Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/species/SelectSpeciesUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SelectSpeciesUIHandler extends AbstractTuttiUIHandler<SelectSpeciesUIModel, SelectSpeciesUI> {

    private static final Log log =
            LogFactory.getLog(SelectSpeciesUIHandler.class);

    public SelectSpeciesUIHandler(TuttiUI parentUI, SelectSpeciesUI ui) {
        super(parentUI.getHandler().getContext(), ui);
    }

    @Override
    public void beforeInitUI() {
        SelectSpeciesUIModel model = new SelectSpeciesUIModel();
        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        initUI(ui);

        initBeanFilterableComboBox(ui.getSpeciesCombo(),
                                   Lists.<Species>newArrayList(),
                                   null);

        getModel().addPropertyChangeListener(
                SelectSpeciesUIModel.PROPERTY_SPECIES,
                new PropertyChangeListener() {

                    public void propertyChange(PropertyChangeEvent evt) {
                        ui.getSpeciesCombo().getHandler().sortData();
                    }
                });
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getSpeciesCombo();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
    }

    @Override
    public SwingValidator<SelectSpeciesUIModel> getValidator() {
        return null;
    }

    public void validate() {
        closeDialog(ui);
    }

    public void cancel() {
        getModel().setSelectedSpecies(null);
        closeDialog(ui);
    }
}
