package fr.ifremer.tutti.ui.swing.spatial;

/*
 * #%L
 * Tutti :: UI
 * $Id: DmdCoordinateEditorModel.java 1316 2013-10-25 16:43:35Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/spatial/DmdCoordinateEditorModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.Serializable;

/**
 * Created on 10/16/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.9
 */
public class DmdCoordinateEditorModel extends DmdCoordinate {

    public static final String PROPERTY_BEAN = "bean";

    public static final String PROPERTY_PROPERTY_SIGN = "propertySign";

    public static final String PROPERTY_PROPERTY_DEGREE = "propertyDegree";

    public static final String PROPERTY_PROPERTY_MINUTE = "propertyMinute";

    public static final String PROPERTY_PROPERTY_DECIMAL = "propertyDecimal";

    public static final String PROPERTY_LONGITUDE_EDITOR = "longitudeEditor";

    private static final long serialVersionUID = 1L;

    /** Bean where to push data. */
    protected Serializable bean;

    /** Name of the property of the bean to fire the change of the {@link #sign}. */
    protected String propertySign;

    /** Name of the property of the bean to fire the change of the {@link #degree}. */
    protected String propertyDegre;

    /** Name of the property of the bean to fire the change of the {@link #minute}. */
    protected String propertyMinute;

    /** Name of the property of the bean to fire the change of the {@link #decimal}. */
    protected String propertyDecimal;

    /**
     * {@code true} if longitude editor, {@code false} for latitude editor.
     */
    protected boolean longitudeEditor;

    public Serializable getBean() {
        return bean;
    }

    public void setBean(Serializable bean) {
        Object oldValue = getBean();
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public String getPropertySign() {
        return propertySign;
    }

    public void setPropertySign(String propertySign) {
        Object oldValue = getPropertySign();
        this.propertySign = propertySign;
        firePropertyChange(PROPERTY_PROPERTY_SIGN, oldValue, propertySign);
    }

    public String getPropertyDegree() {
        return propertyDegre;
    }

    public void setPropertyDegree(String propertyDegree) {
        Object oldValue = getPropertyDegree();
        this.propertyDegre = propertyDegree;
        firePropertyChange(PROPERTY_PROPERTY_DEGREE, oldValue, propertyDegree);
    }

    public String getPropertyMinute() {
        return propertyMinute;
    }

    public void setPropertyMinute(String propertyMinute) {
        Object oldValue = getPropertyMinute();
        this.propertyMinute = propertyMinute;
        firePropertyChange(PROPERTY_PROPERTY_MINUTE, oldValue, propertyMinute);
    }

    public String getPropertyDecimal() {
        return propertyDecimal;
    }

    public void setPropertyDecimal(String propertyDecimal) {
        Object oldValue = getPropertyDecimal();
        this.propertyDecimal = propertyDecimal;
        firePropertyChange(PROPERTY_PROPERTY_DECIMAL, oldValue, propertyDecimal);
    }

    public boolean isLongitudeEditor() {
        return longitudeEditor;
    }

    public void setLongitudeEditor(boolean longitudeEditor) {
        Object oldValue = isLongitudeEditor();
        this.longitudeEditor = longitudeEditor;
        firePropertyChange(PROPERTY_BEAN, oldValue, longitudeEditor);
    }

    public void setValue(DmdCoordinate value) {
        setSign(value != null && value.isSign());
        setDegree(value == null ? null : value.getDegree());
        setMinute(value == null ? null : value.getMinute());
        setDecimal(value == null ? null : value.getDecimal());
    }

    public String getMaskFormatterPattern() {
        String pattern = "**°**''**";
        if (isLongitudeEditor()) {
            // add one more degre
            pattern = "*" + pattern;
        }
        return pattern;
    }

    public String getStringPattern() {
        String pattern = "%s%s°%s'%s";
        return pattern;
    }
}
