package fr.ifremer.tutti.ui.swing.content.config;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiConfigUIHandler.java 1286 2013-10-08 13:47:04Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/config/TuttiConfigUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfigOption;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfigOption;
import fr.ifremer.tutti.ui.swing.content.GoToPreviousScreenAction;
import fr.ifremer.tutti.ui.swing.content.ReloadTuttiAction;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiLocationTableCell;
import fr.ifremer.tutti.ui.swing.util.editor.VesselTableCell;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.config.ConfigUI;
import jaxx.runtime.swing.config.ConfigUIHelper;
import jaxx.runtime.swing.config.model.MainCallBackFinalizer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import java.awt.BorderLayout;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class TuttiConfigUIHandler extends AbstractTuttiUIHandler<TuttiUIContext, TuttiConfigUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(TuttiConfigUIHandler.class);


    public static final String CALLBACK_APPLICATION = "application";

    public static final String CALLBACK_UI = "ui";

    public static final String CALLBACK_SHORTCUT = "shortcut";

    public TuttiConfigUIHandler(TuttiUI<?, ?> parentUI, TuttiConfigUI ui) {
        super(parentUI.getHandler().getContext(), ui);
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    @Override
    public void beforeInitUI() {

    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        TuttiApplicationConfig config = getConfig();

        ConfigUIHelper helper = new ConfigUIHelper(config.getApplicationConfig(),
                                                   config.getConfigFile());

        helper.registerCallBack(
                CALLBACK_UI, n_("tutti.config.action.reload.ui"),
                SwingUtil.createActionIcon("reload-ui"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadUI();
                    }
                }
        ).registerCallBack(
                CALLBACK_APPLICATION, n_("tutti.config.action.reload.application"),
                SwingUtil.createActionIcon("reload-application"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadApplication();
                    }
                }
        ).registerCallBack(
                CALLBACK_SHORTCUT, n_("tutti.config.action.reload.actions"),
                SwingUtil.createActionIcon("reload-shortcut"),
                new Runnable() {

                    @Override
                    public void run() {
                        reloadShortcuts();
                    }
                }
        );

        // Application category

        helper.addCategory(n_("tutti.config.category.applications"),
                           n_("tutti.config.category.applications.description"),
                           CALLBACK_APPLICATION)
                .addOption(TuttiServiceConfigOption.CSV_SEPARATOR)
                .setOptionShortLabel(_("tutti.config.option.csv.separator.shortLabel"))

                .addOption(TuttiApplicationConfigOption.UI_CONFIG_FILE)
                .setOptionShortLabel(_("tutti.config.option.ui.config.file.shortLabel"))

                .addOption(TuttiApplicationConfigOption.TOTAL_SORTED_WEIGHTS_DIFFERENCE_RATE)
                .setOptionShortLabel(_("tutti.config.option.weights.rate.difference.totalAndSorted.shortLabel"))

                .addOption(TuttiApplicationConfigOption.MAX_INDIVIDUAL_OBSERVATION_ROW_TO_CREATE)
                .setOptionShortLabel(_("tutti.config.option.ui.individualObservationRowsToCreate.shortLabel"));

        if (context.isDbLoaded()) {

            VesselTableCell vesselTableCellComponent = new VesselTableCell(context);
            helper.addOption(TuttiApplicationConfigOption.TREMIE_CAROUSSEL_VESSEL_ID)
                    .setOptionShortLabel(_("tutti.config.option.tremieCarousselVessel.shortLabel"))
                    .setOptionEditor(vesselTableCellComponent.getNewTableCellEditor())
                    .setOptionRenderer(vesselTableCellComponent.getNewTableCellRenderer());

            TuttiLocationTableCell tuttiLocationTableCellComponent = new TuttiLocationTableCell(context);
            helper.addOption(TuttiServiceConfigOption.EXPORT_COUNTRY_ID)
                    .setOptionShortLabel(_("tutti.config.option.export.countryId.shortLabel"))
                    .setOptionEditor(tuttiLocationTableCellComponent.getNewTableCellEditor())
                    .setOptionRenderer(tuttiLocationTableCellComponent.getNewTableCellRenderer());
        }

        // UI category

        helper.addCategory(n_("tutti.config.category.ui"),
                           n_("tutti.config.category.ui.description"),
                           CALLBACK_UI)
                .addOption(TuttiApplicationConfigOption.COLOR_ALTERNATE_ROW)
                .setOptionShortLabel(_("tutti.config.option.ui.color.alternateRow.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COLOR_SELECTED_ROW)
                .setOptionShortLabel(_("tutti.config.option.ui.color.selectedRow.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COLOR_ROW_INVALID)
                .setOptionShortLabel(_("tutti.config.option.ui.color.rowInvalid.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COLOR_ROW_READ_ONLY)
                .setOptionShortLabel(_("tutti.config.option.ui.color.rowReadOnly.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COLOR_CELL_WITH_VALUE)
                .setOptionShortLabel(_("tutti.config.option.ui.color.cellWithValue.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COLOR_ROW_TO_CONFIRM)
                .setOptionShortLabel(_("tutti.config.option.ui.color.rowToConfirm.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COLOR_COMPUTED_WEIGHTS)
                .setOptionShortLabel(_("tutti.config.option.ui.color.computedWeights.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COLOR_BLOCKING_LAYER)
                .setOptionShortLabel(_("tutti.config.option.ui.color.blockingLayer.shortLabel"))

                .addOption(TuttiApplicationConfigOption.DATE_FORMAT)
                .setOptionShortLabel(_("tutti.config.option.ui.dateFormat.shortLabel"))

                .addOption(TuttiApplicationConfigOption.COORDINATE_EDITOR_TYPE)
                .setOptionShortLabel(_("tutti.config.option.ui.coordinateEditorType.shortLabel"));

        // Weight Unit category

        helper.addCategory(n_("tutti.config.category.weightUnit"),
                           n_("tutti.config.category.weightUnit.description"),
                           CALLBACK_UI)
                .addOption(TuttiServiceConfigOption.WEIGHT_UNIT_SPECIES)
                .setOptionShortLabel(_("tutti.config.option.weight.unit.species.shortLabel"))

                .addOption(TuttiServiceConfigOption.WEIGHT_UNIT_BENTHOS)
                .setOptionShortLabel(_("tutti.config.option.weight.unit.benthos.shortLabel"))

                .addOption(TuttiServiceConfigOption.WEIGHT_UNIT_MARINE_LITTER)
                .setOptionShortLabel(_("tutti.config.option.weight.unit.marineLitter.shortLabel"))

                .addOption(TuttiServiceConfigOption.WEIGHT_UNIT_INDIVIDUAL_OBSERVATION)
                .setOptionShortLabel(_("tutti.config.option.weight.unit.individualObservation.shortLabel"))

                .addOption(TuttiServiceConfigOption.WEIGHT_UNIT_ACCIDENTAL_CATCH)
                .setOptionShortLabel(_("tutti.config.option.weight.unit.accidentalCatch.shortLabel"));

        // Technical category

        helper.addCategory(n_("tutti.config.category.technical"),
                           n_("tutti.config.category.technical.description"))
                .addOption(TuttiServiceConfigOption.BASEDIR)
                .setOptionShortLabel(_("tutti.config.option.basedir.shortLabel"))

                .addOption(TuttiServiceConfigOption.DATA_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.data.directory.shortLabel"))

                .addOption(TuttiServiceConfigOption.TMP_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.tmp.directory.shortLabel"))

                .addOption(TuttiApplicationConfigOption.TUTTI_I18N_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.i18n.directory.shortLabel"))

                .addOption(TuttiApplicationConfigOption.TUTTI_HELP_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.help.directory.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.DB_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.persistence.db.directory.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.DB_ATTACHMENT_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.persistence.db.attachment.directory.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.DB_PROTOCOL_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.persistence.db.protocol.directory.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.DB_CACHE_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.persistence.db.cache.directory.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.DB_BACKUP_DIRECTORY)
                .setOptionShortLabel(_("tutti.config.option.persistence.db.backup.directory.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.DB_CONFIGURATION_PATH)
                .setOptionShortLabel(_("tutti.config.option.persistence.db.configurationPath.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.DB_ENUMERATION_PATH)
                .setOptionShortLabel(_("tutti.config.option.persistence.db.enumerationPath.shortLabel"))

                .addOption(TuttiPersistenceConfigOption.JDBC_URL)
                .setOptionShortLabel(_("tutti.config.option.persistence.jdbc.url.shortLabel"))

                .addOption(TuttiServiceConfigOption.SITE_URL)
                .setOptionShortLabel(_("tutti.config.option.site.url.shortLabel"))

                .addOption(TuttiApplicationConfigOption.TUTTI_UPDATE_APPLICATION_URL)
                .setOptionShortLabel(_("tutti.config.option.update.application.url.shortLabel"))

                .addOption(TuttiApplicationConfigOption.TUTTI_UPDATE_DB_URL)
                .setOptionShortLabel(_("tutti.config.option.update.db.url.shortLabel"));

        helper.setFinalizer(new MainCallBackFinalizer(CALLBACK_APPLICATION));

        helper.setCloseAction(new Runnable() {
            @Override
            public void run() {

                TuttiActionHelper.runInternalAction(
                        TuttiConfigUIHandler.this,
                        GoToPreviousScreenAction.class);

            }
        });
        ConfigUI configUI = helper.buildUI(
                getUI(),
                n_("tutti.config.category.applications"));

        configUI.getHandler().setTopContainer(getUI());
        getUI().add(configUI, BorderLayout.CENTER);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
    }

    protected void reloadApplication() {
        ReloadTuttiAction action = TuttiActionHelper.createLogicAction(this, ReloadTuttiAction.class);
        TuttiActionHelper.runAction(action);
//        TuttiActionHelper.runActionAndWait(this, ReloadTuttiAction.class);
    }

    protected void reloadUI() {
        getContext().getMainUI().getHandler().reloadUI();
    }

    protected void reloadShortcuts() {
        getContext().getMainUI().getHandler().reloadUI();
    }

}
