/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel, SpeciesFrequencyUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    private SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private Map<Integer, SpeciesProtocol> speciesProtocol;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    protected Set<SpeciesFrequencyRowModel> withWeightRows = Sets.newHashSet();
    protected final WeightUnit weightUnit;

    public SpeciesFrequencyUIHandler(TuttiUIContext context, SpeciesFrequencyUI ui) {
        super(context, ui, "lengthStep", "number", "weight");
        this.weightUnit = context.getConfig().getSpeciesWeightUnit();
    }

    public SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesFrequencyUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesFrequencyRowModel row) {
        return row.getLengthStepCaracteristic() != null && row.getLengthStep() != null && (row.getNumber() == null && row.getWeight() == null || row.getNumber() != null && row.getNumber() > 0 && (this.withWeightRows.isEmpty() || row.getWeight() != null && row.getWeight().floatValue() > 0.0f));
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesFrequencyRowModel> rows) {
        super.onModelRowsChanged(rows);
        this.recomputeTotalNumberAndWeight();
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
        boolean recomputeAllRows;
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        if (row.getWeight() != null) {
            recomputeAllRows = this.withWeightRows.isEmpty();
            this.withWeightRows.add(row);
        } else {
            this.withWeightRows.remove(row);
            recomputeAllRows = this.withWeightRows.isEmpty();
        }
        if (recomputeAllRows) {
            for (SpeciesFrequencyRowModel r : model.getRows()) {
                this.recomputeRowValidState(r);
            }
        }
        this.recomputeTotalNumberAndWeight();
        if (!recomputeAllRows) {
            this.recomputeRowValidState(row);
        }
        if (row.isValid() && row.getNumber() == null && row.getWeight() == null) {
            model.addEmptyRow(row);
        } else {
            model.removeEmptyRow(row);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesFrequencyRowModel> rowMonitor, SpeciesFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
    }

    @Override
    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return ((SpeciesFrequencyUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel(this.weightUnit, sampleCategoryModel);
        ((SpeciesFrequencyUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        ArrayList lengthStepCaracterics = Lists.newArrayList((Iterable)this.getDataContext().getLengthStepCaracteristics());
        this.lengthStepCaracteristics = TuttiEntities.splitById((Iterable)lengthStepCaracterics);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        this.speciesProtocol = this.context.isProtocolFilled() ? this.persistenceService.toSpeciesProtocolMap() : Maps.newHashMap();
        Caracteristic modelCaracteristic = model.getLengthStepCaracteristic();
        this.initBeanFilterableComboBox(((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox(), lengthStepCaracterics, modelCaracteristic);
        Float precision = null;
        if (modelCaracteristic != null) {
            precision = model.getLengthStepCaracteristic().getPrecision();
        }
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        model.setStep(precision.floatValue());
        model.setMinStep(null);
        model.setMaxStep(null);
        ((SpeciesFrequencyUI)this.ui).getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getRafaleStepField().getModel();
                    SpeciesFrequencyUIHandler.this.applyRafaleStep(step);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Caracteristic newValue = (Caracteristic)evt.getNewValue();
                for (SpeciesFrequencyRowModel rowModel : ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).getRows()) {
                    rowModel.setLengthStepCaracteristic(newValue);
                    Float precision = null;
                    if (newValue != null) {
                        precision = newValue.getPrecision();
                    }
                    if (precision == null) {
                        precision = Float.valueOf(0.5f);
                    }
                    ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).setStep(precision.floatValue());
                    SpeciesFrequencyUIHandler.this.recomputeRowValidState(rowModel);
                }
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getValidator().doValidate();
            }
        });
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, TuttiUI.DECIMAL1_PATTERN, (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, this.weightUnit, (JTable)table);
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel(this.weightUnit, (TableColumnModelExt)columnModel, model);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        this.listenValidatorValid((SimpleBeanValidator)((SpeciesFrequencyUI)this.ui).getValidator(), model);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((SpeciesFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.frequencyEditor = null;
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean(null);
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setValid(false);
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setSimpleCount(null);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public void addLengthStepCaracteristic() {
        List allNumericCaracteristic = this.persistenceService.getAllNumericCaracteristic();
        ArrayList toSelect = Lists.newArrayList((Iterable)allNumericCaracteristic);
        List knownCaracteristics = ((SpeciesFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox().getData();
        toSelect.removeAll(knownCaracteristics);
        BeanFilterableComboBox editor = new BeanFilterableComboBox();
        editor.setBeanType(Caracteristic.class);
        editor.setShowReset(Boolean.valueOf(true));
        this.initBeanFilterableComboBox(editor, toSelect, null);
        int response = JOptionPane.showConfirmDialog(this.getTopestUI(), editor, I18n._((String)"tutti.editBenthosFrequencies.title.addLengthStepCaracteristic", (Object[])new Object[0]), 2);
        Caracteristic selectedItem = response == 0 ? (Caracteristic)editor.getSelectedItem() : null;
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setLengthStepCaracteristic(selectedItem);
    }

    public void generateLengthSteps() {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = this.getTableModel().getRowCache();
        Float minStep = Float.valueOf(model.getLengthStep(model.getMinStep().floatValue()));
        Float maxStep = Float.valueOf(model.getLengthStep(model.getMaxStep().floatValue()));
        Caracteristic lengthStepCaracteristic = model.getLengthStepCaracteristic();
        float i = minStep.floatValue();
        float step = model.getStep();
        while (i <= maxStep.floatValue()) {
            if (!rowsByStep.containsKey(Float.valueOf(i))) {
                SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
                newRow.setLengthStep(Float.valueOf(i));
                newRow.setLengthStepCaracteristic(lengthStepCaracteristic);
                rowsByStep.put(Float.valueOf(i), newRow);
            }
            i = TuttiUIUtil.getRoundedLengthStep(i + step, true);
        }
        ArrayList rows = Lists.newArrayList(rowsByStep.values());
        model.setRows(rows);
        AbstractSelectTableAction.doSelectCell((JTable)((SpeciesFrequencyUI)this.getUI()).getTable(), 0, 1);
    }

    public void applyRafaleStep(Float step) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = tableModel.getRowCache();
        SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow(row);
        } else {
            row = tableModel.createNewRow();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            row.setValid(true);
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, row);
        }
        Integer totalNumber = model.getTotalNumber();
        if (totalNumber == null) {
            totalNumber = 0;
        }
        model.setTotalNumber(totalNumber + 1);
        this.getTable().scrollRowToVisible(rowIndex);
    }

    public void editBatch(SpeciesFrequencyCellComponent.FrequencyCellEditor editor) {
        Integer number;
        Integer taxonId;
        SpeciesProtocol speciesProtocol;
        this.withWeightRows.clear();
        SpeciesBatchRowModel speciesBatch = editor.getEditRow();
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        model.setNextEditableRowIndex(editor.getNextEditableRowIndex());
        model.setTotalNumber(null);
        model.setTotalWeight(null);
        model.setSimpleCount(null);
        this.frequencyEditor = editor;
        Caracteristic lengthStepCaracteristic = null;
        ArrayList editFrequency = Lists.newArrayList();
        if (speciesBatch != null) {
            Species species;
            SpeciesProtocol sProtocol;
            List<SpeciesFrequencyRowModel> previousFrequency;
            Float lengthStep;
            List<SpeciesFrequencyRowModel> frequency = speciesBatch.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                Integer totalNumber = 0;
                Float totalWeight = Float.valueOf(0.0f);
                SpeciesFrequencyTableModel tableModel = this.getTableModel();
                for (SpeciesFrequencyRowModel rowModel : frequency) {
                    SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
                    newRow.setLengthStepCaracteristic(rowModel.getLengthStepCaracteristic());
                    newRow.setLengthStep(rowModel.getLengthStep());
                    newRow.setNumber(rowModel.getNumber());
                    newRow.setWeight(rowModel.getWeight());
                    editFrequency.add(newRow);
                    if (newRow.getWeight() != null) {
                        this.withWeightRows.add(newRow);
                        totalWeight = Float.valueOf(totalWeight.floatValue() + newRow.getWeight().floatValue());
                    } else {
                        totalWeight = null;
                    }
                    totalNumber = totalNumber + newRow.getNumber();
                }
                model.setTotalNumber(totalNumber);
                model.setTotalWeight(totalWeight);
                SpeciesFrequencyRowModel rowModel = frequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            SpeciesBatchRowModel previousSiblingRow = this.frequencyEditor.getPreviousSiblingRow();
            if (lengthStepCaracteristic == null && previousSiblingRow != null && CollectionUtils.isNotEmpty(previousFrequency = previousSiblingRow.getFrequency())) {
                SpeciesFrequencyRowModel rowModel = previousFrequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use previous sibling existing lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (lengthStepCaracteristic == null && (sProtocol = this.speciesProtocol.get((species = speciesBatch.getSpecies()).getReferenceTaxonId())) != null) {
                String lengthStepPmfmId = sProtocol.getLengthStepPmfmId();
                lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
                lengthStep = sProtocol.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will edit batch row: " + speciesBatch + " with " + editFrequency.size() + " frequency"));
        }
        SpeciesFrequencyUIModel.ConfigurationMode mode = SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE;
        if (lengthStepCaracteristic == null && ((speciesProtocol = this.speciesProtocol.get(taxonId = speciesBatch.getSpecies().getReferenceTaxonId())) == null || speciesProtocol.getLengthStepPmfmId() == null)) {
            mode = SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE_COUNTING;
        }
        if ((number = speciesBatch.getNumber()) != null && editFrequency.isEmpty()) {
            mode = SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE_COUNTING;
            model.setSimpleCount(number);
        }
        model.setConfigurationMode(mode);
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean((Object)model);
        Collections.sort(editFrequency);
        model.setRows(editFrequency);
        model.setLengthStepCaracteristic(lengthStepCaracteristic);
        model.setBatch(speciesBatch);
    }

    public void reset() {
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setRows(Lists.newArrayList());
    }

    public void saveAndClose() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Close UI " + this.ui));
        }
        HashSet lengths = Sets.newHashSet();
        Float doublon = null;
        int index = 0;
        for (SpeciesFrequencyRowModel row : ((SpeciesFrequencyUIModel)((Object)this.getModel())).getRows()) {
            Float lengthStep = row.getLengthStep();
            if (!lengths.add(lengthStep)) {
                doublon = lengthStep;
                break;
            }
            ++index;
        }
        if (doublon != null) {
            String message = I18n._((String)"tutti.editSpeciesFrequencies.error.length.doublon", (Object[])new Object[]{doublon, index + 1});
            TuttiUIContext.getErrorHelper().showErrorDialog(message);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), index, 0);
            return;
        }
        this.frequencyEditor.save((SpeciesFrequencyUIModel)((Object)this.getModel()), true);
        this.closeUI(this.ui);
    }

    public void saveAndContinue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Continue UI " + this.ui));
        }
        HashSet lengths = Sets.newHashSet();
        Float doublon = null;
        int index = 0;
        for (SpeciesFrequencyRowModel row : ((SpeciesFrequencyUIModel)((Object)this.getModel())).getRows()) {
            Float lengthStep = row.getLengthStep();
            if (!lengths.add(lengthStep)) {
                doublon = lengthStep;
                break;
            }
            ++index;
        }
        if (doublon != null) {
            String message = I18n._((String)"tutti.editSpeciesFrequencies.error.length.doublon", (Object[])new Object[]{doublon, index + 1});
            TuttiUIContext.getErrorHelper().showErrorDialog(message);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), index, 0);
            return;
        }
        this.frequencyEditor.save((SpeciesFrequencyUIModel)((Object)this.getModel()), false);
    }

    protected void recomputeTotalNumberAndWeight() {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        List rows = model.getRows();
        Integer totalNumber = 0;
        Float totalWeight = Float.valueOf(0.0f);
        for (SpeciesFrequencyRowModel r : rows) {
            Float weight;
            if (!r.isValid()) continue;
            Integer number = r.getNumber();
            if (number != null) {
                totalNumber = totalNumber + number;
            }
            if ((weight = r.getWeight()) == null) continue;
            totalWeight = Float.valueOf(totalWeight.floatValue() + weight.floatValue());
        }
        model.setTotalNumber(totalNumber);
        model.setTotalWeight(totalWeight);
    }
}

