/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTypeLocator
implements TypeLocator {
    private ClassLoader loader;
    private final List<String> knownPackagePrefixes = new ArrayList<String>();

    public StandardTypeLocator() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public StandardTypeLocator(ClassLoader loader) {
        this.loader = loader;
        this.registerImport("java.lang");
    }

    @Override
    public Class<?> findType(String typename) throws EvaluationException {
        String nameToLookup = typename;
        try {
            return this.loader.loadClass(nameToLookup);
        }
        catch (ClassNotFoundException ey) {
            for (String prefix : this.knownPackagePrefixes) {
                try {
                    nameToLookup = prefix + "." + typename;
                    return this.loader.loadClass(nameToLookup);
                }
                catch (ClassNotFoundException ex) {
                }
            }
            throw new SpelEvaluationException(SpelMessage.TYPE_NOT_FOUND, typename);
        }
    }

    public void registerImport(String prefix) {
        this.knownPackagePrefixes.add(prefix);
    }

    public List<String> getImportPrefixes() {
        return Collections.unmodifiableList(this.knownPackagePrefixes);
    }

    public void removeImport(String prefix) {
        this.knownPackagePrefixes.remove(prefix);
    }
}

