/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog(CachedIntrospectionResults.class);
    private static List<BeanInfoFactory> beanInfoFactories = SpringFactoriesLoader.loadFactories(BeanInfoFactory.class, (ClassLoader)CachedIntrospectionResults.class.getClassLoader());
    static final Set<ClassLoader> acceptedClassLoaders = new HashSet<ClassLoader>();
    static final Map<Class, Object> classCache = new WeakHashMap<Class, Object>();
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            Set<ClassLoader> set = acceptedClassLoaders;
            synchronized (set) {
                acceptedClassLoaders.add(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClassLoader(ClassLoader classLoader) {
        Iterator<Object> it;
        Object object = classCache;
        synchronized (object) {
            it = classCache.keySet().iterator();
            while (it.hasNext()) {
                Class beanClass = it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
                it.remove();
            }
        }
        object = acceptedClassLoaders;
        synchronized (object) {
            it = acceptedClassLoaders.iterator();
            while (it.hasNext()) {
                ClassLoader registeredLoader = (ClassLoader)it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(registeredLoader, classLoader)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CachedIntrospectionResults forClass(Class beanClass) throws BeansException {
        CachedIntrospectionResults results;
        Object value;
        Map<Class, Object> map = classCache;
        synchronized (map) {
            value = classCache.get(beanClass);
        }
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            results = (CachedIntrospectionResults)ref.get();
        } else {
            results = (CachedIntrospectionResults)value;
        }
        if (results == null) {
            if (ClassUtils.isCacheSafe((Class)beanClass, (ClassLoader)CachedIntrospectionResults.class.getClassLoader()) || CachedIntrospectionResults.isClassLoaderAccepted(beanClass.getClassLoader())) {
                results = new CachedIntrospectionResults(beanClass);
                map = classCache;
                synchronized (map) {
                    classCache.put(beanClass, results);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not strongly caching class [" + beanClass.getName() + "] because it is not cache-safe"));
            }
            results = new CachedIntrospectionResults(beanClass);
            map = classCache;
            synchronized (map) {
                classCache.put(beanClass, new WeakReference<CachedIntrospectionResults>(results));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        ClassLoader[] acceptedLoaderArray;
        Set<ClassLoader> set = acceptedClassLoaders;
        synchronized (set) {
            acceptedLoaderArray = acceptedClassLoaders.toArray(new ClassLoader[acceptedClassLoaders.size()]);
        }
        for (ClassLoader registeredLoader : acceptedLoaderArray) {
            if (!CachedIntrospectionResults.isUnderneathClassLoader(classLoader, registeredLoader)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader candidate, ClassLoader parent) {
        if (candidate == parent) {
            return true;
        }
        if (candidate == null) {
            return false;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class beanClass) throws BeansException {
        try {
            PropertyDescriptor[] pds;
            BeanInfoFactory beanInfoFactory;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Getting BeanInfo for class [" + beanClass.getName() + "]"));
            }
            BeanInfo beanInfo = null;
            Iterator<BeanInfoFactory> i$ = beanInfoFactories.iterator();
            while (i$.hasNext() && (beanInfo = (beanInfoFactory = i$.next()).getBeanInfo(beanClass)) == null) {
            }
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(beanClass);
            }
            this.beanInfo = beanInfo;
            Class classToFlush = beanClass;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Caching PropertyDescriptors for class [" + beanClass.getName() + "]"));
            }
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds = this.beanInfo.getPropertyDescriptors()) {
                if (Class.class.equals(beanClass) && "classLoader".equals(pd.getName())) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found bean property '" + pd.getName() + "'" + (pd.getPropertyType() != null ? " of type [" + pd.getPropertyType().getName() + "]" : "") + (pd.getPropertyEditorClass() != null ? "; editor [" + pd.getPropertyEditorClass().getName() + "]" : "")));
                }
                pd = this.buildGenericTypeAwarePropertyDescriptor(beanClass, pd);
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to obtain BeanInfo for class [" + beanClass.getName() + "]", ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && StringUtils.hasLength((String)name) && (pd = this.propertyDescriptorCache.get(name.substring(0, 1).toLowerCase() + name.substring(1))) == null) {
            pd = this.propertyDescriptorCache.get(name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        return pd == null || pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
    }

    PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        for (PropertyDescriptor pd : this.propertyDescriptorCache.values()) {
            pds[i] = pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
            ++i;
        }
        return pds;
    }

    private PropertyDescriptor buildGenericTypeAwarePropertyDescriptor(Class beanClass, PropertyDescriptor pd) {
        try {
            return new GenericTypeAwarePropertyDescriptor(beanClass, pd.getName(), pd.getReadMethod(), pd.getWriteMethod(), pd.getPropertyEditorClass());
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to re-introspect class [" + beanClass.getName() + "]", ex);
        }
    }
}

