/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUIHandler;
import java.io.File;
import org.nuiton.i18n.I18n;

public class SaveAttachmentAction
extends AbstractTuttiAction<TuttiUIContext, AttachmentEditorUI, AttachmentEditorUIHandler> {
    private Attachment attachment;
    protected File file;
    protected File attachmentFile;

    public SaveAttachmentAction(AttachmentEditorUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.attachmentFile = this.getContext().getPersistenceService().getAttachmentFile(this.attachment.getId());
            this.file = this.saveFile(TuttiIOUtil.getBaseName(this.attachment.getName()), TuttiIOUtil.getExtension(this.attachmentFile.getName()), I18n._((String)"tutti.attachmentEditor.saveAttachment.title", (Object[])new Object[0]), I18n._((String)"tutti.attachmentEditor.saveAttachment.button", (Object[])new Object[0]), new String[0]);
            doAction = this.file != null;
        }
        return doAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        AttachmentEditorUI ui = (AttachmentEditorUI)this.getUI();
        boolean hackDialog = ui.isAlwaysOnTop();
        if (hackDialog) {
            ui.setAlwaysOnTop(false);
        }
        try {
            TuttiIOUtil.copyFile(this.attachmentFile, this.file, I18n._((String)"tutti.attachmentEditor.saveAttachment.error.message", (Object[])new Object[]{this.attachmentFile, this.file.getName()}));
            this.sendMessage(I18n._((String)"tutti.attachmentEditor.saveAttachment.success.message", (Object[])new Object[]{this.file.getName()}));
        }
        finally {
            if (hackDialog) {
                ui.setAlwaysOnTop(true);
            }
        }
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    public void releaseAction() {
        super.releaseAction();
        this.attachmentFile = null;
        this.attachment = null;
        this.file = null;
    }
}

