/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.session;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import jaxx.runtime.swing.session.JSplitPaneState;
import jaxx.runtime.swing.session.JTabbedPaneState;
import jaxx.runtime.swing.session.JTableState;
import jaxx.runtime.swing.session.JXTableSwingSessionState;
import jaxx.runtime.swing.session.State;
import jaxx.runtime.swing.session.WindowState;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

public class SwingSession {
    private static final Log log = LogFactory.getLog(SwingSession.class);
    protected File file;
    protected boolean autoSave;
    protected Set<Component> registeredComponent = Sets.newIdentityHashSet();
    protected Map<Class, State> stateManager = Maps.newHashMap();
    protected Map<String, State> states;

    public SwingSession(File file, boolean autoSave) {
        this(file, autoSave, Maps.newHashMap());
    }

    public SwingSession(File file, boolean autoSave, Map<Class, State> additionalStates) {
        this.file = file;
        this.autoSave = autoSave;
        this.stateManager.put(Window.class, new WindowState());
        this.stateManager.put(JTable.class, new JTableState());
        this.stateManager.put(JTabbedPane.class, new JTabbedPaneState());
        this.stateManager.put(JSplitPane.class, new JSplitPaneState());
        this.stateManager.put(JXTable.class, new JXTableSwingSessionState());
        this.stateManager.putAll(additionalStates);
        this.states = this.loadStates(file);
        if (this.states == null) {
            this.states = Maps.newHashMap();
        }
    }

    protected void finalize() throws Throwable {
        this.save();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.updateState();
        AbortExceptionListener el = new AbortExceptionListener();
        ByteArrayOutputStream bst = new ByteArrayOutputStream();
        XMLEncoder e = null;
        try {
            e = new XMLEncoder(bst);
            e.setPersistenceDelegate(Rectangle.class, new RectanglePD());
            e.setExceptionListener(el);
            e.writeObject(this.states);
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (el.exception != null) {
            log.warn((Object)("save failed \"" + this.file + "\""), (Throwable)el.exception);
        } else {
            FileOutputStream ost = null;
            try {
                ost = new FileOutputStream(this.file);
                ((OutputStream)ost).write(bst.toByteArray());
            }
            catch (IOException eee) {
                log.warn((Object)("save failed \"" + this.file + "\""), (Throwable)eee);
            }
            finally {
                if (ost != null) {
                    try {
                        ((OutputStream)ost).close();
                    }
                    catch (IOException eee) {
                        log.warn((Object)("can't close properly \"" + this.file + "\""), (Throwable)eee);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, State> loadStates(File file) {
        Map result = null;
        if (file.exists()) {
            XMLDecoder d = null;
            try {
                FileInputStream ist = new FileInputStream(file);
                d = new XMLDecoder(ist);
                AbortExceptionListener eee = new AbortExceptionListener();
                d.setExceptionListener(eee);
                Object bean = d.readObject();
                if (eee.exception != null) {
                    log.warn((Object)("load failed \"" + file + "\""), (Throwable)eee.exception);
                } else {
                    result = (Map)bean;
                }
            }
            catch (IOException eee) {
                log.warn((Object)("load failed \"" + file + "\""), (Throwable)eee);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        return result;
    }

    public void updateState() {
        this.walkThrowComponent("", this.registeredComponent, new SaveStateAction());
    }

    public void add(Component c) {
        this.add(c, false);
    }

    public void add(final Component c, boolean replace) {
        if (c == null) {
            return;
        }
        final String cName = this.getComponentName(c);
        Object existingComponent = CollectionUtils.find(this.registeredComponent, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                Component comp = (Component)o;
                String compName = SwingSession.this.getComponentName(comp);
                return c.getClass().equals(comp.getClass()) && cName.equals(compName);
            }
        });
        if (existingComponent != null) {
            if (replace) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("replacing the component fir path /" + cName));
                }
                this.remove((Component)existingComponent);
            } else {
                log.warn((Object)String.format("Component already added %s(%s)", c.getClass(), c.getName()));
                return;
            }
        }
        this.registeredComponent.add(c);
        this.walkThrowComponent("", Collections.singleton(c), new RestoreStateAction());
    }

    public void remove(Component c) {
        this.registeredComponent.remove(c);
    }

    protected String getComponentName(Component c) {
        String name = c.getName();
        if (name == null) {
            int n = c.getParent().getComponentZOrder(c);
            if (n >= 0) {
                Class<?> clazz = c.getClass();
                name = clazz.getSimpleName();
                if (name.length() == 0) {
                    name = "Anonymous" + clazz.getSuperclass().getSimpleName();
                }
                name = name + n;
            } else {
                log.warn((Object)("Couldn't compute pathname for " + c));
            }
        }
        return name;
    }

    public State getStateManager(Class clazz) {
        State result = null;
        while (result == null && clazz != null) {
            result = this.stateManager.get(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public void addToStateManager(Class component, State state) {
        this.stateManager.put(component, state);
    }

    public State getStates(String path) {
        return this.states.get(path);
    }

    public void setStates(String path, State state) {
        this.states.put(path, state);
    }

    protected void walkThrowComponent(String path, Collection<Component> roots, Action action) {
        for (Component root : roots) {
            Component[] children;
            if (root == null) continue;
            String pathname = path + "/" + this.getComponentName(root);
            State state = this.getStateManager(root.getClass());
            if (state != null) {
                action.doAction(this, pathname, root);
            }
            if (root instanceof Container && (children = ((Container)root).getComponents()) != null && children.length > 0) {
                this.walkThrowComponent(pathname, Arrays.asList(children), action);
            }
            if (!(root instanceof JFrame) || (children = ((JFrame)root).getContentPane().getComponents()) == null || children.length <= 0) continue;
            this.walkThrowComponent(pathname, Arrays.asList(children), action);
        }
    }

    public static class RestoreStateAction
    implements Action {
        @Override
        public void doAction(SwingSession session, String path, Component c) {
            State manager = session.getStateManager(c.getClass());
            State state = session.getStates(path);
            if (state != null) {
                manager.setState(c, state);
            }
        }
    }

    public static class SaveStateAction
    implements Action {
        @Override
        public void doAction(SwingSession session, String path, Component c) {
            State manager = session.getStateManager(c.getClass());
            State state = manager.getState(c);
            session.setStates(path, state);
        }
    }

    public static interface Action {
        public void doAction(SwingSession var1, String var2, Component var3);
    }

    private static class RectanglePD
    extends DefaultPersistenceDelegate {
        public RectanglePD() {
            super(new String[]{"x", "y", "width", "height"});
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Rectangle oldR = (Rectangle)oldInstance;
            Object[] constructorArgs = new Object[]{oldR.x, oldR.y, oldR.width, oldR.height};
            return new Expression(oldInstance, oldInstance.getClass(), "new", constructorArgs);
        }
    }

    private static class AbortExceptionListener
    implements ExceptionListener {
        public Exception exception = null;

        private AbortExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            if (this.exception == null) {
                this.exception = e;
            }
        }
    }
}

