/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.decorator.PropertyDecorator;

public class DecoratorUtil {
    private static final Log log = LogFactory.getLog(DecoratorUtil.class);

    public static <O> PropertyDecorator<O> newPropertyDecorator(Class<O> type, String property) throws IllegalArgumentException, NullPointerException {
        return new PropertyDecorator<O>(type, property);
    }

    public static <O> JXPathDecorator<O> newJXPathDecorator(Class<O> type, String expression) throws IllegalArgumentException, NullPointerException {
        JXPathDecorator.Context<O> context = DecoratorUtil.createJXPathContext(expression);
        return new JXPathDecorator<O>(type, expression, context);
    }

    public static <O> MultiJXPathDecorator<O> newMultiJXPathDecorator(Class<O> type, String expression, String separator) throws IllegalArgumentException, NullPointerException {
        MultiJXPathDecorator<O> decorator = DecoratorUtil.newMultiJXPathDecorator(type, expression, separator, separator);
        return decorator;
    }

    public static <O> MultiJXPathDecorator<O> newMultiJXPathDecorator(Class<O> type, String expression, String separator, String separatorReplacement) throws IllegalArgumentException, NullPointerException {
        JXPathDecorator.Context<O>[] contexts = DecoratorUtil.createMultiJXPathContext(expression, separator, separatorReplacement);
        return new MultiJXPathDecorator<O>(type, expression, separator, separatorReplacement, contexts);
    }

    public static <O> void sort(JXPathDecorator<O> decorator, List<O> datas, int pos) {
        DecoratorUtil.sort(decorator, datas, pos, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <O> void sort(JXPathDecorator<O> decorator, List<O> datas, int pos, boolean reverse) {
        Comparator<O> c = null;
        boolean cachedComparator = false;
        try {
            c = decorator.getComparator(pos);
            cachedComparator = c instanceof JXPathDecorator.JXPathComparator;
            if (cachedComparator) {
                ((JXPathDecorator.JXPathComparator)c).init(decorator, datas);
            }
            Collections.sort(datas, c);
            if (reverse) {
                Collections.reverse(datas);
            }
        }
        finally {
            if (cachedComparator) {
                ((JXPathDecorator.JXPathComparator)c).clear();
            }
        }
    }

    public static <O> JXPathDecorator.Context<O> createJXPathContext(String expression) {
        int start;
        ArrayList<String> lTokens = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int size = expression.length();
        int end = -1;
        while ((start = expression.indexOf("${", end + 1)) > -1) {
            if (start > end + 1) {
                buffer.append(expression.substring(end + 1, start));
            }
            if ((end = expression.indexOf("}", start + 1)) == -1) {
                throw new IllegalArgumentException("could not find the rigth brace starting at car " + start + " : " + expression.substring(start + 2));
            }
            String jxpath = expression.substring(start + 2, end);
            if (jxpath.contains("${")) {
                throw new IllegalArgumentException("could not find a ${ inside a jxpath expression at car " + (start + 2) + " : " + jxpath);
            }
            lTokens.add(jxpath);
            buffer.append('%').append(lTokens.size());
        }
        if (size > end + 1) {
            buffer.append(expression.substring(end + 1));
        }
        String[] tokens = lTokens.toArray(new String[lTokens.size()]);
        return new JXPathDecorator.Context(buffer.toString(), tokens);
    }

    public static <O> JXPathDecorator.Context<O>[] createMultiJXPathContext(String expression, String separator, String separatorReplacement) {
        int sep = expression.indexOf(separator);
        if (sep == -1) {
            JXPathDecorator.Context<O>[] result = DecoratorUtil.newInstance(1);
            result[0] = DecoratorUtil.createJXPathContext(expression);
            return result;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(expression, separator);
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        int nbTokens = tokens.size();
        JXPathDecorator.Context<O>[] contexts = DecoratorUtil.newInstance(nbTokens);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will prepare " + nbTokens + " contexts from [" + expression + "]"));
        }
        for (int i = 0; i < nbTokens; ++i) {
            StringBuilder buffer = new StringBuilder(expression.length());
            for (int j = 0; j < nbTokens; ++j) {
                int index = (i + j) % nbTokens;
                String str = (String)tokens.get(index);
                Pattern p = Pattern.compile("\\%(" + (index + 1) + ")\\$");
                Matcher matcher = p.matcher(str);
                String safeStr = matcher.replaceAll("\\%" + (j + 1) + "\\$");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + (index + 1) + "-->" + (j + 1) + "] " + str + " transformed to " + safeStr));
                }
                buffer.append(separatorReplacement).append(safeStr);
            }
            String expr = buffer.substring(separatorReplacement.length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("context [" + i + "] : " + expr));
            }
            contexts[i] = DecoratorUtil.createJXPathContext(expr);
        }
        return contexts;
    }

    protected static <O> JXPathDecorator.Context<O>[] newInstance(int size) {
        return new JXPathDecorator.Context[size];
    }
}

