/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.OperationExportRow;
import java.util.List;
import org.nuiton.csv.ValueFormatter;

public class OperationExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<OperationExportRow> {
    protected final Caracteristic verticalOpeningCaracteristic;
    protected final Caracteristic horizontalOpeningWingCaracteristic;
    protected final Caracteristic horizontalOpeningDoorCaracteristic;

    public OperationExportModel(char separator, Caracteristic verticalOpeningCaracteristic, Caracteristic horizontalOpeningWingCaracteristic, Caracteristic horizontalOpeningDoorCaracteristic) {
        super(separator);
        this.verticalOpeningCaracteristic = verticalOpeningCaracteristic;
        this.horizontalOpeningWingCaracteristic = horizontalOpeningWingCaracteristic;
        this.horizontalOpeningDoorCaracteristic = horizontalOpeningDoorCaracteristic;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_Station", "stationNumber");
        this.newColumnForExport("Numero_Trait", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Engin", "gear", "name");
        this.newColumnForExport("Navire", "vessel", TuttiCsvUtil.VESSEL_VALUE_FORMATTER);
        this.newColumnForExport("DateDeb_Op", "gearShootingStartDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatDeb", "gearShootingStartLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongDeb", "gearShootingStartLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("DateFin_Op", "gearShootingEndDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatFin", "gearShootingEndLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongFin", "gearShootingEndLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Duree", "duration");
        this.newColumnForExport("Strate", "strata", "name", "NA");
        this.newColumnForExport("Sous-Strate", "subStrata", "name", "NA");
        this.newColumnForExport("Localite", "location", "name", "NA");
        this.newColumnForExport("Validite_OP", "fishingOperationValid", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Rectiligne", "fishingOperationRectiligne", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Distance", "trawlDistance", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Ouv_Verticale", "verticalOpeningGearUseFeature", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Ouv_Horizontale_Ailes", "horizontalOpeningWingGearUseFeature", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Ouv_Horizontale_Panneaux", "horizontalOpeningDoorGearUseFeature", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Saisisseur", "recorderPerson", TuttiCsvUtil.LIST_PERSON_FORMATTER);
        this.newColumnForExport("Commentaire", "comment");
        this.newNullableColumnForExport("Poids_Total", "catchTotalWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Calcule", "catchTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Vrac", "catchTotalSortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Vrac_Calcule", "catchTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_HorsVrac", "catchTotalUnsortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_HorsVrac_Calcule", "catchTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Non_Trie", "catchTotalRejectedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Non_Trie_Calcule", "catchTotalRejectedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Tremis", "catchTotalSortedTremisWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Tremis_Calcule", "catchTotalSortedTremisWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Carroussel", "catchTotalSortedCarousselWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Carroussel_Calcule", "catchTotalSortedCarousselWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece", "speciesTotalWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Espece_Calcule", "speciesTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac", "speciesTotalSortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Calcule", "speciesTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Trie", "speciesTotalSampleSortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Trie_Calcule", "speciesTotalSampleSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_HorsVrac", "speciesTotalUnsortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Espece_HorsVrac_Calcule", "speciesTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Inerte_Trie", "speciesTotalInertWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Espece_Inerte_Trie_Calcule", "speciesTotalInertWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vivant_non_detaille_trie", "speciesTotalLivingNotItemizedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Espece_Vivant_non_detaille_trie_Calcule", "speciesTotalLivingNotItemizedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos", "benthosTotalWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Benthos_Calcule", "benthosTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac", "benthosTotalSortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Calcule", "benthosTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Trie", "benthosTotalSampleSortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Trie_Calcule", "benthosTotalSampleSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_HorsVrac", "benthosTotalUnsortedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Benthos_HorsVrac_Calcule", "benthosTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Inerte_Trie", "benthosTotalInertWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Benthos_Inerte_Trie_Calcule", "benthosTotalInertWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vivant_non_detaille_trie", "benthosTotalLivingNotItemizedWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vivant_non_detaille_trie_Calcule", "benthosTotalLivingNotItemizedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Macro_Dechet", "marineLitterTotalWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Poids_Total_Macro_Dechet_Calcule", "marineLitterTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
    }

    public void prepareRows(List<OperationExportRow> rows, Cruise cruise, FishingOperation operation, CatchBatch catchBatch) {
        OperationExportRow row = new OperationExportRow(this.verticalOpeningCaracteristic, this.horizontalOpeningWingCaracteristic, this.horizontalOpeningDoorCaracteristic);
        row.setCruise(cruise);
        row.setFishingOperation(operation);
        row.setCatchBatch(catchBatch);
        rows.add(row);
    }
}

