/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolBenthosAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProtocolBenthosAction.class);
    private File file;

    public ExportProtocolBenthosAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile("tuttiProtocol-" + ((EditProtocolUIModel)this.getModel()).getName() + "-benthos", "csv", I18n._((String)"tutti.editProtocol.title.choose.benthosExportFile", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.action.chooseProtocolBenthosFile", (Object[])new Object[0]), "^.*\\.csv", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export protocol benthos to file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        ArrayList protocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getBenthosRow()) {
            if (!row.isValid()) continue;
            protocols.add(row.toBean());
        }
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportProtocolBenthos(this.file, (List)protocols, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        this.sendMessage(I18n._((String)"tutti.flash.info.species.exported.from.protocol", (Object[])new Object[]{this.file}));
    }
}

