package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportMultiPostAction.java 1198 2013-09-21 14:47:57Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.5.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/ImportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.TuttiMultiPostImportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractImportMultiPostAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;

import javax.swing.JTextArea;
import java.awt.Dialog;
import java.util.Collection;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ImportMultiPostAction extends AbstractImportMultiPostAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {

    protected Map<String, Object> notImportedData;

    public ImportMultiPostAction(BenthosBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiBenthos";
    }

    @Override
    protected String getFileExtensionDescription() {
        return _("tutti.common.file.tuttiBenthos");
    }

    @Override
    protected String getFileChooserTitle() {
        return _("tutti.editBenthosBatch.action.importMultiPost.sourceFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return _("tutti.editBenthosBatch.action.importMultiPost.sourceFile.button");
    }

    @Override
    public void releaseAction() {
        notImportedData = null;
        super.releaseAction();
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        notImportedData = multiPostImportExportService.importBenthos(file, operation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        if (!notImportedData.isEmpty()) {
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog((Dialog) getContext().getActionUI());

            Collection<BenthosBatch> notImportedBenthosBatches =
                    (Collection<BenthosBatch>) notImportedData.get(TuttiMultiPostImportService.BATCHES_KEY);

            StringBuffer stringBuffer = new StringBuffer();
            Float totalSortedWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT);
            if (totalSortedWeight != null) {
                stringBuffer.append("- " + _("tutti.multiPostImportLog.totalSortedWeight", totalSortedWeight) + "\n");
            }

            Float inertWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT);
            if (inertWeight != null) {
                stringBuffer.append("- " + _("tutti.multiPostImportLog.inertWeight", inertWeight) + "\n");
            }

            Float livingNotItemizedWeight =
                    (Float) notImportedData.get(CatchBatch.PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT);
            if (livingNotItemizedWeight != null) {
                stringBuffer.append("- " + _("tutti.multiPostImportLog.livingNotItemizedWeight", livingNotItemizedWeight) + "\n");
            }

            for (BenthosBatch sb : notImportedBenthosBatches) {
                stringBuffer.append("- " + decorate(sb.getSpecies()) + " / " + decorate(sb.getSampleCategoryValue()) + "\n");
            }

            if (stringBuffer.length() > 0) {
                JTextArea batchList = dialog.getBatchList();
                batchList.setText(stringBuffer.toString());
                dialog.setSize(400, 300);
                dialog.setLocationRelativeTo(getContext().getMainUI());
                dialog.setVisible(true);
            }
        }

        sendMessage(_("tutti.editBenthosBatch.action.importMultiPost.success", file));
    }
}
