package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: StartAction.java 1173 2013-09-17 10:18:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.5.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/StartAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.ui.swing.content.db.ImportDbAction;
import fr.ifremer.tutti.ui.swing.content.db.InstallDbAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Start action (when the start action file is present when
 * starting application).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4
 */
public class StartAction extends AbstractMainUITuttiAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(StartAction.class);

    protected AbstractMainUITuttiAction delegateAction;

    public StartAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        File actionfile = getConfig().getStartActionFile();
        boolean doAction = actionfile.exists();

        if (doAction) {

            try {
                // get action to execute
                String content = TuttiIOUtil.readContent(actionfile, _("tutti.error.read.startActionFile", actionfile));
                content = content.trim();

                if (InstallDbAction.class.getName().equals(content)) {

                    // install db
                    delegateAction = TuttiActionHelper.createLogicAction(getHandler(), InstallDbAction.class);

                    if (log.isInfoEnabled()) {
                        log.info("Found install db action");
                    }
                } else if (content.startsWith(ImportDbAction.class.getName())) {

                    // import db
                    ImportDbAction action = TuttiActionHelper.createLogicAction(getHandler(), ImportDbAction.class);
                    File importFile = new File(content.substring(ImportDbAction.class.getName().length() + 1));
                    action.setImportFile(importFile);
                    delegateAction = action;
                    if (log.isInfoEnabled()) {
                        log.info("Found import db action (with file " + importFile + ")");
                    }
                } else {
                    doAction = false;
                }

            } finally {

                // delete start action file
                TuttiIOUtil.deleteFile(
                        actionfile,
                        _("tutti.error.delete.startActionFile", actionfile));
            }
        }


        if (doAction) {
            setActionDescription(delegateAction.getActionDescription());
            doAction = delegateAction.prepareAction();
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {

        TuttiActionHelper.runInternalAction(delegateAction);
    }

    @Override
    protected void releaseAction() {
        delegateAction = null;
        super.releaseAction();
    }
}
