/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.PropagatePropertyChangeListener;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.service.ClosedPersistenceService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.ExportCatchesReportService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingService;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.service.catches.multipost.TuttiMultiPostImportExportService;
import fr.ifremer.tutti.service.export.TuttiExportService;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.service.pupitri.TuttiPupitriImportExportService;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.service.referential.TuttiReferentialSynchronizeService;
import fr.ifremer.tutti.service.sumatra.TuttiCatchesSumatraExportService;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.TuttiErrorHelper;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.UIMessageNotifier;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import jaxx.runtime.swing.session.BeanDoubleListState;
import jaxx.runtime.swing.session.BeanFilterableComboBoxState;
import jaxx.runtime.swing.session.SwingSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.i18n.init.UserI18nInitializer;

public class TuttiUIContext
extends AbstractBean
implements Closeable,
UIMessageNotifier,
JAXXHelpUIHandler,
PropagatePropertyChangeListener.PropagatePropertyChange {
    private static final Log log = LogFactory.getLog(TuttiUIContext.class);
    public static final String PROPERTY_PROGRAM_ID = "programId";
    public static final String PROPERTY_CRUISE_ID = "cruiseId";
    public static final String PROPERTY_PROTOCOL_ID = "protocolId";
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_PROGRAM_FILLED = "programFilled";
    public static final String PROPERTY_CRUISE__FILLED = "cruiseFilled";
    public static final String PROPERTY_PROTOCOL_FILLED = "protocolFilled";
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    public static final String PROPERTY_BUSY = "busy";
    public static final String PROPERTY_HIDE_BODY = "hideBody";
    public static final String PROPERTY_LOCALE = "locale";
    public static final Set<String> PROPERTIES_TO_SAVE = Sets.newHashSet((Object[])new String[]{"programId", "cruiseId", "protocolId", "locale"});
    public static final String PROPERTY_DB_EXIST = "dbExist";
    public static final String PROPERTY_DB_LOADED = "dbLoaded";
    private static TuttiUIContext applicationContext;
    protected final TuttiApplicationConfig config;
    protected final RessourceClassLoader resourceLoader;
    protected final TuttiServiceContext serviceContext;
    protected final SwingSession swingSession;
    protected final TuttiErrorHelper errorHelper;
    protected TuttiDataContext dataContext;
    protected TuttiHelpBroker helpBroker;
    protected TuttiScreen screen;
    protected Locale locale;
    protected boolean busy;
    protected boolean hideBody;
    protected final Set<UIMessageNotifier> messageNotifiers;
    private String validationContext;
    private MainUI mainUI;
    private TuttiActionUI actionUI;
    private boolean dbExist;
    private boolean dbLoaded;
    private Properties helpMapping;

    public static TuttiUIContext newContext(TuttiApplicationConfig config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new TuttiUIContext(config);
        return applicationContext;
    }

    public static TuttiUIContext getApplicationContext() {
        return applicationContext;
    }

    public static TuttiErrorHelper getErrorHelper() {
        return TuttiUIContext.applicationContext.errorHelper;
    }

    protected TuttiUIContext(TuttiApplicationConfig config) {
        this.config = config;
        this.resourceLoader = new RessourceClassLoader(Thread.currentThread().getContextClassLoader());
        this.serviceContext = new TuttiServiceContext(this.resourceLoader, config.getServiceConfig());
        HashMap additionalStates = Maps.newHashMap();
        additionalStates.put(BeanFilterableComboBox.class, new BeanFilterableComboBoxState());
        additionalStates.put(BeanDoubleList.class, new BeanDoubleListState());
        this.swingSession = new SwingSession(this.getConfig().getUIConfigFile(), false, (Map)additionalStates);
        this.errorHelper = new TuttiErrorHelper(this);
        this.dataContext = this.serviceContext.getDataContext();
        PropagatePropertyChangeListener.listenAndPropagateAll((AbstractBean)this.dataContext, (PropagatePropertyChangeListener.PropagatePropertyChange)this);
        UIMessageNotifier logMessageNotifier = new UIMessageNotifier(){

            @Override
            public void showInformationMessage(String message) {
                if (log.isInfoEnabled()) {
                    log.info((Object)message);
                }
            }
        };
        this.messageNotifiers = Sets.newHashSet();
        this.addMessageNotifier(logMessageNotifier);
    }

    public void init() {
        this.config.getServiceConfig().prepareDirectories();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.getResourceLoader());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Close context on shutdown");
                }
                TuttiUIContext.this.close();
            }
        }));
        this.config.getServiceConfig().getPersistenceConfig().initConfig(this.getResourceLoader());
        File i18nDirectory = this.config.getI18nDirectory();
        if (!this.config.isFullLaunchMode() && (i18nDirectory = new File(this.config.getDataDirectory(), "i18n")).exists()) {
            TuttiIOUtil.cleanDirectory((File)i18nDirectory, (String)I18n._((String)"tutti.i18n.deleteCache.error", (Object[])new Object[]{i18nDirectory}));
        }
        TuttiIOUtil.forceMkdir((File)i18nDirectory, (String)I18n._((String)"tutti.i18n.mkDir.error", (Object[])new Object[]{i18nDirectory}));
        if (log.isDebugEnabled()) {
            log.debug((Object)("I18N directory: " + i18nDirectory));
        }
        Locale i18nLocale = this.config.getI18nLocale();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts i18n with locale [%s] at [%s]", i18nLocale, i18nDirectory));
        }
        I18n.init((I18nInitializer)new UserI18nInitializer(i18nDirectory, new DefaultI18nInitializer("tutti-i18n")), (Locale)i18nLocale);
        File helpDirectory = this.config.getHelpDirectory();
        if (!this.config.isFullLaunchMode() && !helpDirectory.exists()) {
            helpDirectory = new File(this.config.getDataDirectory(), "help");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Help directory: " + helpDirectory));
        }
        TuttiIOUtil.forceMkdir((File)helpDirectory, (String)I18n._((String)"tutti.help.mkDir.error", (Object[])new Object[]{helpDirectory}));
        String mappingProperties = "/tutti-help-" + i18nLocale.getLanguage() + ".properties";
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(mappingProperties);
            this.helpMapping = new Properties();
            this.helpMapping.load(resourceAsStream);
        }
        catch (Exception eee) {
            log.error((Object)("Failed to load help mapping file at '" + mappingProperties + "'"), (Throwable)eee);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts help with locale at [%s]", helpDirectory));
        }
        this.setActionUI(new TuttiActionUI(null, this));
    }

    public void open() {
        this.setLocale(this.config.getI18nLocale());
        if (this.getProgramId() == null) {
            this.setProgramId(this.config.getProgramId());
        }
        if (this.getCruiseId() == null) {
            this.setCruiseId(this.config.getCruiseId());
        }
        if (this.getProtocolId() == null) {
            this.setProtocolId(this.config.getProtocolId());
        }
        boolean dbExists = this.config.getServiceConfig().getPersistenceConfig().isDbExists();
        this.setDbExist(dbExists);
        if (!dbExists) {
            this.setProtocolId(null);
            this.setProgramId(null);
            this.setCruiseId(null);
            this.setDbLoaded(false);
        }
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PROPERTIES_TO_SAVE.contains(evt.getPropertyName())) {
                    TuttiUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    @Override
    public void close() {
        PropertyChangeListener[] listeners;
        this.messageNotifiers.clear();
        this.validationContext = null;
        IOUtils.closeQuietly((Closeable)this.dataContext);
        this.setScreen(null);
        IOUtils.closeQuietly((Closeable)this.serviceContext);
        for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.removePropertyChangeListener(listener);
        }
        this.setMainUI(null);
        if (this.actionUI != null) {
            this.actionUI.getModel().clear();
        }
        this.setActionUI(null);
    }

    public PersistenceService getPersistenceService() {
        PersistenceService service;
        if (this.useRealPersistenceService()) {
            service = this.dataContext.getService();
            if (service == null) {
                service = (PersistenceService)this.serviceContext.getService(PersistenceService.class);
                this.dataContext.open(service);
            }
        } else {
            service = (PersistenceService)this.serviceContext.getService(ClosedPersistenceService.class);
        }
        return service;
    }

    public DecoratorService getDecoratorService() {
        return (DecoratorService)this.serviceContext.getService(DecoratorService.class);
    }

    public TuttiReferentialSynchronizeService getTuttiReferentialSynchronizeService() {
        return (TuttiReferentialSynchronizeService)this.serviceContext.getService(TuttiReferentialSynchronizeService.class);
    }

    public TuttiProtocolImportExportService getTuttiProtocolImportExportService() {
        return (TuttiProtocolImportExportService)this.serviceContext.getService(TuttiProtocolImportExportService.class);
    }

    public TuttiPupitriImportExportService getTuttiPupitriImportExportService() {
        return (TuttiPupitriImportExportService)this.serviceContext.getService(TuttiPupitriImportExportService.class);
    }

    public TuttiReferentialImportExportService getTuttiReferentialImportExportService() {
        return (TuttiReferentialImportExportService)this.serviceContext.getService(TuttiReferentialImportExportService.class);
    }

    public TuttiWeightComputingService getTuttiWeightComputingService() {
        return (TuttiWeightComputingService)this.serviceContext.getService(TuttiWeightComputingService.class);
    }

    public ValidateCruiseOperationsService getValidateCruiseOperationsService() {
        return (ValidateCruiseOperationsService)this.serviceContext.getService(ValidateCruiseOperationsService.class);
    }

    public ValidationService getValidationService() {
        return (ValidationService)this.serviceContext.getService(ValidationService.class);
    }

    public ExportCatchesReportService getGeneratePDFService() {
        return (ExportCatchesReportService)this.serviceContext.getService(ExportCatchesReportService.class);
    }

    public TuttiExportService getTuttiExportService() {
        return (TuttiExportService)this.serviceContext.getService(TuttiExportService.class);
    }

    public TuttiCatchesSumatraExportService getCatchesSumatraExportService() {
        return (TuttiCatchesSumatraExportService)this.serviceContext.getService(TuttiCatchesSumatraExportService.class);
    }

    public TuttiMultiPostImportExportService getMultiPostImportExportService() {
        return (TuttiMultiPostImportExportService)this.serviceContext.getService(TuttiMultiPostImportExportService.class);
    }

    public boolean useRealPersistenceService() {
        return this.isDbExist() && this.isDbLoaded();
    }

    public PersistenceService reloadPersistenceService() {
        try {
            this.serviceContext.close();
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.context.service.close.error", (Object[])new Object[0]), (Throwable)e);
        }
        this.dataContext.close();
        return this.getPersistenceService();
    }

    public void reloadDecoratorService() {
        this.serviceContext.reloadService(DecoratorService.class);
    }

    public TuttiDataContext getDataContext() {
        return this.dataContext;
    }

    public boolean isCruiseFilled() {
        return this.dataContext.isCruiseFilled();
    }

    public String getProgramId() {
        return this.dataContext.getProgramId();
    }

    public boolean isProtocolFilled() {
        return this.dataContext.isProtocolFilled();
    }

    public String getProtocolId() {
        return this.dataContext.getProtocolId();
    }

    public String getCruiseId() {
        return this.dataContext.getCruiseId();
    }

    public boolean isProgramFilled() {
        return this.dataContext.isProgramFilled();
    }

    public void setProgramId(String programId) {
        this.dataContext.setProgramId(programId);
    }

    public void setCruiseId(String cruiseId) {
        this.dataContext.setCruiseId(cruiseId);
    }

    public void setProtocolId(String protocolId) {
        this.dataContext.setProtocolId(protocolId);
    }

    public void clearDbContext() {
        this.dataContext.clearContext();
        this.saveContextToConfig();
    }

    public void checkDbContext() {
        this.getPersistenceService();
        this.dataContext.checkDbContext();
        this.saveContextToConfig();
    }

    public boolean isDbExist() {
        return this.dbExist;
    }

    public void setDbExist(boolean dbExist) {
        this.dbExist = dbExist;
        this.firePropertyChange(PROPERTY_DB_EXIST, null, dbExist);
    }

    public boolean isDbLoaded() {
        return this.dbLoaded;
    }

    public void setDbLoaded(boolean dbLoaded) {
        this.dbLoaded = dbLoaded;
        this.firePropertyChange(PROPERTY_DB_LOADED, null, dbLoaded);
    }

    public TuttiApplicationConfig getConfig() {
        return this.config;
    }

    protected void saveContextToConfig() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save config (programId: " + this.getProgramId() + ", cruiseId: " + this.getCruiseId() + ", protocolId: " + this.getProtocolId() + ", locale: " + this.getLocale() + ")"));
        }
        this.config.setProgramId(this.getProgramId());
        this.config.setCruiseId(this.getCruiseId());
        this.config.setProtocolId(this.getProtocolId());
        this.config.setI18nLocale(this.getLocale());
        this.config.save();
    }

    public MainUI getMainUI() {
        return this.mainUI;
    }

    public void setMainUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public TuttiActionUI getActionUI() {
        return this.actionUI;
    }

    public void setActionUI(TuttiActionUI actionUI) {
        this.actionUI = actionUI;
    }

    public SwingSession getSwingSession() {
        return this.swingSession;
    }

    public TuttiScreen getScreen() {
        return this.screen;
    }

    public void setScreen(TuttiScreen screen) {
        TuttiScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        this.firePropertyChange(PROPERTY_BUSY, null, busy);
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public void setHideBody(boolean hideBody) {
        this.hideBody = hideBody;
        this.firePropertyChange(PROPERTY_HIDE_BODY, null, hideBody);
    }

    public void addMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.add(messageNotifier);
    }

    public void removeMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.remove(messageNotifier);
    }

    @Override
    public void showInformationMessage(String message) {
        for (UIMessageNotifier messageNotifier : this.messageNotifiers) {
            messageNotifier.showInformationMessage(message);
        }
    }

    public RessourceClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public TuttiHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public void setHelpBroker(TuttiHelpBroker helpBroker) {
        this.helpBroker = helpBroker;
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        String value;
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("show help " + helpId));
        }
        if ((value = (String)this.helpMapping.get(helpId)) == null) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.context.helpPage.notFound", (Object[])new Object[]{helpId}));
        }
        String helpDirectory = this.getConfig().getHelpResourceWithLocale(value);
        boolean withFragment = helpDirectory.contains("#");
        String fragment = null;
        if (withFragment) {
            helpDirectory = StringUtils.substringBefore((String)helpDirectory, (String)"#");
            fragment = StringUtils.substringAfter((String)helpDirectory, (String)"#");
        }
        URI resolvedUri = new File(helpDirectory).toURI();
        try {
            if (withFragment) {
                resolvedUri = new URI(resolvedUri.toString() + "#" + fragment);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("help uri = " + resolvedUri));
            }
            TuttiUIUtil.openLink(resolvedUri);
        }
        catch (URISyntaxException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.context.helpPage.notFound", (Object[])new Object[]{resolvedUri}));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firePropertyChange(PROPERTY_LOCALE, null, locale);
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setFallBackScreen() {
        if (this.isDbLoaded()) {
            this.setScreen(TuttiScreen.SELECT_CRUISE);
        } else {
            this.setScreen(TuttiScreen.MANAGE_DB);
        }
    }
}

