/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolBenthosAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolBenthosAction.class);
    private File file;

    public ImportProtocolBenthosAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.editProtocol.title.choose.benthosImportFile", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.action.chooseProtocolBenthosFile", (Object[])new Object[0]), "^.*\\.csv", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        String message;
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol benthos file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiProtocol protocol = (TuttiProtocol)model.toBean();
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.importProtocolBenthos(this.file, protocol, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        List<EditProtocolSpeciesRowModel> rows = ((EditProtocolUIHandler)this.handler).toRows(protocol.getBenthos());
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().getHandler().reset();
        ((EditProtocolUI)this.getUI()).getBenthosComboBox().getHandler().reset();
        model.setBenthosRow(rows);
        ((EditProtocolUIHandler)this.getHandler()).getBenthosTableModel().setRows(rows);
        int nbSynonym = 0;
        for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
            if (speciesProtocol.isMadeFromAReferentTaxon()) continue;
            ++nbSynonym;
        }
        switch (nbSynonym) {
            case 0: {
                message = I18n._((String)"tutti.flash.info.benthos.imported.in.protocol", (Object[])new Object[]{this.file});
                break;
            }
            case 1: {
                message = I18n._((String)"tutti.flash.info.benthos.imported.in.protocol.oneReplaced", (Object[])new Object[]{this.file});
                break;
            }
            default: {
                message = I18n._((String)"tutti.flash.info.benthos.imported.in.protocol.severalReplaced", (Object[])new Object[]{this.file, nbSynonym});
            }
        }
        this.sendMessage(message);
    }
}

