package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCatchesUIHandler.java 1065 2013-05-31 16:16:35Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/EditCatchesUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import java.util.Set;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditCatchesUIHandler extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
        implements TabHandler {

    public static final String MAIN_CARD = "main";

    public static final String CREATE_BATCH_CARD = "createBatch";

    public static final String SPLIT_BATCH_CARD = "splitBatch";

    public static final String EDIT_FREQUENCY_CARD = "editFrequency";

    public static final String EDIT_CARACTERISTICS_CARD = "caracteristicsCard";

    public static final String CAROUSSEL_TREMIE_VESSEL = "carousselTremieVessel";

    public static final String CLASSIC_VESSEL = "classicVessel";

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditCatchesUIHandler.class);

    /**
     * To monitor changes on the incoming fishing operation.
     *
     * @since 0.3
     */
    private final TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;

    protected final FishingOperationsUI parentUi;

    public EditCatchesUIHandler(FishingOperationsUI parentUi, EditCatchesUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.parentUi = parentUi;
        this.catchBatchMonitor = new TuttiBeanMonitor<EditCatchesUIModel>(
                EditCatchesUIModel.PROPERTY_MARINE_LITTER_TOTAL_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_INERT_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT);
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {

        EditCatchesUIModel model = ui.getContextValue(EditCatchesUIModel.class);

        listModelIsModify(model);

        catchBatchMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        EditCatchesUIModel model = getModel();

        listenValidatorValid(getValidator(), model);

        setCustomTab(0, model);
        setCustomTab(1, ui.getSpeciesTabContent().getModel());
        setCustomTab(2, ui.getBenthosTabContent().getModel());
        setCustomTab(3, ui.getMarineLitterTabContent().getModel());
        setCustomTab(4, ui.getIndividualObservationTabContent().getModel());
        setCustomTab(5, ui.getAccidentalTabContent().getModel());

        getTabPanel().setSelectedIndex(1);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getCatchTotalWeightField();
    }

    @Override
    public void onCloseUI() {

        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
        ui.getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        // close batches tabs, then general tab
        closeUI(ui.getSpeciesTabContent());
        closeUI(ui.getBenthosTabContent());
        closeUI(ui.getMarineLitterTabContent());
        closeUI(ui.getAccidentalTabContent());
    }

    @Override
    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ui.getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet(
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_UNSORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_REJECTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_UNSORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_INERT_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_UNSORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_INERT_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_ATTACHMENT,
                EditCatchesUIModel.PROPERTY_BATCH_UPDATED
        ));
        return result;
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return ui.getTabPane();
    }

    @Override
    protected boolean onTabChanged(int currentIndex, int newIndex) {
        ui.getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ui.getComputeSpeciesBatchButton().setVisible(newIndex < 4);
        return super.onTabChanged(currentIndex, newIndex);
    }

    @Override
    public boolean onHideTab(int currentIndex, int newIndex) {

        ui.getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        //FIXME 20130203 kmorin: cannot change tab if model is modified
        // (I do not even know why it is set to modified and have no time 
        // before the demo)
        EditCatchesUIModel model = getModel();
        boolean result;
        if (model.isModify()) {

            if (model.isValid()) {

                // ask user to save, do not save or cancel action
                int answer = askSaveBeforeLeaving(
                        _("tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch"));
                switch (answer) {
                    case JOptionPane.OK_OPTION:

                        // persist catch batch
                        TuttiActionHelper.runAction(getUI().getSaveButton());

                        result = true;
                        break;

                    case JOptionPane.NO_OPTION:

                        // won't save modification
                        // so since we will edit a new operation, nothing to do here

                        // persist catch batch
                        TuttiActionHelper.runAction(getUI().getCancelButton());

                        result = true;
                        break;
                    default:

                        // other case, use cancel action
                        result = false;
                }
            } else {

                // model is not valid, ask user to loose modification or cancel
                result = askCancelEditBeforeLeaving(
                        _("tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch"));

                if (result) {

                    // ok will revert any modification
                    TuttiActionHelper.runAction(ui.getCancelButton());
                }
            }

        } else {

            // model not modify, can change tab
            result = true;
        }
        return result;
    }

    @Override
    public void onShowTab(int currentIndex, int newIndex) {
        registerValidators();
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return catchBatchMonitor;
    }

    public FishingOperationsUI getParentUi() {
        return parentUi;
    }

    public FishingOperationsUIHandler getParentHandler() {
        return getParentUi().getHandler();
    }

    protected void registerValidators() {
        registerValidators(getValidator(),
                           ui.getSpeciesTabContent().getHandler().getValidator(),
                           ui.getBenthosTabContent().getHandler().getValidator(),
                           ui.getMarineLitterTabContent().getHandler().getValidator()
        );
    }

    public void setSpeciesSelectedCard(String card) {
        JPanel panel = ui.getSpeciesTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext) panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);

            JPanel actionPanel = getUI().getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                registerValidators();
                actionPanel.setVisible(true);

            } else {
                actionPanel.setVisible(false);
                TuttiUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";

                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ui.getSpeciesTabCreateBatch();
                    titlePanel = ui.getSpeciesTabCreateBatchReminderLabel();
                    title = n_("tutti.createSpeciesBatch.title");

                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ui.getSpeciesTabSplitBatch();
                    titlePanel = ui.getSpeciesTabSplitBatchReminderLabel();
                    title = n_("tutti.splitSpeciesBatch.title");

                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ui.getSpeciesTabFrequencyEditor();
                    titlePanel = ui.getSpeciesTabFrequencyEditorReminderLabel();
                    title = n_("tutti.editSpeciesFrequencies.title");
                }

                if (tuttiUi != null) {
                    registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(ui.getSpeciesTabFishingOperationReminderLabel().getTitle() + " - " + _(title));
                }
            }
        }
    }

    public void setBenthosSelectedCard(String card) {
        JPanel panel = ui.getBenthosTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext) panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);

            JPanel actionPanel = getUI().getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                registerValidators();
                actionPanel.setVisible(true);

            } else {
                actionPanel.setVisible(false);
                TuttiUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";

                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ui.getBenthosTabCreateBatch();
                    titlePanel = ui.getBenthosTabCreateBatchReminderLabel();
                    title = n_("tutti.createBenthosBatch.title");

                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ui.getBenthosTabSplitBatch();
                    titlePanel = ui.getBenthosTabSplitBatchReminderLabel();
                    title = n_("tutti.splitBenthosBatch.title");

                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ui.getBenthosTabFrequencyEditor();
                    titlePanel = ui.getBenthosTabFrequencyEditorReminderLabel();
                    title = n_("tutti.editBenthosFrequencies.title");
                }

                if (tuttiUi != null) {
                    registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(ui.getBenthosTabFishingOperationReminderLabel().getTitle() + " - " + _(title));
                }
            }
        }
    }

    public void setMarineLitterSelectedCard(String card) {
        JPanel panel = ui.getMarineLitterTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext) panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);

            JPanel actionPanel = getUI().getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                registerValidators();
                actionPanel.setVisible(true);

            } else {
                actionPanel.setVisible(false);
                TuttiUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";

                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ui.getMarineLitterTabCreateBatch();
                    titlePanel = ui.getMarineLitterTabCreateBatchReminderLabel();
                    title = n_("tutti.createMarineLitterBatch.title");
                }

                if (tuttiUi != null) {
                    registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(ui.getMarineLitterTabCreateBatchReminderLabel().getTitle() + " - " + _(title));
                }
            }
        }
    }

    public void setIndividualObservationSelectedCard(String card) {
        setIndividualObservationSelectedCard(card, null);
    }

    public void setIndividualObservationSelectedCard(String card, Species species) {
        JPanel panel = ui.getIndividualObservationTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext) panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);

            JPanel actionPanel = getUI().getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                registerValidators();
                actionPanel.setVisible(true);

            } else {
                actionPanel.setVisible(false);
                TuttiUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";

                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ui.getIndividualObservationTabCreateBatch();
                    titlePanel = ui.getIndividualObservationTabCreateBatchReminderLabel();
                    title = n_("tutti.createIndividualObservationBatch.title");

                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ui.getIndividualObservationCaracteristicMapEditorReminderLabel();
                    title = n_("tutti.editCaracteristics.title");
                }

                if (tuttiUi != null) {
                    registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(ui.getIndividualObservationTabFishingOperationReminderLabel().getTitle() + " - " + _(title, decorate(species)));
                }
            }
        }
    }

    public void setAccidentalSelectedCard(String card) {
        setAccidentalSelectedCard(card, null);
    }

    public void setAccidentalSelectedCard(String card, Species species) {
        JPanel panel = ui.getAccidentalTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext) panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);

            JPanel actionPanel = getUI().getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                registerValidators();
                actionPanel.setVisible(true);

            } else {
                actionPanel.setVisible(false);
                TuttiUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";

                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ui.getAccidentalTabCreateBatch();
                    titlePanel = ui.getAccidentalTabCreateBatchReminderLabel();
                    title = n_("tutti.createAccidentalBatch.title");

                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ui.getAccidentalCaracteristicMapEditorReminderLabel();
                    title = n_("tutti.editCaracteristics.title");
                }


                if (tuttiUi != null) {
                    registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(ui.getAccidentalTabFishingOperationReminderLabel().getTitle() + " - " + _(title, decorate(species)));
                }
            }
        }
    }

}