package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class EditFishingOperationUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditFishingOperationUIModel, EditFishingOperationUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DURATION_FIELD_TEXT = "durationField.text";
    public static final String BINDING_FISHING_OPERATION_ATTACHMENTS_BUTTON_ENABLED = "fishingOperationAttachmentsButton.enabled";
    public static final String BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED = "fishingOperationInvalidRadio.selected";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL = "fishingOperationNumberField.model";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN = "fishingOperationNumberField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED = "fishingOperationRectiligneCheckBox.selected";
    public static final String BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED = "fishingOperationResetRadio.selected";
    public static final String BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED = "fishingOperationValidRadio.selected";
    public static final String BINDING_GEAR_COMBO_BOX_SELECTED_ITEM = "gearComboBox.selectedItem";
    public static final String BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE = "gearShootingEndDateField.date";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL = "gearShootingEndLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingEndLatitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingEndLatitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL = "gearShootingEndLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingEndLongitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingEndLongitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE = "gearShootingEndTimeField.date";
    public static final String BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE = "gearShootingStartDateField.date";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL = "gearShootingStartLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingStartLatitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingStartLatitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL = "gearShootingStartLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingStartLongitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingStartLongitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE = "gearShootingStartTimeField.date";
    public static final String BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM = "locationComboBox.selectedItem";
    public static final String BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT = "multirigAggregationField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_STATION_NUMBER_FIELD_TEXT = "stationNumberField.text";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM = "subStrataComboBox.selectedItem";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_ENABLED = "trawlDistanceField.enabled";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_MODEL = "trawlDistanceField.model";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN = "trawlDistanceField.numberPattern";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT = "trawlDistanceField.toolTipText";
    public static final String BINDING_VESSEL_FIELD_TEXT = "vesselField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAO1cS2wctxkeKdbLlvy27DhxI8uvlR8rWYodJ45jS1pJliHZinbtGvVBHe2OpElmZzYzXFvCwkGP6a0oUKCHFGhP6aFAUSS3AimKHnpMeyhaFG2BAu2xDYKit7YoyXlwOENyyJ0NnINz2FhD/h//F3/+fP7kH1qP52on39G3t4tu0wZm3SjemX748N76O0YVlAyv6poN4Lia/19Xt9b9SNtTi757QDv1aAmRjwfk47NOveHYhh2jvr6k7fbAjmV4W4YBgHaCpqh63ng5Kr6+3Wi6IWrEFAv1h1983v2d2rd+1K1p2w3InQtFGcmiIpLsWtK6zRrQDsKWHuvjlm5vQjZc096E/A6hb7OW7nl39brxnva+1rek9TZ0F4IBbVReZIyB6bcbQHvZqJlg3vS2YCv3GoarA9OxK05jRbcNC2gzG27R3HCNuuEWQRMAs9g0i94TWLlYdWwAWyg6IVVxjgF1f7HRwK31Aq1vS7drluECbTE/7G0fi6D31J0aYnkhP/YyQiLIA491y6zpUIlAu0CZMyoIGiij3wfhR4IwsmnobnnLcQAsLwPdBUuOvWmCZs1Y0nccyGXC5X24Wd2t+eWTc9uAwL2ShoOcEzRU7Sip/rV49Tm7lmg7UftEsrYIunfddd5FFh3ja72C/rwNFTqD6xLi48DVTbBg2FDxVkVfRz5XcRxrBgqkHUb+vh1A3Ak+I8KBiP7kRsJy0wDo1a06NLE3AxuF1tbe4PPVBKZV1COSok9CMFArJ6PGDicbQ9zCvkqxiXsNzeTRJF0gKCyhJdTX140aKkGE5yL6QwwlQdEdd7P4Dgx77wKn4UNsF+88rJjA8kEwF+eJURlclKuuY1ksXkgJIr8UoezZ9NmYd9w60I4xPBbCWphoIiI66AHc4t1mfd1wl/R11ElpteGPqPoUh2reNCwYGIdpjRnbABfQlC8lRY01jKpck6oetHiWISOKmLDH+/Xm8B805LF60wKma25Ob266xiZG5TXPqhsJdZ2uu8eDvgB0HtRevxjG/nVnxtkG2hU+8+uGbhdn4M+8aQEoOLRaSJcEba6Xhc0eiGrEERbpSkOWUxXqYX9YQQDSf9rvYBPo7zG67CiKWjBe6lUojukBs+pFvngF/aymYC5HMBUiDIIhES/OK6l0EFciQZRdawjVKulAXKECTcOrMMwI8+yaX+MOCFEsSAjKGJECilIp8r9b6Gc9pbjJCI+UnePjLZdLBvRtg4bdgINHDX+Xglg27SZgQNTxdymIsgHH/1oawsPfk0JOKQpZYgn5npKQJZaQEGKoZlTNum4tU7IykoDQJXlGP8knSVp9J2X1VyNAUlYQALLN/jSlETEGSyVPU3YXY7AM/5Rr+CuqcjIt/4GanEzTf8Az/fEUFIozwZA1wk4NUI0VswoTMNon0lgoJAVYVzOyp2A0KZv1hmUgOjIckhYOpxJKdhB7mZN48rw5ldZyAtj3U658NUIjZWd4aGw//jBlXwEAy7gfppxYAMDy4A+5HvyaknhM9/1IQTym737E893U9CIraL3CI0ja+acpO1+L4EjZWS4c29AfpzQhQmCp4uOUpUUILFN/zDX162oSMm39qYqETGN/yjP2sQRQFKZQ+XdpOyfrRmEIlX+PrgvFx1FkghFGRpMJ/apRhbHK3LSN2S2j+i5OjY9QM4nwOw00EOaJJN+M5YAw431ilWCmqdvVRAb3GacWrbTPUtJcZkgTMcHKVodqTZeRVf8+XYGeUpAKx5PKwosXUVc8Rbd3xDU8A+AqcKQARjjJPkRp0/+KSP7Mb2cVIa3qNdPBE8kYOf7Iwug9fRvaaAJPVlPzmtsp87FFw+ioxt/Qz9/J4JOsvWg/FtWP7DLJsEtUSJLI2MzWhT3ZrRnuiuF60HTQOYB2SWKqVnKacEKD6iOkf5KpE14heGB4nmFFlrtC19nzGBfTfvKvZHHkJYniAX9WxKYdxDOv5Kwthl116mg5JVxOmKTVMRgUBxnHkdQUf9o1dFT3v8QNUYv3PWPe0EHTNYJFEVQ4jn7O0yGFqjjrrwAqrhIGvlFcSMLdR7J2dZNZqK9HGd6OM6pG3Cmtj4bcPUgD+vz1pR2TJPNkpelEFWoaxefEoloV/XohQddgzHQoqlmkr/4Vle+Nynd7+mODW7ovsbAFVcJeUFq0NxyyaHggZVMEO0wqHGIoNlHlCDM0wKGDwQDafPBlWHCdZgOCuNpLVL2q5xXJbgFZzu96pPW4TfgZOuKj9AbDKizytxaOJbYWECAu/d/wod/9/E+fzIf7CXXY9hFm1dh2yJK2u+Ei7wAmanqfv5mA0vXxZb1x/ZE2ALUDh0S8V/Iyg7FyUAyZg+0dQOR+tn9b97YgRE/fH3/5q+Fv/vYFrXte2205em1eR/UXtQGwBUeILceqbTdu3sIcDT7ph7/7EW/Q/TZgbYCWZYDWs6FbnrENxX+ZIX7Ew/rAr/99qPyzW6EKuiBLL3KrEzX0fEPrNW3LtA28qYIM38fZRNnT8IxmzSH7IqydEq0Bx+lwGdr3pK5T+PdcStIXgLYLRW2g9bXwpgScbO42L1+zV1xjw9xGro/7dGCmnSLUDNTaEzwmQlrgNqFiEPYFLDH61yXEwDB7xe5ZsbOXHpUy2OgmWzTHWrbxZKRkbOhNCyBSvOFSGIOMDfnOCfsk+ga0iRYqL8c/WsXl+0uVxZWlubXFu5W51QfTS2vluaW52crivbtPmZz23JFgsIehpwG9CZwVp9GEIOOtYP+quGkAGKo3zM3CWNH0psMq8RVhLExKjVBna76A9+x5p9qEPbC3hQpg5X2oMsYJ06oJToMwSX4Sb8uvD1tkyj4Yr5pto5QKeBwzG9ufXArIaLBLEX8wvpCRjd3vQxswtldaI4XCrAMzL9OGCD53lZ2GMcZSMv53um5hbKwIHH9PtjA2wuZxL2vbTtQ7+5qeUYbzk8hJ+uGHeRQqwzBJu1IYOlNtNxrUVI7b5q54m2ELQzb2kxXYquHC78Mt2LvWJtdKiwuLlfLaynQF9rW7T3NyRybCchoJW4g1GihJus301PSrqBgyvxc5dM/almHB6qdao37QZm3fF1GdUYZzZmz3N7JdNT2CQ9adhv5eM/ZhaN2f3+imjbseT3DhDnAWM1AZR9cc29p5gDKdqm75m5Y+a5wxK2sfVEIBfYaNmoBSHfUjJAoVizUYDE7eGLGbFoqYewAUoWI20OwFaJcFhtKr/v/IvnURmA1i5qtCMzOo+ZbP3iyX0Pg+19zcAiU0gcUY0KFafBMy+WDtZ2e1DLtlv4Wmn/PoCMbhVnpv+CmyOVZ3UaCwDVS1SFEnrTWpRk6b6zWhuVjkfHsxts0l3DNQwnHim+U4DM5K9q1Fx1aC3fgrrbWCIuejY0qpAXNDX83sJ1qCnXpi/9cy5WDDJB3heps4tEfckvAIDg7fNUQnHLJ02kOy8FPESZKcxbyFPfpdlRr9+sMpBSTjaT3tjW9JeSMbb5SVBIsPeah54f4WfcqCON45iQ6EKJOOdkGSjnasCalQg+n4jhQ/UCIRXAbDbHoRGHUYyeNBBuFgf4nZvDcUOG3jomTEQfQcmyaOu6iZ8VArdWqFWPJ8NmMhcdKYEqNPSErbc0rGnhEp36SJ8zrqVh2OWTWEShp2ICZ/2raX5WwbQnDMmz5WpGbhg63kiSJi4LFM7kLapH0vSVPS5p2UMG9EybcufYxK3bhHiHGXAqSkbfuJ6GnTTkiZNkTgWDZ11EvCsIHhVuMrIgupU1jIRgW16TxaC/Pz6MUqNnc1quep54bUwTD13JAmF+SG6QNo8jp8O6XD+HG3L1mFoslQTAcBRyqTIQY1X4HpY37y+ssOHuHBv4Re+uEk1bBreirVzA4qIaJ6UIkoBUGFOqjYaUWgpcCEInYB/K0dJSC09pSAKTOUEB3GlJ9pycUE6nxVUvKr6hC0Cq5LqoCG4OuCc+5UXikTSuzM2bWkSl5VBaAV8rqiQhAAXx3M82sSiyW9/jIY0O62ZvC//G2ynaK/z+qf1fdLCuJhtaHbRtEBW2h+wxlTk2cAJOaBsWRpqBU7AKAypfHJEv27N/yqOtHx6dQnOgGdYKITO/6QpZlumDWtwbmFg3x/J1pNjJRyIRo/a/46mOGrvRClVsHfHFPFz1qoWWlvK37UgpjpjJSzJ4Ow/402kVxIpw1UlOxsAvOQ8yXqKe0BktKiZCaZzgZiplPZi1KpLKLmpLHUuRe1ucnxFu/WBzFqdghkYCTtea0dENq8NyTMywLhW5t7PUaiZwbKGSFGX06DcVY5r0tZnMEcxwG4V3cknLjXCq79jbayrgamNhRuqg/2nDlJqZ3EQWaCknU3QaK7hKuUl+j+zTlAj/c8meuVJ1rlxYW7cyV0VmBtirFsSWKF4Jam3wDLq25LxxERMsfFpO9XSLickkL9vdJkMBUoyCf4MhTkI7eloNhZ5U4ryD+mraAgn+DLUJCP3JaCYofNn3fJDnTJUntd8lU5hcZOMSQdj3GtjEn31eqgJYUO2ss4JxPq75yM/nyVpY6RxJSYvgoVEbNOcrB0OZNTlxwtZl/cU8k5TjJyDh2IUo632hCJuYY321bGkb2gl3EBViG4XRT5UnjnSTK2sc4IEXfjv+LAD20LbfoXBcxxMtkrvAqBTUaZ7IDGVw4/kOVUjjCOyV5O7rBy2GkGXzn8LCOncoRJhuy16+fdMGc3bDO/mJJSpiC9OCsQJSO7eFadslO5xVkJ3WWnFi9yOZXNLKbz6ZGjwcxnICTWZNK83miPV7QHhc+V7arh3bNRgepRXeaJd+HteAlpYkY7wrwa33n2opuuKkncCJXEpV91SuVwN1S3RDiLRjPqmysyS0bie+EKI8cFtlmoa8wdmZtyn9Xijxvzyh0jjcvpyZL32hVGDQlFskcLrmL4o0Q+xQgHCcnr+p1VDDtv4yqGn7blU4wwa5N8heB518vR9dpM2CZlFCnI11KPdUgvBj2bjtipZO1Mtt6yc7XkQxTKi0C3cumQo72sZ1BUcodXUrmDePnnTWVhmIs/021kDtlLP8JngxSC13m+73R0vsl7X5Mfuuba8ieZuabco0cKgStbieyAxVMKP1DlUoowTsk95NRRpbDTBZ5S+NlCLqUIkwW5x6med7c2u1ubecJlCSUK0oTTXCEysoRn0fk6lSOcztRZdopwlMOlbIZwM4/+OJrLeA6vrYUcuSMziYaTyzgjXIULVkm4L4epLeEcSsBQCzgdYUx68aZX8vY0nXq9oXwRDr9l4yde7aamTEgT7GCrsm93kyzvZhtXHn2e+Tme4JkyiWgZewUiNrFKsoYhC2MjN26MzEALoFe3Kqv358iJvOxz2pxnhfask/eDeI8PyUuNXyRTk3pKSer56aVyTOzsM4Scp9PaF1z4GJtMACCin5cSPby43ylDkdftZA6GEm7DzQbTSzJLHjHEo1NgG/VLygRH/VghH0v9WKEAix8GJJ52VH1KIP1Ao8pTAhS1+nUxilz9uhhNLrguln6rMktNffGXLs61Tkq6ZZhjxd4fqMTb7uSN8qGE8tt91oCCwSNcol/E78tR0qBnLoBfrcCTl51EMN4FVXPcfS3qZU+Vq60hofoFrJBS/QJWRCm4gEW9Zar0EkvoHIEKvh43WClALTBTvdhe3cURcTLIPlMudyE2FI2TudOvtMrcCSG9YC/9mmjSqFOZvNH0vLzxqpScNBbuS9ElqId5L0Gxm8BRJ/DEaxKemBBXEDTTz7RKOCWt/YuZ7ASPn/pqj3T1dmd0FYDTSrosoaSQK8GFqtijrvLXNg6TYWHWp+dc1RiXcrdIPvb9nPjDshKdKuBxOvvBJfwKMjObxK8iJy5a9bj+asAgenJx2Tbqjm1WgXYndzvFegRGu91cfmgqwt+ReYUqC5HvS+xXpZUylDNR3hwm9WfPjoSflp2aubETT5tFM7lAHPR0bbIseYMO1UGXBTGa/0wuOhVSZpD6pcUqelH0acoXZuX4mWOV85xAdGQ3C1PhyG4WFN/ssdeBJZZOAsuJdqICVvxHiVnMJK+p+jVTFiy0ZrkQYjtKdDw+d1xL3sqFStlyTsaWAjC+Nam3oGUuR4d7kXvfhIFfH1k37Rps6q0Udhf81XZnIsLPPehl8Z4pNkJBgqd+9PQpetRCgHNbipM3BQjLuRHezq2Ncm6EzdwI2S88ZiG8nxvh27kRfpAb4ce5ET7JjfCL3Ai/yY3wh9wIf8mN8HnuvvlFboT/5JWiayg3wj6I8H9D230Pi3cAAA==";
    private static final Log log = LogFactory.getLog(EditFishingOperationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected JPanel createFishingOperationActions;
    protected JTextField durationField;
    protected JLabel durationLabel;
    protected EditFishingOperationUI editFishingOperationTopPanel = this;
    protected ButtonAttachment fishingOperationAttachmentsButton;
    protected JRadioButton fishingOperationInvalidRadio;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationNumber",  editorName = "fishingOperationNumberField")
    protected NumberEditor fishingOperationNumberField;
    protected JLabel fishingOperationNumberLabel;
    protected JPanel fishingOperationPane;
    protected JCheckBox fishingOperationRectiligneCheckBox;
    protected JRadioButton fishingOperationResetRadio;
    protected JTabbedPane fishingOperationTabPane;
    protected JScrollPane fishingOperationTabScrollPane;
    protected JAXXButtonGroup fishingOperationValid;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationValid",  editorName = "fishingOperationValidPanel")
    protected JToolBar fishingOperationValidPanel;
    protected JRadioButton fishingOperationValidRadio;
    protected Table gearCaracteristicsTable;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearComboBox")
    protected BeanFilterableComboBox<Gear> gearComboBox;
    protected JLabel gearDateLabel;
    protected JLabel gearLabel;
    protected JLabel gearLatitudeLabel;
    protected JLabel gearLongitudeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndDate",  editorName = "gearShootingEndDateField")
    protected JXDatePicker gearShootingEndDateField;
    protected JLabel gearShootingEndLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitude",  editorName = "gearShootingEndLatitudeDDField")
    protected NumberEditor gearShootingEndLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDecimalDegree",  editorName = "gearShootingEndLatitudeDMDDegreeField")
    protected NumberEditor gearShootingEndLatitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDecimalMinute",  editorName = "gearShootingEndLatitudeDMDMinuteField")
    protected NumberEditor gearShootingEndLatitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDegree",  editorName = "gearShootingEndLatitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeMinute",  editorName = "gearShootingEndLatitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeSecond",  editorName = "gearShootingEndLatitudeDMSSecondField")
    protected NumberEditor gearShootingEndLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLatitudeLayout;
    protected JPanel gearShootingEndLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitude",  editorName = "gearShootingEndLongitudeDDField")
    protected NumberEditor gearShootingEndLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDecimalDegree",  editorName = "gearShootingEndLongitudeDMDDegreeField")
    protected NumberEditor gearShootingEndLongitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDecimalMinute",  editorName = "gearShootingEndLongitudeDMDMinuteField")
    protected NumberEditor gearShootingEndLongitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDegree",  editorName = "gearShootingEndLongitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeMinute",  editorName = "gearShootingEndLongitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeSecond",  editorName = "gearShootingEndLongitudeDMSSecondField")
    protected NumberEditor gearShootingEndLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLongitudeLayout;
    protected JPanel gearShootingEndLongitudePanel;
    protected SimpleTimeEditor gearShootingEndTimeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartDate",  editorName = "gearShootingStartDateField")
    protected JXDatePicker gearShootingStartDateField;
    protected JLabel gearShootingStartLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitude",  editorName = "gearShootingStartLatitudeDDField")
    protected NumberEditor gearShootingStartLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDecimalDegree",  editorName = "gearShootingStartLatitudeDMDDegreeField")
    protected NumberEditor gearShootingStartLatitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDecimalMinute",  editorName = "gearShootingStartLatitudeDMDMinuteField")
    protected NumberEditor gearShootingStartLatitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDegree",  editorName = "gearShootingStartLatitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeMinute",  editorName = "gearShootingStartLatitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeSecond",  editorName = "gearShootingStartLatitudeDMSSecondField")
    protected NumberEditor gearShootingStartLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLatitudeLayout;
    protected JPanel gearShootingStartLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitude",  editorName = "gearShootingStartLongitudeDDField")
    protected NumberEditor gearShootingStartLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDecimalDegree",  editorName = "gearShootingStartLongitudeDMDDegreeField")
    protected NumberEditor gearShootingStartLongitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDecimalMinute",  editorName = "gearShootingStartLongitudeDMDMinuteField")
    protected NumberEditor gearShootingStartLongitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDegree",  editorName = "gearShootingStartLongitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeMinute",  editorName = "gearShootingStartLongitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeSecond",  editorName = "gearShootingStartLongitudeDMSSecondField")
    protected NumberEditor gearShootingStartLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLongitudeLayout;
    protected JPanel gearShootingStartLongitudePanel;
    protected SimpleTimeEditor gearShootingStartTimeField;
    protected JLabel gearTimeLabel;
    protected TabInfo gearUseFeatureTab;
    protected GearUseFeatureTabUI gearUseFeatureTabContent;
    protected JXTitledPanel gearUseFeatureTabPane;
    protected Table generalForm;
    protected EditFishingOperationUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "location",  editorName = "locationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> locationComboBox;
    protected JLabel locationLabel;
    protected EditFishingOperationUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigAggregation",  editorName = "multirigAggregationField")
    protected JTextField multirigAggregationField;
    protected JLabel multirigAggregationLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "recorderPerson",  editorName = "recorderPersonList")
    protected BeanDoubleList<Person> recorderPersonList;
    protected JButton resetValidStateButton;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected JTextField stationNumberField;
    protected JLabel stationNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "strata",  editorName = "strataComboBox")
    protected BeanFilterableComboBox<TuttiLocation> strataComboBox;
    protected JLabel strataLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "subStrata",  editorName = "subStrataComboBox")
    protected BeanFilterableComboBox<TuttiLocation> subStrataComboBox;
    protected JLabel subStrataLabel;
    protected TabInfo traitGeneralTab;
    protected JXTitledPanel traitGeneralTabPane;
    protected JToolBar traitGeneralTabPaneToolBar;
    protected Table traitVesselPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "trawlDistance",  editorName = "trawlDistanceField")
    protected NumberEditor trawlDistanceField;
    protected JLabel trawlDistanceLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditFishingOperationUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JLabel vesselField;
    protected JLabel vesselLabel;
    protected TabInfo vesselUseFeatureTab;
    protected VesselUseFeatureTabUI vesselUseFeatureTabContent;
    protected JXTitledPanel vesselUseFeatureTabPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HBox $HBox0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel10;
    private JPanel $JPanel11;
    private JPanel $JPanel12;
    private JPanel $JPanel13;
    private JPanel $JPanel14;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;
    private JPanel $JPanel7;
    private JPanel $JPanel8;
    private JPanel $JPanel9;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditFishingOperationUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditFishingOperationUIHandler handler = new EditFishingOperationUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI() {
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fishingOperationInvalidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.FALSE);
    }

    public void doActionPerformed__on__fishingOperationValidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.TRUE);
    }

    public void doActionPerformed__on__gearShootingEndDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingEndDate");
    }

    public void doActionPerformed__on__gearShootingStartDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingStartDate");
    }

    public void doActionPerformed__on__resetValidStateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(null);
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doItemStateChanged__on__fishingOperationRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "fishingOperationRectiligne");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__multirigAggregationField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "multirigAggregation");
    }

    public void doKeyReleased__on__stationNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "stationNumber");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JTextField getDurationField() {
        return durationField;
    }

    public JLabel getDurationLabel() {
        return durationLabel;
    }

    public ButtonAttachment getFishingOperationAttachmentsButton() {
        return fishingOperationAttachmentsButton;
    }

    public JRadioButton getFishingOperationInvalidRadio() {
        return fishingOperationInvalidRadio;
    }

    public NumberEditor getFishingOperationNumberField() {
        return fishingOperationNumberField;
    }

    public JLabel getFishingOperationNumberLabel() {
        return fishingOperationNumberLabel;
    }

    public JPanel getFishingOperationPane() {
        return fishingOperationPane;
    }

    public JCheckBox getFishingOperationRectiligneCheckBox() {
        return fishingOperationRectiligneCheckBox;
    }

    public JRadioButton getFishingOperationResetRadio() {
        return fishingOperationResetRadio;
    }

    public JTabbedPane getFishingOperationTabPane() {
        return fishingOperationTabPane;
    }

    public JScrollPane getFishingOperationTabScrollPane() {
        return fishingOperationTabScrollPane;
    }

    public JAXXButtonGroup getFishingOperationValid() {
        return fishingOperationValid;
    }

    public JToolBar getFishingOperationValidPanel() {
        return fishingOperationValidPanel;
    }

    public JRadioButton getFishingOperationValidRadio() {
        return fishingOperationValidRadio;
    }

    public Table getGearCaracteristicsTable() {
        return gearCaracteristicsTable;
    }

    public BeanFilterableComboBox<Gear> getGearComboBox() {
        return gearComboBox;
    }

    public JLabel getGearDateLabel() {
        return gearDateLabel;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public JLabel getGearLatitudeLabel() {
        return gearLatitudeLabel;
    }

    public JLabel getGearLongitudeLabel() {
        return gearLongitudeLabel;
    }

    public JXDatePicker getGearShootingEndDateField() {
        return gearShootingEndDateField;
    }

    public JLabel getGearShootingEndLabel() {
        return gearShootingEndLabel;
    }

    public NumberEditor getGearShootingEndLatitudeDDField() {
        return gearShootingEndLatitudeDDField;
    }

    public NumberEditor getGearShootingEndLatitudeDMDDegreeField() {
        return gearShootingEndLatitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingEndLatitudeDMDMinuteField() {
        return gearShootingEndLatitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSDegreeField() {
        return gearShootingEndLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSMinuteField() {
        return gearShootingEndLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSSecondField() {
        return gearShootingEndLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLatitudeLayout() {
        return gearShootingEndLatitudeLayout;
    }

    public JPanel getGearShootingEndLatitudePanel() {
        return gearShootingEndLatitudePanel;
    }

    public NumberEditor getGearShootingEndLongitudeDDField() {
        return gearShootingEndLongitudeDDField;
    }

    public NumberEditor getGearShootingEndLongitudeDMDDegreeField() {
        return gearShootingEndLongitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingEndLongitudeDMDMinuteField() {
        return gearShootingEndLongitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSDegreeField() {
        return gearShootingEndLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSMinuteField() {
        return gearShootingEndLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSSecondField() {
        return gearShootingEndLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLongitudeLayout() {
        return gearShootingEndLongitudeLayout;
    }

    public JPanel getGearShootingEndLongitudePanel() {
        return gearShootingEndLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public JXDatePicker getGearShootingStartDateField() {
        return gearShootingStartDateField;
    }

    public JLabel getGearShootingStartLabel() {
        return gearShootingStartLabel;
    }

    public NumberEditor getGearShootingStartLatitudeDDField() {
        return gearShootingStartLatitudeDDField;
    }

    public NumberEditor getGearShootingStartLatitudeDMDDegreeField() {
        return gearShootingStartLatitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingStartLatitudeDMDMinuteField() {
        return gearShootingStartLatitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSDegreeField() {
        return gearShootingStartLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSMinuteField() {
        return gearShootingStartLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSSecondField() {
        return gearShootingStartLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLatitudeLayout() {
        return gearShootingStartLatitudeLayout;
    }

    public JPanel getGearShootingStartLatitudePanel() {
        return gearShootingStartLatitudePanel;
    }

    public NumberEditor getGearShootingStartLongitudeDDField() {
        return gearShootingStartLongitudeDDField;
    }

    public NumberEditor getGearShootingStartLongitudeDMDDegreeField() {
        return gearShootingStartLongitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingStartLongitudeDMDMinuteField() {
        return gearShootingStartLongitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSDegreeField() {
        return gearShootingStartLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSMinuteField() {
        return gearShootingStartLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSSecondField() {
        return gearShootingStartLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLongitudeLayout() {
        return gearShootingStartLongitudeLayout;
    }

    public JPanel getGearShootingStartLongitudePanel() {
        return gearShootingStartLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public JLabel getGearTimeLabel() {
        return gearTimeLabel;
    }

    public TabInfo getGearUseFeatureTab() {
        return gearUseFeatureTab;
    }

    public GearUseFeatureTabUI getGearUseFeatureTabContent() {
        return gearUseFeatureTabContent;
    }

    public JXTitledPanel getGearUseFeatureTabPane() {
        return gearUseFeatureTabPane;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public EditFishingOperationUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<TuttiLocation> getLocationComboBox() {
        return locationComboBox;
    }

    public JLabel getLocationLabel() {
        return locationLabel;
    }

    public EditFishingOperationUIModel getModel() {
        return model;
    }

    public JTextField getMultirigAggregationField() {
        return multirigAggregationField;
    }

    public JLabel getMultirigAggregationLabel() {
        return multirigAggregationLabel;
    }

    public BeanDoubleList<Person> getRecorderPersonList() {
        return recorderPersonList;
    }

    public JButton getResetValidStateButton() {
        return resetValidStateButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberLabel() {
        return stationNumberLabel;
    }

    public BeanFilterableComboBox<TuttiLocation> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public BeanFilterableComboBox<TuttiLocation> getSubStrataComboBox() {
        return subStrataComboBox;
    }

    public JLabel getSubStrataLabel() {
        return subStrataLabel;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public JXTitledPanel getTraitGeneralTabPane() {
        return traitGeneralTabPane;
    }

    public JToolBar getTraitGeneralTabPaneToolBar() {
        return traitGeneralTabPaneToolBar;
    }

    public Table getTraitVesselPanel() {
        return traitVesselPanel;
    }

    public NumberEditor getTrawlDistanceField() {
        return trawlDistanceField;
    }

    public JLabel getTrawlDistanceLabel() {
        return trawlDistanceLabel;
    }

    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return validator;
    }

    public JLabel getVesselField() {
        return vesselField;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    public TabInfo getVesselUseFeatureTab() {
        return vesselUseFeatureTab;
    }

    public VesselUseFeatureTabUI getVesselUseFeatureTabContent() {
        return vesselUseFeatureTabContent;
    }

    public JXTitledPanel getVesselUseFeatureTabPane() {
        return vesselUseFeatureTabPane;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel10() {
        return $JPanel10;
    }

    protected JPanel get$JPanel11() {
        return $JPanel11;
    }

    protected JPanel get$JPanel12() {
        return $JPanel12;
    }

    protected JPanel get$JPanel13() {
        return $JPanel13;
    }

    protected JPanel get$JPanel14() {
        return $JPanel14;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected JPanel get$JPanel8() {
        return $JPanel8;
    }

    protected JPanel get$JPanel9() {
        return $JPanel9;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
    }

    protected void addChildrenToEditFishingOperationTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(traitGeneralTabPaneToolBar);
        add(fishingOperationPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFishingOperationInvalidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationInvalidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationInvalidRadio); }
    }

    protected void addChildrenToFishingOperationPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationPane.add(fishingOperationTabPane, BorderLayout.CENTER);
        fishingOperationPane.add($JPanel14, BorderLayout.SOUTH);
    }

    protected void addChildrenToFishingOperationResetRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationResetRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationResetRadio); }
    }

    protected void addChildrenToFishingOperationTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabPane.add(traitGeneralTabPane);
        fishingOperationTabPane.add(gearUseFeatureTabPane);
        fishingOperationTabPane.add(vesselUseFeatureTabPane);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 0));
        gearUseFeatureTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 1));
        vesselUseFeatureTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 2));
    }

    protected void addChildrenToFishingOperationTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabScrollPane.getViewport().add(generalForm);
    }

    protected void addChildrenToFishingOperationValidPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationValidPanel.add(resetValidStateButton, BorderLayout.WEST);
        fishingOperationValidPanel.add(fishingOperationResetRadio, BorderLayout.EAST);
    }

    protected void addChildrenToFishingOperationValidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationValidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationValidRadio); }
    }

    protected void addChildrenToGearCaracteristicsTable() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsTable.add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLatitudeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLongitudeLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearDateLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearTimeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLatitudePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLongitudePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartDateField), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartTimeField, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLatitudePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLongitudePanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndDateField), new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndTimeField, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel0, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(fishingOperationRectiligneCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel10, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel1, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel11, new GridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(fishingOperationValidPanel), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($HBox0, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel12, new GridBagConstraints(2, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGearShootingEndLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDDField), "DD");
        gearShootingEndLatitudePanel.add($JPanel6, "DMS");
        gearShootingEndLatitudePanel.add($JPanel7, "DMD");
    }

    protected void addChildrenToGearShootingEndLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDDField), "DD");
        gearShootingEndLongitudePanel.add($JPanel8, "DMS");
        gearShootingEndLongitudePanel.add($JPanel9, "DMD");
    }

    protected void addChildrenToGearShootingStartLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDDField), "DD");
        gearShootingStartLatitudePanel.add($JPanel2, "DMS");
        gearShootingStartLatitudePanel.add($JPanel3, "DMD");
    }

    protected void addChildrenToGearShootingStartLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDDField), "DD");
        gearShootingStartLongitudePanel.add($JPanel4, "DMS");
        gearShootingStartLongitudePanel.add($JPanel5, "DMD");
    }

    protected void addChildrenToGearUseFeatureTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        gearUseFeatureTabPane.add(gearUseFeatureTabContent);
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add(stationNumberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(stationNumberField), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationNumberLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(fishingOperationNumberField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(multirigAggregationLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(multirigAggregationField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(strataComboBox), new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(subStrataComboBox), new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(locationComboBox), new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel0, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel13, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 4, 6, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTraitGeneralTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        traitGeneralTabPane.add(fishingOperationTabScrollPane);
    }

    protected void addChildrenToTraitGeneralTabPaneToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        traitGeneralTabPaneToolBar.add(fishingOperationAttachmentsButton);
    }

    protected void addChildrenToTraitVesselPanel() {
        if (!allComponentsCreated) {
            return;
        }
        traitVesselPanel.add(vesselLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(vesselField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(gearLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(SwingUtil.boxComponentWithJxLayer(gearComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselUseFeatureTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselUseFeatureTabPane.add(vesselUseFeatureTabContent);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editeditFishingOperation.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.editFishingOperation.action.cancelEditFishingOperation"));
        cancelButton.setToolTipText(_("tutti.editFishingOperation.action.cancelEditFishingOperation.tip"));
        cancelButton.putClientProperty("help", "tutti.editFishingOperation.action.cancelEditFishingOperation.help");
        cancelButton.putClientProperty("tuttiAction", CancelEditFishingOperationAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tutti.editFishingOperation.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editFishingOperation.field.comment.help");
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createDurationField() {
        $objectMap.put("durationField", durationField = new JTextField());
        
        durationField.setName("durationField");
        durationField.setColumns(15);
        durationField.setEnabled(false);
        durationField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.duration"));
    }

    protected void createDurationLabel() {
        $objectMap.put("durationLabel", durationLabel = new JLabel());
        
        durationLabel.setName("durationLabel");
        durationLabel.setText(_("tutti.editFishingOperation.field.duration"));
        durationLabel.setToolTipText(_("tutti.editFishingOperation.field.duration.tip"));
        durationLabel.putClientProperty("help", "tutti.editFishingOperation.field.duration.help");
    }

    protected void createFishingOperationAttachmentsButton() {
        $objectMap.put("fishingOperationAttachmentsButton", fishingOperationAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        fishingOperationAttachmentsButton.setName("fishingOperationAttachmentsButton");
        fishingOperationAttachmentsButton.setToolTipText(_("tutti.editFishingOperation.action.attachments.tip"));
        fishingOperationAttachmentsButton.putClientProperty("help", "tutti.editFishingOperation.action.attachments.help");
    }

    protected void createFishingOperationInvalidRadio() {
        $objectMap.put("fishingOperationInvalidRadio", fishingOperationInvalidRadio = new JRadioButton());
        
        fishingOperationInvalidRadio.setName("fishingOperationInvalidRadio");
        fishingOperationInvalidRadio.setText(_("tutti.editFishingOperation.field.fishingOperationInvalid"));
        fishingOperationInvalidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationInvalidRadio"));
    }

    protected void createFishingOperationNumberField() {
        $objectMap.put("fishingOperationNumberField", fishingOperationNumberField = new NumberEditor(this));
        
        fishingOperationNumberField.setName("fishingOperationNumberField");
        fishingOperationNumberField.setProperty("fishingOperationNumber");
        fishingOperationNumberField.setUseFloat(false);
        fishingOperationNumberField.setShowReset(true);
        fishingOperationNumberField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.fishingOperationNumber"));
        fishingOperationNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createFishingOperationNumberLabel() {
        $objectMap.put("fishingOperationNumberLabel", fishingOperationNumberLabel = new JLabel());
        
        fishingOperationNumberLabel.setName("fishingOperationNumberLabel");
        fishingOperationNumberLabel.setText(_("tutti.editFishingOperation.field.fishingOperationNumber"));
        fishingOperationNumberLabel.setToolTipText(_("tutti.editFishingOperation.field.fishingOperationNumber.tip"));
        fishingOperationNumberLabel.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationNumber.help");
    }

    protected void createFishingOperationPane() {
        $objectMap.put("fishingOperationPane", fishingOperationPane = new JPanel());
        
        fishingOperationPane.setName("fishingOperationPane");
        fishingOperationPane.setLayout(new BorderLayout());
    }

    protected void createFishingOperationRectiligneCheckBox() {
        $objectMap.put("fishingOperationRectiligneCheckBox", fishingOperationRectiligneCheckBox = new JCheckBox());
        
        fishingOperationRectiligneCheckBox.setName("fishingOperationRectiligneCheckBox");
        fishingOperationRectiligneCheckBox.setText(_("tutti.editFishingOperation.field.fishingOperationRectiligne"));
        fishingOperationRectiligneCheckBox.setToolTipText(_("tutti.editFishingOperation.field.fishingOperationRectiligne.tip"));
        fishingOperationRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fishingOperationRectiligneCheckBox"));
        fishingOperationRectiligneCheckBox.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationRectiligne.help");
    }

    protected void createFishingOperationResetRadio() {
        $objectMap.put("fishingOperationResetRadio", fishingOperationResetRadio = new JRadioButton());
        
        fishingOperationResetRadio.setName("fishingOperationResetRadio");
    }

    protected void createFishingOperationTabPane() {
        $objectMap.put("fishingOperationTabPane", fishingOperationTabPane = new JTabbedPane());
        
        fishingOperationTabPane.setName("fishingOperationTabPane");
    }

    protected void createFishingOperationTabScrollPane() {
        $objectMap.put("fishingOperationTabScrollPane", fishingOperationTabScrollPane = new JScrollPane());
        
        fishingOperationTabScrollPane.setName("fishingOperationTabScrollPane");
        fishingOperationTabScrollPane.putClientProperty("onlyVerticalScrollable", true);
    }

    protected void createFishingOperationValid() {
        $objectMap.put("fishingOperationValid", fishingOperationValid = new JAXXButtonGroup());
    }

    protected void createFishingOperationValidPanel() {
        $objectMap.put("fishingOperationValidPanel", fishingOperationValidPanel = new JToolBar());
        
        fishingOperationValidPanel.setName("fishingOperationValidPanel");
        fishingOperationValidPanel.setLayout(new BorderLayout());
        fishingOperationValidPanel.setFloatable(false);
        fishingOperationValidPanel.setOpaque(false);
        fishingOperationValidPanel.setToolTipText(_("tutti.editFishingOperation.field.fishingOperationValid.tip"));
        fishingOperationValidPanel.setBorderPainted(false);
        fishingOperationValidPanel.putClientProperty("help", "tutti.editFishingOperation.field.fishingOperationValid.help");
        fishingOperationValidPanel.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.fishingOperationValidity"));
    }

    protected void createFishingOperationValidRadio() {
        $objectMap.put("fishingOperationValidRadio", fishingOperationValidRadio = new JRadioButton());
        
        fishingOperationValidRadio.setName("fishingOperationValidRadio");
        fishingOperationValidRadio.setText(_("tutti.editFishingOperation.field.fishingOperationValid"));
        fishingOperationValidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationValidRadio"));
    }

    protected void createGearCaracteristicsTable() {
        $objectMap.put("gearCaracteristicsTable", gearCaracteristicsTable = new Table());
        
        gearCaracteristicsTable.setName("gearCaracteristicsTable");
    }

    protected void createGearComboBox() {
        $objectMap.put("gearComboBox", gearComboBox = new BeanFilterableComboBox<Gear>(this));
        
        gearComboBox.setName("gearComboBox");
        gearComboBox.setI18nPrefix("tutti.property.");
        gearComboBox.setProperty("gear");
        gearComboBox.setShowReset(true);
        gearComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gear"));
    }

    protected void createGearDateLabel() {
        $objectMap.put("gearDateLabel", gearDateLabel = new JLabel());
        
        gearDateLabel.setName("gearDateLabel");
        gearDateLabel.setText(_("tutti.editFishingOperation.field.gearDate"));
        gearDateLabel.setToolTipText(_("tutti.editFishingOperation.field.gearDate.tip"));
        gearDateLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearDate.help");
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
        gearLabel.setText(_("tutti.editFishingOperation.field.gear"));
        gearLabel.setToolTipText(_("tutti.editFishingOperation.field.gear.tip"));
        gearLabel.putClientProperty("help", "tutti.editFishingOperation.field.gear.help");
    }

    protected void createGearLatitudeLabel() {
        $objectMap.put("gearLatitudeLabel", gearLatitudeLabel = new JLabel());
        
        gearLatitudeLabel.setName("gearLatitudeLabel");
        gearLatitudeLabel.setToolTipText(_("tutti.editFishingOperation.field.gearLatitude.tip"));
        gearLatitudeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearLatitude.help");
    }

    protected void createGearLongitudeLabel() {
        $objectMap.put("gearLongitudeLabel", gearLongitudeLabel = new JLabel());
        
        gearLongitudeLabel.setName("gearLongitudeLabel");
        gearLongitudeLabel.setToolTipText(_("tutti.editFishingOperation.field.gearLongitude.tip"));
        gearLongitudeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearLongitude.help");
    }

    protected void createGearShootingEndDateField() {
        $objectMap.put("gearShootingEndDateField", gearShootingEndDateField = new JXDatePicker());
        
        gearShootingEndDateField.setName("gearShootingEndDateField");
        gearShootingEndDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingEndDateField"));
        gearShootingEndDateField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndDate"));
        gearShootingEndDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLabel() {
        $objectMap.put("gearShootingEndLabel", gearShootingEndLabel = new JLabel());
        
        gearShootingEndLabel.setName("gearShootingEndLabel");
        gearShootingEndLabel.setText(_("tutti.editFishingOperation.field.gearShootingEnd"));
        gearShootingEndLabel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingEnd.tip"));
        gearShootingEndLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEnd.help");
    }

    protected void createGearShootingEndLatitudeDDField() {
        $objectMap.put("gearShootingEndLatitudeDDField", gearShootingEndLatitudeDDField = new NumberEditor(this));
        
        gearShootingEndLatitudeDDField.setName("gearShootingEndLatitudeDDField");
        gearShootingEndLatitudeDDField.setUseSign(true);
        gearShootingEndLatitudeDDField.setProperty("gearShootingEndLatitude");
        gearShootingEndLatitudeDDField.setUseFloat(true);
        gearShootingEndLatitudeDDField.setShowReset(false);
        gearShootingEndLatitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitude"));
        gearShootingEndLatitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLatitudeDMDDegreeField() {
        $objectMap.put("gearShootingEndLatitudeDMDDegreeField", gearShootingEndLatitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMDDegreeField.setName("gearShootingEndLatitudeDMDDegreeField");
        gearShootingEndLatitudeDMDDegreeField.setUseSign(true);
        gearShootingEndLatitudeDMDDegreeField.setProperty("gearShootingEndLatitudeDegree");
        gearShootingEndLatitudeDMDDegreeField.setUseFloat(false);
        gearShootingEndLatitudeDMDDegreeField.setShowReset(false);
        gearShootingEndLatitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeDegree"));
        gearShootingEndLatitudeDMDDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLatitudeDMDMinuteField() {
        $objectMap.put("gearShootingEndLatitudeDMDMinuteField", gearShootingEndLatitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMDMinuteField.setName("gearShootingEndLatitudeDMDMinuteField");
        gearShootingEndLatitudeDMDMinuteField.setUseSign(false);
        gearShootingEndLatitudeDMDMinuteField.setProperty("gearShootingEndLatitudeDecimalMinute");
        gearShootingEndLatitudeDMDMinuteField.setUseFloat(true);
        gearShootingEndLatitudeDMDMinuteField.setShowReset(false);
        gearShootingEndLatitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeMinute"));
        gearShootingEndLatitudeDMDMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLatitudeDMSDegreeField", gearShootingEndLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSDegreeField.setName("gearShootingEndLatitudeDMSDegreeField");
        gearShootingEndLatitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLatitudeDMSDegreeField.setProperty("gearShootingEndLatitudeDegree");
        gearShootingEndLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLatitudeDMSDegreeField.setShowReset(false);
        gearShootingEndLatitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeDegree"));
        gearShootingEndLatitudeDMSDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLatitudeDMSMinuteField", gearShootingEndLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSMinuteField.setName("gearShootingEndLatitudeDMSMinuteField");
        gearShootingEndLatitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLatitudeDMSMinuteField.setProperty("gearShootingEndLatitudeMinute");
        gearShootingEndLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLatitudeDMSMinuteField.setShowReset(false);
        gearShootingEndLatitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeMinute"));
        gearShootingEndLatitudeDMSMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLatitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLatitudeDMSSecondField", gearShootingEndLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSSecondField.setName("gearShootingEndLatitudeDMSSecondField");
        gearShootingEndLatitudeDMSSecondField.setUseSign(false);
        gearShootingEndLatitudeDMSSecondField.setProperty("gearShootingEndLatitudeSecond");
        gearShootingEndLatitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLatitudeDMSSecondField.setShowReset(false);
        gearShootingEndLatitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLatitudeSecond"));
        gearShootingEndLatitudeDMSSecondField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLatitudeLayout() {
        $objectMap.put("gearShootingEndLatitudeLayout", gearShootingEndLatitudeLayout = new CardLayout2Ext(this, "gearShootingEndLatitudePanel"));
    }

    protected void createGearShootingEndLatitudePanel() {
        $objectMap.put("gearShootingEndLatitudePanel", gearShootingEndLatitudePanel = new JPanel());
        
        gearShootingEndLatitudePanel.setName("gearShootingEndLatitudePanel");
        gearShootingEndLatitudePanel.setLayout(gearShootingEndLatitudeLayout);
        gearShootingEndLatitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingEndLatitude.tip"));
        gearShootingEndLatitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndLatitude.help");
    }

    protected void createGearShootingEndLongitudeDDField() {
        $objectMap.put("gearShootingEndLongitudeDDField", gearShootingEndLongitudeDDField = new NumberEditor(this));
        
        gearShootingEndLongitudeDDField.setName("gearShootingEndLongitudeDDField");
        gearShootingEndLongitudeDDField.setUseSign(true);
        gearShootingEndLongitudeDDField.setProperty("gearShootingEndLongitude");
        gearShootingEndLongitudeDDField.setUseFloat(true);
        gearShootingEndLongitudeDDField.setShowReset(false);
        gearShootingEndLongitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitude"));
        gearShootingEndLongitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLongitudeDMDDegreeField() {
        $objectMap.put("gearShootingEndLongitudeDMDDegreeField", gearShootingEndLongitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMDDegreeField.setName("gearShootingEndLongitudeDMDDegreeField");
        gearShootingEndLongitudeDMDDegreeField.setUseSign(true);
        gearShootingEndLongitudeDMDDegreeField.setProperty("gearShootingEndLongitudeDegree");
        gearShootingEndLongitudeDMDDegreeField.setUseFloat(false);
        gearShootingEndLongitudeDMDDegreeField.setShowReset(false);
        gearShootingEndLongitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeDegree"));
        gearShootingEndLongitudeDMDDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLongitudeDMDMinuteField() {
        $objectMap.put("gearShootingEndLongitudeDMDMinuteField", gearShootingEndLongitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMDMinuteField.setName("gearShootingEndLongitudeDMDMinuteField");
        gearShootingEndLongitudeDMDMinuteField.setUseSign(false);
        gearShootingEndLongitudeDMDMinuteField.setProperty("gearShootingEndLongitudeDecimalMinute");
        gearShootingEndLongitudeDMDMinuteField.setUseFloat(true);
        gearShootingEndLongitudeDMDMinuteField.setShowReset(false);
        gearShootingEndLongitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeMinute"));
        gearShootingEndLongitudeDMDMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLongitudeDMSDegreeField", gearShootingEndLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSDegreeField.setName("gearShootingEndLongitudeDMSDegreeField");
        gearShootingEndLongitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLongitudeDMSDegreeField.setProperty("gearShootingEndLongitudeDegree");
        gearShootingEndLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLongitudeDMSDegreeField.setShowReset(false);
        gearShootingEndLongitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeDegree"));
        gearShootingEndLongitudeDMSDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLongitudeDMSMinuteField", gearShootingEndLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSMinuteField.setName("gearShootingEndLongitudeDMSMinuteField");
        gearShootingEndLongitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLongitudeDMSMinuteField.setProperty("gearShootingEndLongitudeMinute");
        gearShootingEndLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLongitudeDMSMinuteField.setShowReset(false);
        gearShootingEndLongitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeMinute"));
        gearShootingEndLongitudeDMSMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLongitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLongitudeDMSSecondField", gearShootingEndLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSSecondField.setName("gearShootingEndLongitudeDMSSecondField");
        gearShootingEndLongitudeDMSSecondField.setUseSign(false);
        gearShootingEndLongitudeDMSSecondField.setProperty("gearShootingEndLongitudeSecond");
        gearShootingEndLongitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLongitudeDMSSecondField.setShowReset(false);
        gearShootingEndLongitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingEndLongitudeSecond"));
        gearShootingEndLongitudeDMSSecondField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingEndLongitudeLayout() {
        $objectMap.put("gearShootingEndLongitudeLayout", gearShootingEndLongitudeLayout = new CardLayout2Ext(this, "gearShootingEndLongitudePanel"));
    }

    protected void createGearShootingEndLongitudePanel() {
        $objectMap.put("gearShootingEndLongitudePanel", gearShootingEndLongitudePanel = new JPanel());
        
        gearShootingEndLongitudePanel.setName("gearShootingEndLongitudePanel");
        gearShootingEndLongitudePanel.setLayout(gearShootingEndLongitudeLayout);
        gearShootingEndLongitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingEndLongitude.tip"));
        gearShootingEndLongitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingEndLongitude.help");
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new SimpleTimeEditor(this));
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setProperty("gearShootingEndTime");
        gearShootingEndTimeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartDateField() {
        $objectMap.put("gearShootingStartDateField", gearShootingStartDateField = new JXDatePicker());
        
        gearShootingStartDateField.setName("gearShootingStartDateField");
        gearShootingStartDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingStartDateField"));
        gearShootingStartDateField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartDate"));
        gearShootingStartDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLabel() {
        $objectMap.put("gearShootingStartLabel", gearShootingStartLabel = new JLabel());
        
        gearShootingStartLabel.setName("gearShootingStartLabel");
        gearShootingStartLabel.setText(_("tutti.editFishingOperation.field.gearShootingStart"));
        gearShootingStartLabel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingStart.tip"));
        gearShootingStartLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStart.help");
    }

    protected void createGearShootingStartLatitudeDDField() {
        $objectMap.put("gearShootingStartLatitudeDDField", gearShootingStartLatitudeDDField = new NumberEditor(this));
        
        gearShootingStartLatitudeDDField.setName("gearShootingStartLatitudeDDField");
        gearShootingStartLatitudeDDField.setUseSign(true);
        gearShootingStartLatitudeDDField.setProperty("gearShootingStartLatitude");
        gearShootingStartLatitudeDDField.setUseFloat(true);
        gearShootingStartLatitudeDDField.setShowReset(false);
        gearShootingStartLatitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitude"));
        gearShootingStartLatitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLatitudeDMDDegreeField() {
        $objectMap.put("gearShootingStartLatitudeDMDDegreeField", gearShootingStartLatitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMDDegreeField.setName("gearShootingStartLatitudeDMDDegreeField");
        gearShootingStartLatitudeDMDDegreeField.setUseSign(true);
        gearShootingStartLatitudeDMDDegreeField.setProperty("gearShootingStartLatitudeDegree");
        gearShootingStartLatitudeDMDDegreeField.setUseFloat(false);
        gearShootingStartLatitudeDMDDegreeField.setShowReset(false);
        gearShootingStartLatitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeDegree"));
        gearShootingStartLatitudeDMDDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLatitudeDMDMinuteField() {
        $objectMap.put("gearShootingStartLatitudeDMDMinuteField", gearShootingStartLatitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMDMinuteField.setName("gearShootingStartLatitudeDMDMinuteField");
        gearShootingStartLatitudeDMDMinuteField.setUseSign(false);
        gearShootingStartLatitudeDMDMinuteField.setProperty("gearShootingStartLatitudeDecimalMinute");
        gearShootingStartLatitudeDMDMinuteField.setUseFloat(true);
        gearShootingStartLatitudeDMDMinuteField.setShowReset(false);
        gearShootingStartLatitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeMinute"));
        gearShootingStartLatitudeDMDMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLatitudeDMSDegreeField", gearShootingStartLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSDegreeField.setName("gearShootingStartLatitudeDMSDegreeField");
        gearShootingStartLatitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLatitudeDMSDegreeField.setProperty("gearShootingStartLatitudeDegree");
        gearShootingStartLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLatitudeDMSDegreeField.setShowReset(false);
        gearShootingStartLatitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeDegree"));
        gearShootingStartLatitudeDMSDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLatitudeDMSMinuteField", gearShootingStartLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSMinuteField.setName("gearShootingStartLatitudeDMSMinuteField");
        gearShootingStartLatitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLatitudeDMSMinuteField.setProperty("gearShootingStartLatitudeMinute");
        gearShootingStartLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLatitudeDMSMinuteField.setShowReset(false);
        gearShootingStartLatitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeMinute"));
        gearShootingStartLatitudeDMSMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLatitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLatitudeDMSSecondField", gearShootingStartLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSSecondField.setName("gearShootingStartLatitudeDMSSecondField");
        gearShootingStartLatitudeDMSSecondField.setUseSign(false);
        gearShootingStartLatitudeDMSSecondField.setProperty("gearShootingStartLatitudeSecond");
        gearShootingStartLatitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLatitudeDMSSecondField.setShowReset(false);
        gearShootingStartLatitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLatitudeSecond"));
        gearShootingStartLatitudeDMSSecondField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLatitudeLayout() {
        $objectMap.put("gearShootingStartLatitudeLayout", gearShootingStartLatitudeLayout = new CardLayout2Ext(this, "gearShootingStartLatitudePanel"));
    }

    protected void createGearShootingStartLatitudePanel() {
        $objectMap.put("gearShootingStartLatitudePanel", gearShootingStartLatitudePanel = new JPanel());
        
        gearShootingStartLatitudePanel.setName("gearShootingStartLatitudePanel");
        gearShootingStartLatitudePanel.setLayout(gearShootingStartLatitudeLayout);
        gearShootingStartLatitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingStartLatitude.tip"));
        gearShootingStartLatitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartLatitude.help");
    }

    protected void createGearShootingStartLongitudeDDField() {
        $objectMap.put("gearShootingStartLongitudeDDField", gearShootingStartLongitudeDDField = new NumberEditor(this));
        
        gearShootingStartLongitudeDDField.setName("gearShootingStartLongitudeDDField");
        gearShootingStartLongitudeDDField.setUseSign(true);
        gearShootingStartLongitudeDDField.setProperty("gearShootingStartLongitude");
        gearShootingStartLongitudeDDField.setUseFloat(true);
        gearShootingStartLongitudeDDField.setShowReset(false);
        gearShootingStartLongitudeDDField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitude"));
        gearShootingStartLongitudeDDField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLongitudeDMDDegreeField() {
        $objectMap.put("gearShootingStartLongitudeDMDDegreeField", gearShootingStartLongitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMDDegreeField.setName("gearShootingStartLongitudeDMDDegreeField");
        gearShootingStartLongitudeDMDDegreeField.setUseSign(true);
        gearShootingStartLongitudeDMDDegreeField.setProperty("gearShootingStartLongitudeDegree");
        gearShootingStartLongitudeDMDDegreeField.setUseFloat(false);
        gearShootingStartLongitudeDMDDegreeField.setShowReset(false);
        gearShootingStartLongitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeDegree"));
        gearShootingStartLongitudeDMDDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLongitudeDMDMinuteField() {
        $objectMap.put("gearShootingStartLongitudeDMDMinuteField", gearShootingStartLongitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMDMinuteField.setName("gearShootingStartLongitudeDMDMinuteField");
        gearShootingStartLongitudeDMDMinuteField.setUseSign(false);
        gearShootingStartLongitudeDMDMinuteField.setProperty("gearShootingStartLongitudeDecimalMinute");
        gearShootingStartLongitudeDMDMinuteField.setUseFloat(true);
        gearShootingStartLongitudeDMDMinuteField.setShowReset(false);
        gearShootingStartLongitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeMinute"));
        gearShootingStartLongitudeDMDMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLongitudeDMSDegreeField", gearShootingStartLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSDegreeField.setName("gearShootingStartLongitudeDMSDegreeField");
        gearShootingStartLongitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLongitudeDMSDegreeField.setProperty("gearShootingStartLongitudeDegree");
        gearShootingStartLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLongitudeDMSDegreeField.setShowReset(false);
        gearShootingStartLongitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeDegree"));
        gearShootingStartLongitudeDMSDegreeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLongitudeDMSMinuteField", gearShootingStartLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSMinuteField.setName("gearShootingStartLongitudeDMSMinuteField");
        gearShootingStartLongitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLongitudeDMSMinuteField.setProperty("gearShootingStartLongitudeMinute");
        gearShootingStartLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLongitudeDMSMinuteField.setShowReset(false);
        gearShootingStartLongitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeMinute"));
        gearShootingStartLongitudeDMSMinuteField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLongitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLongitudeDMSSecondField", gearShootingStartLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSSecondField.setName("gearShootingStartLongitudeDMSSecondField");
        gearShootingStartLongitudeDMSSecondField.setUseSign(false);
        gearShootingStartLongitudeDMSSecondField.setProperty("gearShootingStartLongitudeSecond");
        gearShootingStartLongitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLongitudeDMSSecondField.setShowReset(false);
        gearShootingStartLongitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.gearShootingStartLongitudeSecond"));
        gearShootingStartLongitudeDMSSecondField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearShootingStartLongitudeLayout() {
        $objectMap.put("gearShootingStartLongitudeLayout", gearShootingStartLongitudeLayout = new CardLayout2Ext(this, "gearShootingStartLongitudePanel"));
    }

    protected void createGearShootingStartLongitudePanel() {
        $objectMap.put("gearShootingStartLongitudePanel", gearShootingStartLongitudePanel = new JPanel());
        
        gearShootingStartLongitudePanel.setName("gearShootingStartLongitudePanel");
        gearShootingStartLongitudePanel.setLayout(gearShootingStartLongitudeLayout);
        gearShootingStartLongitudePanel.setToolTipText(_("tutti.editFishingOperation.field.gearShootingStartLongitude.tip"));
        gearShootingStartLongitudePanel.putClientProperty("help", "tutti.editFishingOperation.field.gearShootingStartLongitude.help");
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new SimpleTimeEditor(this));
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setProperty("gearShootingStartTime");
        gearShootingStartTimeField.putClientProperty("selectOnFocus", true);
    }

    protected void createGearTimeLabel() {
        $objectMap.put("gearTimeLabel", gearTimeLabel = new JLabel());
        
        gearTimeLabel.setName("gearTimeLabel");
        gearTimeLabel.setText(_("tutti.editFishingOperation.field.gearTime"));
        gearTimeLabel.setToolTipText(_("tutti.editFishingOperation.field.gearTime.tip"));
        gearTimeLabel.putClientProperty("help", "tutti.editFishingOperation.field.gearTime.help");
    }

    protected void createGearUseFeatureTab() {
        $objectMap.put("gearUseFeatureTab", gearUseFeatureTab = new TabInfo());
    }

    protected void createGearUseFeatureTabContent() {
        $objectMap.put("gearUseFeatureTabContent", gearUseFeatureTabContent = new GearUseFeatureTabUI(this));
        
        gearUseFeatureTabContent.setName("gearUseFeatureTabContent");
    }

    protected void createGearUseFeatureTabPane() {
        $objectMap.put("gearUseFeatureTabPane", gearUseFeatureTabPane = new JXTitledPanel());
        
        gearUseFeatureTabPane.setName("gearUseFeatureTabPane");
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditFishingOperationUIHandler.class));
    }

    protected void createLocationComboBox() {
        $objectMap.put("locationComboBox", locationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        locationComboBox.setName("locationComboBox");
        locationComboBox.setI18nPrefix("tutti.property.");
        locationComboBox.setProperty("location");
        locationComboBox.setShowReset(true);
        locationComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.location"));
    }

    protected void createLocationLabel() {
        $objectMap.put("locationLabel", locationLabel = new JLabel());
        
        locationLabel.setName("locationLabel");
        locationLabel.setText(_("tutti.editFishingOperation.field.location"));
        locationLabel.setToolTipText(_("tutti.editFishingOperation.field.location.tip"));
        locationLabel.putClientProperty("help", "tutti.editFishingOperation.field.location.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditFishingOperationUIModel.class));
    }

    protected void createMultirigAggregationField() {
        $objectMap.put("multirigAggregationField", multirigAggregationField = new JTextField());
        
        multirigAggregationField.setName("multirigAggregationField");
        multirigAggregationField.setColumns(15);
        multirigAggregationField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__multirigAggregationField"));
        multirigAggregationField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.multirigAggregation"));
    }

    protected void createMultirigAggregationLabel() {
        $objectMap.put("multirigAggregationLabel", multirigAggregationLabel = new JLabel());
        
        multirigAggregationLabel.setName("multirigAggregationLabel");
        multirigAggregationLabel.setText(_("tutti.editFishingOperation.field.multirigAggregation"));
        multirigAggregationLabel.setToolTipText(_("tutti.editFishingOperation.field.multirigAggregation.tip"));
        multirigAggregationLabel.putClientProperty("help", "tutti.editFishingOperation.field.multirigAggregation.help");
    }

    protected void createRecorderPersonList() {
        $objectMap.put("recorderPersonList", recorderPersonList = new BeanDoubleList<Person>());
        
        recorderPersonList.setName("recorderPersonList");
        recorderPersonList.setI18nPrefix("tutti.property.");
        recorderPersonList.setProperty("recorderPerson");
        recorderPersonList.setShowReset(true);
        recorderPersonList.setToolTipText(_("tutti.editFishingOperation.field.recorderPerson.tip"));
        recorderPersonList.putClientProperty("help", "tutti.editFishingOperation.field.recorderPerson.help");
        recorderPersonList.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.recorderPerson"));
    }

    protected void createResetValidStateButton() {
        $objectMap.put("resetValidStateButton", resetValidStateButton = new JButton());
        
        resetValidStateButton.setName("resetValidStateButton");
        resetValidStateButton.setText(_("tutti.editFishingOperation.action.resetFishingOperationValidState"));
        resetValidStateButton.setToolTipText(_("tutti.editFishingOperation.action.resetFishingOperationValidState.tip"));
        resetValidStateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetValidStateButton"));
        resetValidStateButton.putClientProperty("help", "tutti.editFishingOperation.action.resetFishingOperationValidState.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editFishingOperation.action.saveFishingOperation"));
        saveButton.setToolTipText(_("tutti.editFishingOperation.action.saveEditFishingOperation.tip"));
        saveButton.putClientProperty("help", "tutti.editFishingOperation.action.saveEditFishingOperation.help");
        saveButton.putClientProperty("tuttiAction", SaveFishingOperationAction.class);
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new JTextField());
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setColumns(15);
        stationNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__stationNumberField"));
        stationNumberField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.stationNumber"));
        stationNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createStationNumberLabel() {
        $objectMap.put("stationNumberLabel", stationNumberLabel = new JLabel());
        
        stationNumberLabel.setName("stationNumberLabel");
        stationNumberLabel.setText(_("tutti.editFishingOperation.field.stationNumber"));
        stationNumberLabel.setToolTipText(_("tutti.editFishingOperation.field.stationNumber.tip"));
        stationNumberLabel.putClientProperty("help", "tutti.editFishingOperation.field.stationNumber.help");
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setI18nPrefix("tutti.property.");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
        strataComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.strata"));
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(_("tutti.editFishingOperation.field.strata"));
        strataLabel.setToolTipText(_("tutti.editFishingOperation.field.strata.tip"));
        strataLabel.putClientProperty("help", "tutti.editFishingOperation.field.strata.help");
    }

    protected void createSubStrataComboBox() {
        $objectMap.put("subStrataComboBox", subStrataComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        subStrataComboBox.setName("subStrataComboBox");
        subStrataComboBox.setI18nPrefix("tutti.property.");
        subStrataComboBox.setProperty("subStrata");
        subStrataComboBox.setShowReset(true);
        subStrataComboBox.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.subStrata"));
    }

    protected void createSubStrataLabel() {
        $objectMap.put("subStrataLabel", subStrataLabel = new JLabel());
        
        subStrataLabel.setName("subStrataLabel");
        subStrataLabel.setText(_("tutti.editFishingOperation.field.subStrata"));
        subStrataLabel.setToolTipText(_("tutti.editFishingOperation.field.subStrata.tip"));
        subStrataLabel.putClientProperty("help", "tutti.editFishingOperation.field.subStrata.help");
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
    }

    protected void createTraitGeneralTabPane() {
        $objectMap.put("traitGeneralTabPane", traitGeneralTabPane = new JXTitledPanel());
        
        traitGeneralTabPane.setName("traitGeneralTabPane");
    }

    protected void createTraitGeneralTabPaneToolBar() {
        $objectMap.put("traitGeneralTabPaneToolBar", traitGeneralTabPaneToolBar = new JToolBar());
        
        traitGeneralTabPaneToolBar.setName("traitGeneralTabPaneToolBar");
        traitGeneralTabPaneToolBar.setFloatable(false);
        traitGeneralTabPaneToolBar.setOpaque(false);
        traitGeneralTabPaneToolBar.setBorderPainted(false);
    }

    protected void createTraitVesselPanel() {
        $objectMap.put("traitVesselPanel", traitVesselPanel = new Table());
        
        traitVesselPanel.setName("traitVesselPanel");
    }

    protected void createTrawlDistanceField() {
        $objectMap.put("trawlDistanceField", trawlDistanceField = new NumberEditor(this));
        
        trawlDistanceField.setName("trawlDistanceField");
        trawlDistanceField.setProperty("trawlDistance");
        trawlDistanceField.setUseFloat(false);
        trawlDistanceField.setShowReset(true);
        trawlDistanceField.putClientProperty("validatorLabel", _("tutti.editFishingOperation.field.trawlDistance"));
        trawlDistanceField.putClientProperty("selectOnFocus", true);
    }

    protected void createTrawlDistanceLabel() {
        $objectMap.put("trawlDistanceLabel", trawlDistanceLabel = new JLabel());
        
        trawlDistanceLabel.setName("trawlDistanceLabel");
        trawlDistanceLabel.setText(_("tutti.editFishingOperation.field.trawlDistance"));
        trawlDistanceLabel.setToolTipText(_("tutti.editFishingOperation.field.trawlDistance.tip"));
        trawlDistanceLabel.putClientProperty("help", "tutti.editFishingOperation.field.trawlDistance.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditFishingOperationUIModel.class, "validate"));
    }

    protected void createVesselField() {
        $objectMap.put("vesselField", vesselField = new JLabel());
        
        vesselField.setName("vesselField");
        vesselField.putClientProperty("strongStyle", true);
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(_("tutti.editFishingOperation.field.vessel"));
        vesselLabel.setToolTipText(_("tutti.editFishingOperation.field.vessel.tip"));
        vesselLabel.putClientProperty("help", "tutti.editFishingOperation.field.vessel.help");
    }

    protected void createVesselUseFeatureTab() {
        $objectMap.put("vesselUseFeatureTab", vesselUseFeatureTab = new TabInfo());
    }

    protected void createVesselUseFeatureTabContent() {
        $objectMap.put("vesselUseFeatureTabContent", vesselUseFeatureTabContent = new VesselUseFeatureTabUI(this));
        
        vesselUseFeatureTabContent.setName("vesselUseFeatureTabContent");
    }

    protected void createVesselUseFeatureTabPane() {
        $objectMap.put("vesselUseFeatureTabPane", vesselUseFeatureTabPane = new JXTitledPanel());
        
        vesselUseFeatureTabPane.setName("vesselUseFeatureTabPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditFishingOperationTopPanel();
        addChildrenToValidator();
        addChildrenToTraitGeneralTabPaneToolBar();
        addChildrenToFishingOperationPane();
        addChildrenToFishingOperationTabPane();
        addChildrenToTraitGeneralTabPane();
        addChildrenToFishingOperationTabScrollPane();
        addChildrenToGeneralForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(gearCaracteristicsTable, BorderLayout.CENTER);
        addChildrenToGearCaracteristicsTable();
        addChildrenToGearShootingStartLatitudePanel();
        // inline complete setup of $JPanel2
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSDegreeField));
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSMinuteField));
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSSecondField));
        // inline complete setup of $JPanel3
        $JPanel3.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMDDegreeField));
        $JPanel3.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMDMinuteField));
        addChildrenToGearShootingStartLongitudePanel();
        // inline complete setup of $JPanel4
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSDegreeField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSMinuteField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSSecondField));
        // inline complete setup of $JPanel5
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMDDegreeField));
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMDMinuteField));
        addChildrenToGearShootingEndLatitudePanel();
        // inline complete setup of $JPanel6
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSDegreeField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSMinuteField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSSecondField));
        // inline complete setup of $JPanel7
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMDDegreeField));
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMDMinuteField));
        addChildrenToGearShootingEndLongitudePanel();
        // inline complete setup of $JPanel8
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSDegreeField));
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSMinuteField));
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSSecondField));
        // inline complete setup of $JPanel9
        $JPanel9.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMDDegreeField));
        $JPanel9.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMDMinuteField));
        // inline complete setup of $JPanel10
        $JPanel10.add(trawlDistanceLabel, BorderLayout.WEST);
        $JPanel10.add(SwingUtil.boxComponentWithJxLayer(trawlDistanceField), BorderLayout.CENTER);
        // inline complete setup of $JPanel11
        $JPanel11.add(durationLabel, BorderLayout.WEST);
        $JPanel11.add(durationField, BorderLayout.CENTER);
        addChildrenToFishingOperationValidPanel();
        addChildrenToFishingOperationResetRadio();
        // inline complete setup of $HBox0
        $HBox0.add(fishingOperationValidRadio);
        $HBox0.add(fishingOperationInvalidRadio);
        addChildrenToFishingOperationValidRadio();
        addChildrenToFishingOperationInvalidRadio();
        // inline complete setup of $JPanel13
        $JPanel13.add(SwingUtil.boxComponentWithJxLayer(recorderPersonList));
        $JPanel13.add(traitVesselPanel);
        addChildrenToTraitVesselPanel();
        addChildrenToCommentPane();
        addChildrenToGearUseFeatureTabPane();
        addChildrenToVesselUseFeatureTabPane();
        // inline complete setup of $JPanel14
        $JPanel14.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 65 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 143 property setters
        strataComboBox.setBeanType(TuttiLocation.class);
        subStrataComboBox.setBeanType(TuttiLocation.class);
        locationComboBox.setBeanType(TuttiLocation.class);
        recorderPersonList.setBeanType(Person.class);
        gearComboBox.setBeanType(Gear.class);
        gearShootingStartLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingStartLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        traitGeneralTabPane.setRightDecoration(traitGeneralTabPaneToolBar);
        stationNumberLabel.setLabelFor(stationNumberField);
        fishingOperationNumberLabel.setLabelFor(fishingOperationNumberField);
        fishingOperationNumberField.setBean(model);
        fishingOperationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        fishingOperationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        multirigAggregationLabel.setLabelFor(multirigAggregationField);
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        subStrataLabel.setLabelFor(subStrataComboBox);
        subStrataComboBox.setBean(model);
        locationLabel.setLabelFor(locationComboBox);
        locationComboBox.setBean(model);
        gearLatitudeLabel.setText(_(handler.getGearLatitudeLabelText(handler.getConfig().getCoordinateEditorType())));
        gearLatitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearLongitudeLabel.setText(_(handler.getGearLongitudeLabelText(handler.getConfig().getCoordinateEditorType())));
        gearLongitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearDateLabel.setIcon(SwingUtil.createActionIcon("calendar"));
        gearTimeLabel.setIcon(SwingUtil.createActionIcon("time"));
        gearShootingStartLatitudeDDField.setBean(model);
        gearShootingStartLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSDegreeField.setBean(model);
        gearShootingStartLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSMinuteField.setBean(model);
        gearShootingStartLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSSecondField.setBean(model);
        gearShootingStartLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMDDegreeField.setBean(model);
        gearShootingStartLatitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMDMinuteField.setBean(model);
        gearShootingStartLatitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDDField.setBean(model);
        gearShootingStartLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSDegreeField.setBean(model);
        gearShootingStartLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSMinuteField.setBean(model);
        gearShootingStartLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSSecondField.setBean(model);
        gearShootingStartLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMDDegreeField.setBean(model);
        gearShootingStartLongitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMDMinuteField.setBean(model);
        gearShootingStartLongitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartTimeField.setBean(model);
        gearShootingEndLatitudeDDField.setBean(model);
        gearShootingEndLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSDegreeField.setBean(model);
        gearShootingEndLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSMinuteField.setBean(model);
        gearShootingEndLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSSecondField.setBean(model);
        gearShootingEndLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMDDegreeField.setBean(model);
        gearShootingEndLatitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMDMinuteField.setBean(model);
        gearShootingEndLatitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDDField.setBean(model);
        gearShootingEndLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSDegreeField.setBean(model);
        gearShootingEndLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSMinuteField.setBean(model);
        gearShootingEndLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSSecondField.setBean(model);
        gearShootingEndLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMDDegreeField.setBean(model);
        gearShootingEndLongitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMDMinuteField.setBean(model);
        gearShootingEndLongitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndTimeField.setBean(model);
        trawlDistanceLabel.setLabelFor(trawlDistanceField);
        trawlDistanceField.setBean(model);
        trawlDistanceField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        trawlDistanceField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        durationLabel.setLabelFor(durationField);
        resetValidStateButton.setIcon(SwingUtil.createActionIcon("reset"));
        resetValidStateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editFishingOperation.action.resetFishingOperationValidState.mnemonic"),'Z'));
        recorderPersonList.setBean(model);
        recorderPersonList.setBorder(BorderFactory.createTitledBorder(_("tutti.editFishingOperation.field.recorderPerson")));
        traitVesselPanel.setBorder(BorderFactory.createTitledBorder(_("tutti.editFishingOperation.pane.other")));
        vesselLabel.setLabelFor(vesselField);
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        gearLabel.setLabelFor(gearComboBox);
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        gearComboBox.setBean(model);
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.editFishingOperation.field.comment")));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editFishingOperation.action.cancelEditFishingOperation.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editFishingOperation.action.saveEditFishingOperation.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editFishingOperationTopPanel, "tutti.editFishingOperation.help");
        registerHelpId(_broker, fishingOperationAttachmentsButton, "tutti.editFishingOperation.action.attachments.help");
        registerHelpId(_broker, stationNumberLabel, "tutti.editFishingOperation.field.stationNumber.help");
        registerHelpId(_broker, fishingOperationNumberLabel, "tutti.editFishingOperation.field.fishingOperationNumber.help");
        registerHelpId(_broker, multirigAggregationLabel, "tutti.editFishingOperation.field.multirigAggregation.help");
        registerHelpId(_broker, strataLabel, "tutti.editFishingOperation.field.strata.help");
        registerHelpId(_broker, subStrataLabel, "tutti.editFishingOperation.field.subStrata.help");
        registerHelpId(_broker, locationLabel, "tutti.editFishingOperation.field.location.help");
        registerHelpId(_broker, gearLatitudeLabel, "tutti.editFishingOperation.field.gearLatitude.help");
        registerHelpId(_broker, gearLongitudeLabel, "tutti.editFishingOperation.field.gearLongitude.help");
        registerHelpId(_broker, gearDateLabel, "tutti.editFishingOperation.field.gearDate.help");
        registerHelpId(_broker, gearTimeLabel, "tutti.editFishingOperation.field.gearTime.help");
        registerHelpId(_broker, gearShootingStartLabel, "tutti.editFishingOperation.field.gearShootingStart.help");
        registerHelpId(_broker, gearShootingStartLatitudePanel, "tutti.editFishingOperation.field.gearShootingStartLatitude.help");
        registerHelpId(_broker, gearShootingStartLongitudePanel, "tutti.editFishingOperation.field.gearShootingStartLongitude.help");
        registerHelpId(_broker, gearShootingEndLabel, "tutti.editFishingOperation.field.gearShootingEnd.help");
        registerHelpId(_broker, gearShootingEndLatitudePanel, "tutti.editFishingOperation.field.gearShootingEndLatitude.help");
        registerHelpId(_broker, gearShootingEndLongitudePanel, "tutti.editFishingOperation.field.gearShootingEndLongitude.help");
        registerHelpId(_broker, fishingOperationRectiligneCheckBox, "tutti.editFishingOperation.field.fishingOperationRectiligne.help");
        registerHelpId(_broker, trawlDistanceLabel, "tutti.editFishingOperation.field.trawlDistance.help");
        registerHelpId(_broker, durationLabel, "tutti.editFishingOperation.field.duration.help");
        registerHelpId(_broker, fishingOperationValidPanel, "tutti.editFishingOperation.field.fishingOperationValid.help");
        registerHelpId(_broker, resetValidStateButton, "tutti.editFishingOperation.action.resetFishingOperationValidState.help");
        registerHelpId(_broker, recorderPersonList, "tutti.editFishingOperation.field.recorderPerson.help");
        registerHelpId(_broker, vesselLabel, "tutti.editFishingOperation.field.vessel.help");
        registerHelpId(_broker, gearLabel, "tutti.editFishingOperation.field.gear.help");
        registerHelpId(_broker, commentPane, "tutti.editFishingOperation.field.comment.help");
        registerHelpId(_broker, cancelButton, "tutti.editFishingOperation.action.cancelEditFishingOperation.help");
        registerHelpId(_broker, saveButton, "tutti.editFishingOperation.action.saveEditFishingOperation.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editFishingOperationTopPanel", editFishingOperationTopPanel);
        createHandler();
        createModel();
        createValidator();
        createGearShootingStartLongitudeLayout();
        createGearShootingStartLatitudeLayout();
        createGearShootingEndLongitudeLayout();
        createGearShootingEndLatitudeLayout();
        createBroker();
        createTraitGeneralTabPaneToolBar();
        createFishingOperationAttachmentsButton();
        createFishingOperationPane();
        createFishingOperationTabPane();
        createTraitGeneralTabPane();
        createFishingOperationTabScrollPane();
        createGeneralForm();
        createStationNumberLabel();
        createStationNumberField();
        createFishingOperationNumberLabel();
        createFishingOperationNumberField();
        createMultirigAggregationLabel();
        createMultirigAggregationField();
        createStrataLabel();
        createStrataComboBox();
        createSubStrataLabel();
        createSubStrataComboBox();
        createLocationLabel();
        createLocationComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createGearCaracteristicsTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createGearLatitudeLabel();
        createGearLongitudeLabel();
        createGearDateLabel();
        createGearTimeLabel();
        createGearShootingStartLabel();
        createGearShootingStartLatitudePanel();
        createGearShootingStartLatitudeDDField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createGearShootingStartLatitudeDMSDegreeField();
        createGearShootingStartLatitudeDMSMinuteField();
        createGearShootingStartLatitudeDMSSecondField();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createGearShootingStartLatitudeDMDDegreeField();
        createGearShootingStartLatitudeDMDMinuteField();
        createGearShootingStartLongitudePanel();
        createGearShootingStartLongitudeDDField();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1,0));
        createGearShootingStartLongitudeDMSDegreeField();
        createGearShootingStartLongitudeDMSMinuteField();
        createGearShootingStartLongitudeDMSSecondField();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,0));
        createGearShootingStartLongitudeDMDDegreeField();
        createGearShootingStartLongitudeDMDMinuteField();
        createGearShootingStartDateField();
        createGearShootingStartTimeField();
        createGearShootingEndLabel();
        createGearShootingEndLatitudePanel();
        createGearShootingEndLatitudeDDField();
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new GridLayout(1,0));
        createGearShootingEndLatitudeDMSDegreeField();
        createGearShootingEndLatitudeDMSMinuteField();
        createGearShootingEndLatitudeDMSSecondField();
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,0));
        createGearShootingEndLatitudeDMDDegreeField();
        createGearShootingEndLatitudeDMDMinuteField();
        createGearShootingEndLongitudePanel();
        createGearShootingEndLongitudeDDField();
        // inline creation of $JPanel8
        $objectMap.put("$JPanel8", $JPanel8 = new JPanel());
        
        $JPanel8.setName("$JPanel8");
        $JPanel8.setLayout(new GridLayout(1,0));
        createGearShootingEndLongitudeDMSDegreeField();
        createGearShootingEndLongitudeDMSMinuteField();
        createGearShootingEndLongitudeDMSSecondField();
        // inline creation of $JPanel9
        $objectMap.put("$JPanel9", $JPanel9 = new JPanel());
        
        $JPanel9.setName("$JPanel9");
        $JPanel9.setLayout(new GridLayout(1,0));
        createGearShootingEndLongitudeDMDDegreeField();
        createGearShootingEndLongitudeDMDMinuteField();
        createGearShootingEndDateField();
        createGearShootingEndTimeField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFishingOperationRectiligneCheckBox();
        // inline creation of $JPanel10
        $objectMap.put("$JPanel10", $JPanel10 = new JPanel());
        
        $JPanel10.setName("$JPanel10");
        $JPanel10.setLayout(new BorderLayout());
        createTrawlDistanceLabel();
        createTrawlDistanceField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JPanel11
        $objectMap.put("$JPanel11", $JPanel11 = new JPanel());
        
        $JPanel11.setName("$JPanel11");
        $JPanel11.setLayout(new BorderLayout());
        createDurationLabel();
        createDurationField();
        createFishingOperationValidPanel();
        createResetValidStateButton();
        createFishingOperationResetRadio();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFishingOperationValidRadio();
        createFishingOperationInvalidRadio();
        // inline creation of $JPanel12
        $objectMap.put("$JPanel12", $JPanel12 = new JPanel());
        
        $JPanel12.setName("$JPanel12");
        // inline creation of $JPanel13
        $objectMap.put("$JPanel13", $JPanel13 = new JPanel());
        
        $JPanel13.setName("$JPanel13");
        $JPanel13.setLayout(new GridLayout(1,0));
        createRecorderPersonList();
        createTraitVesselPanel();
        createVesselLabel();
        createVesselField();
        createGearLabel();
        createGearComboBox();
        createCommentPane();
        createCommentField();
        createGearUseFeatureTabPane();
        createGearUseFeatureTabContent();
        createVesselUseFeatureTabPane();
        createVesselUseFeatureTabContent();
        // inline creation of $JPanel14
        $objectMap.put("$JPanel14", $JPanel14 = new JPanel());
        
        $JPanel14.setName("$JPanel14");
        $JPanel14.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createTraitGeneralTab();
        createGearUseFeatureTab();
        createVesselUseFeatureTab();
        createFishingOperationValid();
        // inline creation of editFishingOperationTopPanel
        setName("editFishingOperationTopPanel");
        setLayout(new BorderLayout());
        editFishingOperationTopPanel.putClientProperty("help", "tutti.editFishingOperation.help");
        
        // registers 65 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 65 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationAttachmentsButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(stationNumberField, model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationNumberField.setModel(model.getFishingOperationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                fishingOperationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigAggregation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(multirigAggregationField, model.getMultirigAggregation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigAggregation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subStrata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subStrataComboBox.setSelectedItem(model.getSubStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subStrata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("location", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    locationComboBox.setSelectedItem(model.getLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("location", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDDField.setModel(model.getGearShootingStartLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSDegreeField.setModel(model.getGearShootingStartLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSMinuteField.setModel(model.getGearShootingStartLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSSecondField.setModel(model.getGearShootingStartLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMDDegreeField.setModel(model.getGearShootingStartLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMDDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMDMinuteField.setModel(model.getGearShootingStartLatitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDDField.setModel(model.getGearShootingStartLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSDegreeField.setModel(model.getGearShootingStartLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSMinuteField.setModel(model.getGearShootingStartLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSSecondField.setModel(model.getGearShootingStartLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMDDegreeField.setModel(model.getGearShootingStartLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMDDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMDMinuteField.setModel(model.getGearShootingStartLongitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDateField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartTimeField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDDField.setModel(model.getGearShootingEndLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSDegreeField.setModel(model.getGearShootingEndLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSMinuteField.setModel(model.getGearShootingEndLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSSecondField.setModel(model.getGearShootingEndLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMDDegreeField.setModel(model.getGearShootingEndLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMDDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMDMinuteField.setModel(model.getGearShootingEndLatitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDDField.setModel(model.getGearShootingEndLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSDegreeField.setModel(model.getGearShootingEndLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSMinuteField.setModel(model.getGearShootingEndLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSSecondField.setModel(model.getGearShootingEndLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMDDegreeField.setModel(model.getGearShootingEndLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMDDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMDMinuteField.setModel(model.getGearShootingEndLongitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDateField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndTimeField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationRectiligneCheckBox.setSelected(model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setEnabled(!model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setModel(model.getTrawlDistance());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                trawlDistanceField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setToolTipText(_(handler.getTrawlDistanceTooltipText(model.getTrawlDistance())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DURATION_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(durationField, handler.getDuration(model.getGearShootingStartDate(), model.getGearShootingEndDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationResetRadio.setSelected(model.getFishingOperationValid() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationValidRadio.setSelected(model.getFishingOperationValid() == Boolean.TRUE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationInvalidRadio.setSelected(model.getFishingOperationValid() == Boolean.FALSE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vessel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselField.setText(_(handler.decorateVessel(model.getVessel())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vessel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gear", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearComboBox.setSelectedItem(model.getGear());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gear", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid() && model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
    }

}