/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiActionSwingWorker<A extends AbstractTuttiAction>
extends SwingWorker<Void, String> {
    private static final Log log = LogFactory.getLog(TuttiActionSwingWorker.class);
    private static final Timer t = new Timer();
    protected final TuttiActionUI actionUI;
    protected final A action;
    protected Throwable error;
    protected TimerTask timer;

    protected TuttiActionSwingWorker(A action) {
        this.action = action;
        this.actionUI = ((AbstractTuttiAction)((Object)action)).getContext().getActionUI();
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        if (!this.isCancelled()) {
            this.timer = new TuttiActionTimerTask();
            t.schedule(this.timer, 1000L);
            try {
                ((AbstractTuttiAction)((Object)this.action)).doAction();
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Task [" + this + "] Error while doAction: "), e);
                }
                this.error = e;
            }
            finally {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Task [" + this + "] done"));
                }
            }
        }
        return null;
    }

    @Override
    protected void done() {
        super.done();
        if (log.isInfoEnabled()) {
            log.info((Object)("Task [" + this + "] execute done method after all"));
        }
        if (this.error == null) {
            ((AbstractTuttiAction)((Object)this.action)).postSuccessAction();
        } else {
            ((AbstractTuttiAction)((Object)this.action)).postFailedAction(this.error);
        }
        ((AbstractTuttiAction)((Object)this.action)).releaseAction();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.actionUI.close();
        this.updateBusyState(false);
    }

    protected void updateBusyState(boolean busy) {
        boolean hideBody = ((AbstractTuttiAction)((Object)this.action)).isHideBody();
        ((AbstractTuttiAction)((Object)this.action)).getContext().setBusy(busy);
        if (hideBody) {
            ((AbstractTuttiAction)((Object)this.action)).getContext().setHideBody(!busy);
        }
    }

    protected class TuttiActionTimerTask
    extends TimerTask {
        public TuttiActionTimerTask() {
            TuttiActionSwingWorker.this.action.addPropertyChangeListener("done", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (TuttiActionSwingWorker.this.actionUI.isVisible()) {
                        TuttiActionSwingWorker.this.actionUI.close();
                    }
                    TuttiActionTimerTask.this.cancel();
                }
            });
        }

        @Override
        public void run() {
            if (TuttiActionSwingWorker.this.isCancelled() || TuttiActionSwingWorker.this.isDone()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + TuttiActionSwingWorker.this.action + "] was already canceled or done, do nothing"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + TuttiActionSwingWorker.this.action + "] is started, show waiting dialog"));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TuttiActionSwingWorker.this.actionUI.open((AbstractTuttiAction)((Object)TuttiActionSwingWorker.this.action));
                    }
                });
            }
        }
    }
}

