package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolSpeciesTableModel.java 678 2013-03-25 17:44:48Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolSpeciesTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author kmorin
 * @since 0.3
 */
public class EditProtocolSpeciesTableModel extends AbstractTuttiTableModel<EditProtocolSpeciesRowModel> {

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SPECIES_ID = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_SPECIES,
            n_("tutti.editProtocol.table.header.speciesReferenceTaxonId"),
            n_("tutti.editProtocol.table.header.speciesReferenceTaxonId.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SURVEY_CODE_ID = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_SPECIES_SURVEY_CODE,
            n_("tutti.editProtocol.table.header.speciesSurveyCode"),
            n_("tutti.editProtocol.table.header.speciesSurveyCode.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SIZE_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_SIZE_ENABLED,
            n_("tutti.editProtocol.table.header.size"),
            n_("tutti.editProtocol.table.header.size.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> SEX_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_SEX_ENABLED,
            n_("tutti.editProtocol.table.header.sex"),
            n_("tutti.editProtocol.table.header.sex.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> MATURITY_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_MATURITY_ENABLED,
            n_("tutti.editProtocol.table.header.maturity"),
            n_("tutti.editProtocol.table.header.maturity.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> AGE_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_AGE_ENABLED,
            n_("tutti.editProtocol.table.header.age"),
            n_("tutti.editProtocol.table.header.age.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> LENGTH_STEP_PMFM_ID = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_LENGTH_STEP_PMFM,
            n_("tutti.editProtocol.table.header.lengthStep"),
            n_("tutti.editProtocol.table.header.lengthStep.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> WEIGHT_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_WEIGHT_ENABLED,
            n_("tutti.editProtocol.table.header.weight"),
            n_("tutti.editProtocol.table.header.weight.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> COUNT_IF_NO_FREQUENCY_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_COUNT_IF_NO_FREQUENCY_ENABLED,
            n_("tutti.editProtocol.table.header.countIfNoFrequency"),
            n_("tutti.editProtocol.table.header.countIfNoFrequency.tip"));

    public static final ColumnIdentifier<EditProtocolSpeciesRowModel> CALCIFY_SAMPLE_ENABLED = ColumnIdentifier.newId(
            EditProtocolSpeciesRowModel.PROPERTY_CALCIFY_SAMPLE_ENABLED,
            n_("tutti.editProtocol.table.header.calcifySample"),
            n_("tutti.editProtocol.table.header.calcifySample.tip"));

    private static final long serialVersionUID = 1L;

    public EditProtocolSpeciesTableModel(TableColumnModelExt columnModel) {
        super(columnModel, false, false);

        setNoneEditableCols(SPECIES_ID);
    }

    public static EditProtocolSpeciesRowModel newRow() {
        EditProtocolSpeciesRowModel result = new EditProtocolSpeciesRowModel();
        result.setMaturityEnabled(true);
        result.setSizeEnabled(true);
        result.setSexEnabled(true);
        result.setAgeEnabled(true);
        result.setWeightEnabled(true);
        result.setCountIfNoFrequencyEnabled(true);
        result.setCalcifySampleEnabled(true);
        result.setValid(true);
        return result;
    }

    @Override
    public EditProtocolSpeciesRowModel createNewRow() {
        EditProtocolSpeciesRowModel result = newRow();
        return result;
    }

    @Override
    protected void setValueAt(Object aValue,
                              int rowIndex,
                              int columnIndex,
                              ColumnIdentifier<EditProtocolSpeciesRowModel> propertyName,
                              EditProtocolSpeciesRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        fireTableCellUpdated(rowIndex, columnIndex);
    }

}
